<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:math="http://exslt.org/math"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:odf="org.ametys.odf.OdfXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                extension-element-prefixes="resolver exslt">
    
    <xsl:import href="skin://services/web/pages/services/common.xsl"/>    

    <xsl:variable name="header" select="ametys:serviceParameter('header')/text()"/>
    <xsl:variable name="subtitle" select="ametys:serviceParameter('subtitle')/text()"/>
    <xsl:variable name="searchPageId" select="ametys:serviceParameter('search-page')/text()"/>
    <xsl:variable name="refTableId" select="ametys:serviceParameter('refTableId')/text()"/>
    <xsl:variable name="lowercase" select="'abcdefghijklmnopqrstuvwxyz'" />
    <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
    <xsl:variable name="iconFolderName" select="translate(substring-after($refTableId, 'odf-enumeration.'), $uppercase, $lowercase)"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="is-empty" select="count(items/item) = 0"/>    
    <xsl:variable name="common-service-css-class-name">service-odf-refitems second-nav</xsl:variable> 
    
    <xsl:template name="common-service-head-css">
        <!-- BEGIN head-css-slick-carousel -->
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('templates/common/js/vendor/slick/slick.css')}" type="text/css" />
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('templates/common/js/vendor/slick/slick-theme.css')}" type="text/css" />
        <!-- END head-css-slick-carousel -->
        
        <link media="screen, print" rel="stylesheet" href="{ametys:skinURL('templates/common/scss/carousel.css')}" type="text/css" />
        <link media="screen, print" rel="stylesheet" href="{ametys:skinURL('zones/second-nav/second-nav.css')}" type="text/css" />
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{ametys:skinURL('templates/common/js/vendor/slick/slick.js')}"></script>
        <script type="text/javascript" src="{$uri-prefix}/skins/{$skin}/resources/templates/common/js/carousel.{$lang}.js"></script>
        
        <script type="text/javascript">
          $j(function(){
              Carousel.initialize('#second-nav-<xsl:value-of select="$uniqueId"/>', {
                regionLabel: "<xsl:value-of select="$header"/>",
                slidesToShow: 5,
		        slidesToScroll: 5,
                responsive: [
		              {
		                breakpoint: 751,
		                settings: {
		                  slidesToShow: 4,
		                  slidesToScroll: 4,
		                },
		              },
		              {
		                breakpoint: 600,
		                settings: {
		                  slidesToShow: 3,
		                  slidesToScroll: 3,
		                },
		              },
		              {
		                breakpoint: 415,
		                settings: "unslick",
		              }
		            ]
              });
          })
        </script>
    </xsl:template>
    
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>        
        </xsl:call-template>
    </xsl:template>   
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>    
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">  
        <xsl:if test="$subtitle != ''">
            <h2 class="service-subtitle">
                <xsl:call-template name="text.nl2br">
                    <xsl:with-param name="input"><xsl:value-of select="$subtitle"/></xsl:with-param>
                </xsl:call-template>
            </h2>
        </xsl:if>
        
        <div id="second-nav-{$uniqueId}">
            <div class="second-nav-items" data-carousel="true">
                <xsl:apply-templates select="/items/item"/>
            </div>
            
            <div class="second-nav-wrapper" data-carousel-nav="true"></div>
        </div>
    </xsl:template>  
    
    <!-- Item to exclude -->
    <xsl:template match="item[@code = 'HD']"/>
    
    <xsl:template match="item">
        <div class="second-nav-item">
            <xsl:choose>
                <xsl:when test="/items/search-form/criterion">
                    <form action="{resolver:resolve('page', $searchPageId)}" method="POST">
                        <input type="hidden" name="user.input.criterion.{/items/search-form/criterion}" value="{@id}"/>
                        <input type="hidden" name="submit-form"/>
                        <a href="javascript:void(0)" onclick="$j(this).parent('form').submit()">
                            <xsl:apply-templates select="." mode="ref-item-icon"/>
                            <xsl:apply-templates select="." mode="ref-item-title"/>
                        </a>
                    </form>
                </xsl:when>
                <xsl:otherwise>
                    <a href="javascript:void(0)" onclick="$j(this).parent('form').submit()">
                        <xsl:apply-templates select="." mode="ref-item-icon"/>
                        <xsl:apply-templates select="." mode="ref-item-title"/>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template match="item" mode="ref-item-title">
        <span class="link"><xsl:value-of select="."/></span>
    </xsl:template>
    
    <xsl:template match="item" mode="ref-item-icon">
        <xsl:variable name="iconUrl" select="concat('templates/common/img/icon/', $iconFolderName, '/', @code, '.svg')"/>
        <img data-svg="true" src="{ametys:skinURL($iconUrl)}" alt=""/>
    </xsl:template>
    
</xsl:stylesheet>