<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->

<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:exsl="http://exslt.org/common"
        exclude-result-prefixes="ametys resolver"> 
        
    <!-- The label for fulltext search field -->
    <xsl:variable name="searchInputLabel" select="ametys:serviceViewParameter('searchInputLabel')"/>
    <!-- The placeholder for fulltext search field -->
    <xsl:variable name="searchInputPlaceholder" select="ametys:serviceViewParameter('searchInputPlaceholder')"/>

    <!-- Prefix for "Full text" criteria -->
    <xsl:variable name="fulltextCriteriaPrefix">user.input.criterion.common$wording$textfield</xsl:variable>
    <!-- Prefix for "Title or full text" criteria -->
    <xsl:variable name="titleOrFulltextCriteriaPrefix">user.input.criterion.common$titleorwording$textfield</xsl:variable>
    
    <xsl:template name="form-criteria">
        <xsl:call-template name="js-sumit-bo"/>
        <form role="search" method="post" class="form search" data-ametys-search-role="form" name="{$search-form-id}" id="{$search-form-id}">
            <xsl:if test="$result-display-type = 'IN_PLACE_OF_CRITERIA' and /search/hits and /search/hits/@total > 0">
                <xsl:attribute name="style">display: none;</xsl:attribute>
            </xsl:if>
            <xsl:if test="$result-display-type = 'ON_PAGE'">
                <xsl:attribute name="action"><xsl:value-of select="resolver:resolve('page', /search/result-page)"/>#<xsl:value-of select="$anchor-id" /></xsl:attribute>
            </xsl:if>
            
            <xsl:call-template name="form-search"/>
        </form> 
    </xsl:template>
    
    <xsl:template match="criterion" mode="field">
        <xsl:param name="value"/>
        
        <div class="field">
            <xsl:apply-templates select="." mode="field-label"/>
                
            <xsl:apply-templates select="." mode="field-input">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </div>
    </xsl:template>
    
    <xsl:template match="criterion" mode="field-input">
    </xsl:template>
    
    <xsl:template match="criterion" mode="field-label">
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <xsl:variable name="labelFor"><xsl:value-of select="$id"/><xsl:if test="type = 'date' or type = 'datetime'">-clone</xsl:if></xsl:variable>
        <label for="{$labelFor}">
        	<xsl:apply-templates select="." mode="field-label-text"/>
        </label>
    </xsl:template>
    
    <xsl:template match="criterion[starts-with(@name, $titleOrFulltextCriteriaPrefix) or starts-with(@name, $fulltextCriteriaPrefix)]" mode="field-label-text">
        <xsl:choose>
            <xsl:when test="$searchInputLabel != ''">
                <xsl:value-of select="$searchInputLabel"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="label"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="criterion" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <input id="{$id}" type="text" name="{@name}" value="{$value}">
            <xsl:apply-templates select="." mode="field-input-placeholder"/>
        </input>
    </xsl:template>
    
    <xsl:template match="criterion[starts-with(@name, $titleOrFulltextCriteriaPrefix) or starts-with(@name, $fulltextCriteriaPrefix)]" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        
        <div class="autocomplete" role="combobox" aria-expanded="false" aria-haspopup="listbox" id="search-autocomplete-{$uniqueId}">
            <input id="{$id}" type="search" name="{@name}" value="{$value}" autocomplete="off" aria-autocomplete="list" aria-controls="autocomplete-list-{$uniqueId}" data-autocomplete-target="#autocomplete-list-{$uniqueId}">
                <xsl:apply-templates select="." mode="field-input-placeholder"/>
            </input>
            
            <xsl:call-template name="autocomplete-dropdown"/>
        </div>
        
        <xsl:call-template name="autocomplete-js"/>
    </xsl:template>
    
    <xsl:template name="autocomplete-dropdown">
        <div class="autocomplete__list" role="listbox" id="autocomplete-list-{$uniqueId}" style="display: none;">
            <div class="autocomplete__scrollable">
                <xsl:call-template name="autocomplete-dropdown-category-1"/>
                <xsl:call-template name="autocomplete-dropdown-category-2"/>
                <xsl:call-template name="autocomplete-dropdown-category-3"/>
            </div>

            <xsl:call-template name="autocomplete-more-results"/>
        </div>
    </xsl:template>
    
    <xsl:template name="autocomplete-dropdown-category-1">
        <!-- Formations -->                
        <xsl:call-template name="search-autocomplete-category">
            <xsl:with-param name="label"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_PROGRAMS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <path d="M13.5996 12.6406L8 16L4 13.6006L2.39941 12.6406V7.84082L8 11.2002L13.5996 7.84082V12.6406ZM1.59961 7.3584V11.0205L0 12.7979V6.39844L1.59961 7.3584ZM16.001 4.7998L8 9.59961L2.66699 6.39941H8V4.7998H0L8 0L16.001 4.7998Z" fill="#521C7E"></path>
                </svg>
            </xsl:with-param>
            <xsl:with-param name="data">pages</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="autocomplete-dropdown-category-2">
        <!-- Compétences -->                
        <xsl:call-template name="search-autocomplete-category">
            <xsl:with-param name="label"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_SKILLS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                  <path d="M11.5919 5.59333C11.6747 5.67591 11.7405 5.77404 11.7853 5.88209C11.8302 5.99013 11.8533 6.10597 11.8533 6.22296C11.8533 6.33995 11.8302 6.45579 11.7853 6.56384C11.7405 6.67188 11.6747 6.77001 11.5919 6.85259L7.44371 11.0007C7.36112 11.0836 7.263 11.1494 7.15495 11.1942C7.04691 11.2391 6.93107 11.2622 6.81408 11.2622C6.69709 11.2622 6.58125 11.2391 6.4732 11.1942C6.36515 11.1494 6.26703 11.0836 6.18445 11.0007L4.40667 9.22296C4.32399 9.14028 4.2584 9.04212 4.21365 8.93408C4.1689 8.82605 4.14587 8.71026 4.14587 8.59333C4.14587 8.4764 4.1689 8.36061 4.21365 8.25258C4.2584 8.14455 4.32399 8.04639 4.40667 7.9637C4.48935 7.88102 4.58751 7.81543 4.69555 7.77068C4.80358 7.72593 4.91937 7.7029 5.0363 7.7029C5.15323 7.7029 5.26902 7.72593 5.37705 7.77068C5.48508 7.81543 5.58324 7.88102 5.66593 7.9637L6.81482 9.11111L10.3341 5.59111C10.4168 5.50861 10.5149 5.44322 10.6229 5.39868C10.7309 5.35414 10.8466 5.33132 10.9634 5.33152C11.0802 5.33173 11.1959 5.35496 11.3037 5.39988C11.4115 5.4448 11.5094 5.51054 11.5919 5.59333ZM16 8C16 9.58225 15.5308 11.129 14.6518 12.4446C13.7727 13.7602 12.5233 14.7855 11.0615 15.391C9.59966 15.9965 7.99113 16.155 6.43928 15.8463C4.88743 15.5376 3.46197 14.7757 2.34315 13.6569C1.22433 12.538 0.462403 11.1126 0.153721 9.56072C-0.15496 8.00887 0.00346625 6.40034 0.608967 4.93853C1.21447 3.47672 2.23985 2.22729 3.55544 1.34824C4.87103 0.469192 6.41775 0 8 0C10.121 0.00235276 12.1545 0.845963 13.6543 2.34574C15.154 3.84552 15.9976 5.87899 16 8ZM14.2222 8C14.2222 6.76936 13.8573 5.56636 13.1736 4.54312C12.4899 3.51988 11.5181 2.72236 10.3811 2.25142C9.24418 1.78047 7.9931 1.65725 6.78611 1.89734C5.57911 2.13742 4.47042 2.73003 3.60023 3.60022C2.73003 4.47042 2.13743 5.57911 1.89734 6.7861C1.65725 7.9931 1.78047 9.24418 2.25142 10.3811C2.72236 11.5181 3.51988 12.4899 4.54312 13.1736C5.56636 13.8573 6.76936 14.2222 8 14.2222C9.6497 14.2205 11.2313 13.5643 12.3978 12.3978C13.5643 11.2313 14.2205 9.64969 14.2222 8Z" fill="#521C7E"></path>
                </svg>
            </xsl:with-param>
            <xsl:with-param name="data">skills</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="autocomplete-dropdown-category-3">
        <!-- Etiquettes -->                
        <!-- <xsl:call-template name="search-autocomplete-category">
            <xsl:with-param name="label"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_TAGS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                  <path d="M8 8C6.9 8 5.95833 7.60833 5.175 6.825C4.39167 6.04167 4 5.1 4 4C4 2.9 4.39167 1.95833 5.175 1.175C5.95833 0.391667 6.9 0 8 0C9.1 0 10.0417 0.391667 10.825 1.175C11.6083 1.95833 12 2.9 12 4C12 5.1 11.6083 6.04167 10.825 6.825C10.0417 7.60833 9.1 8 8 8ZM0 16V13.2C0 12.6333 0.146 12.1127 0.438 11.638C0.73 11.1633 1.11733 10.8007 1.6 10.55C2.63333 10.0333 3.68333 9.646 4.75 9.388C5.81667 9.13 6.9 9.00067 8 9C9.1 8.99933 10.1833 9.12867 11.25 9.388C12.3167 9.64733 13.3667 10.0347 14.4 10.55C14.8833 10.8 15.271 11.1627 15.563 11.638C15.855 12.1133 16.0007 12.634 16 13.2V16H0Z" fill="#521C7E"></path>
                </svg>
            </xsl:with-param>
            <xsl:with-param name="data">tags</xsl:with-param>
        </xsl:call-template> -->
    </xsl:template>
    
    <xsl:template name="autocomplete-more-results">
        <div class="autocomplete__more">
            <a href="#" class="autocomplete__more-btn" data-autocomplete-more="true">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <path
                        d="M6.61816 0C10.2733 0 13.2362 2.88826 13.2363 6.45117C13.2363 8.02921 12.6556 9.47562 11.6904 10.5967L15.7188 14.5156C15.7261 14.5225 16.3491 15.1111 15.7188 15.7256C15.0886 16.3398 14.4852 15.7333 14.4775 15.7256L10.4346 11.7227C9.3561 12.4659 8.03941 12.9033 6.61816 12.9033C2.96304 12.9032 0 10.0142 0 6.45117C0.000157556 2.88831 2.96314 7.68675e-05 6.61816 0ZM6.61816 1.61426C3.87694 1.61435 1.65445 3.78005 1.6543 6.45215C1.6543 9.12437 3.87685 11.2909 6.61816 11.291C9.35956 11.291 11.582 9.12443 11.582 6.45215C11.5819 3.77999 9.35946 1.61426 6.61816 1.61426Z"
                        fill="#521C7E"></path>
                </svg>
                <span>
                    <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_MORE_RESULTS" i18n:catalogue="skin.{$skin}"/>
                </span>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template name="autocomplete-server-url"><xsl:value-of select="$uri-prefix"/>/plugins/odf-web/search/autocompletion</xsl:template>
    <xsl:template name="autocomplete-open-page-results-in-new-tab">false</xsl:template><!-- to set to true to open search result page in new tab -->
    <xsl:template name="autocomplete-show-more-results-link">false</xsl:template><!-- to set to true to show "more results" link in dropdown -->
    <xsl:template name="autocomplete-js">
        <script>
            $j(function() {
                $j('#search-autocomplete-<xsl:value-of select="$uniqueId"/>').HSAmetysSearchAutocomplete({
                    autocompleteServerUrl: "<xsl:call-template name="autocomplete-server-url"/>",
                    autocompleteSiteName: "<xsl:value-of select="$site"/>",
                    autocompleteLang: "<xsl:value-of select="$lang"/>",
                    autocompleteZoneItemId: "<xsl:value-of select="/search/zone-item/@id"/>",
                    searchUrl: "<xsl:value-of select="resolver:resolve('page', /search/result-page)"/>",
                    openPageResultsInNewTab: <xsl:call-template name="autocomplete-open-page-results-in-new-tab"/>,
                    showMoreResultsLink: <xsl:call-template name="autocomplete-show-more-results-link"/>,
                });
            })
        </script>
    </xsl:template>
    
    <xsl:template name="search-autocomplete-category">
        <xsl:param name="label"/>
        <xsl:param name="icon"/>
        <xsl:param name="data"/>
        
        <div class="autocomplete__category">
            <div class="autocomplete__category-header">
                <xsl:copy-of select="$icon"/>
                <xsl:copy-of select="$label"/>
            </div>

            <ul data-autocomplete-data="{$data}" class="autocomplete__category-list">
            </ul>
        </div>
    </xsl:template>
    
    <xsl:template match="criterion[starts-with(@name, $titleOrFulltextCriteriaPrefix) or starts-with(@name, $fulltextCriteriaPrefix)]" mode="field-input-placeholder">
        <xsl:choose>
            <xsl:when test="$searchInputPlaceholder != ''">
                <xsl:attribute name="placeholder"><xsl:value-of select="$searchInputPlaceholder"/></xsl:attribute>
                <xsl:attribute name="title"><xsl:value-of select="$searchInputPlaceholder"/></xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="placeholder">skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_ODF_SEARCH_TEXTFIELD_DEFAULT_PLACEHOLDER</xsl:attribute>
                <xsl:attribute name="title">skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_ODF_SEARCH_TEXTFIELD_DEFAULT_PLACEHOLDER</xsl:attribute>
                <xsl:attribute name="i18n:attr">placeholder title</xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- Default placeholder is criteria label -->
    <xsl:template match="criterion" mode="field-input-placeholder">
        <xsl:attribute name="placeholder"><xsl:value-of select="label"/></xsl:attribute>
        <xsl:attribute name="title"><xsl:value-of select="label"/></xsl:attribute>
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="field-input">    
        <xsl:param name="value"/>
    
        <xsl:variable name="dropdownSort" select="ametys:serviceViewParameter('dropdownSort')"/> 
        
        <xsl:variable name="options">
            <items>
                <xsl:choose>
                    <xsl:when test="$dropdownSort = 'order'">
                        <!-- Sort items by order, then alpha -->
                        <xsl:for-each select="enumeration/item">
                            <xsl:sort select="not(@order)" data-type="number"/><!-- items with no order at the end -->
                            <xsl:sort select="@order" data-type="number"/>
                            <xsl:sort select="label" />
                            
                            <xsl:variable name="itemValue" select="@value" />
                            <xsl:variable name="inputName"><xsl:value-of select="concat('user.input.facet.ContentReturnable$', ../../@definition)"></xsl:value-of></xsl:variable>
                            <xsl:variable name="count" select="/search/enumerated-criteria/criterion[@name = $inputName]/item[@value = $itemValue]/@count" />
                            <xsl:if test="$compute-counts = 'false' or $count > 0">
                                <item value="{@value}" count="{$count}">
                                    <xsl:if test="@value = $value"><xsl:attribute name="selected">true</xsl:attribute></xsl:if>
                                    <xsl:copy-of select="label" />
                                </item>
                            </xsl:if>
                         </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- Alpha sort -->
                        <xsl:for-each select="enumeration/item">
                            <xsl:sort select="label" />
                            
                            <xsl:variable name="itemValue" select="@value" />
                            <xsl:variable name="inputName"><xsl:value-of select="concat('user.input.facet.ContentReturnable$', ../../@definition)"></xsl:value-of></xsl:variable>
                            <xsl:variable name="count" select="/search/enumerated-criteria/criterion[@name = $inputName]/item[@value = $itemValue]/@count" />
                            <xsl:if test="$compute-counts = 'false' or $count > 0">
                                <item value="{@value}" count="{$count}">
                                    <xsl:if test="@value = $value"><xsl:attribute name="selected">true</xsl:attribute></xsl:if>
                                    <xsl:copy-of select="label" />
                                </item>
                            </xsl:if>
                         </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </items>
        </xsl:variable>
        
        <div class="a11y-select" data-multiple="true">
          <xsl:apply-templates select="." mode="field-input-data-placeholder"/>
          <xsl:if test="count(exsl:node-set($options)/items/item) > 10">
            <xsl:attribute name="data-searchable">true</xsl:attribute>
          </xsl:if>
          <button type="button" class="a11y-select__button" id="a11y-sel-btn-{generate-id()}" aria-haspopup="listbox" aria-expanded="false" aria-controls="a11y-sel-list-{generate-id()}">
              <xsl:apply-templates select="." mode="field-input-placeholder"/>
          </button>

          <xsl:variable name="inputName" select="@name"/>
          <ul class="a11y-select__list" id="a11y-sel-list-{generate-id()}" role="listbox" aria-multiselectable="true" tabindex="-1">
            <xsl:for-each select="exsl:node-set($options)/items/item">
                <li class="a11y-select__option" role="option" aria-selected="{@selected}">
                    <label class="a11y-select__check">
                        <input type="checkbox" tabindex="-1" name="{$inputName}" value="{@value}">
                            <xsl:if test="@selected = 'true'"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
                        </input>
                        <span><xsl:value-of select="label" /></span>
                    </label>
                </li>
            </xsl:for-each>
          </ul>
        </div>
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="field-input-data-placeholder">
        <xsl:attribute name="data-placeholder"><xsl:value-of select="concat('skin.', $skin, ':SKIN_SERVICE_ODF_SEARCH_SELECT_PLACEHOLDER')"/></xsl:attribute>
        <xsl:attribute name="i18n:attr">data-placeholder</xsl:attribute> 
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="field-input-placeholder">
        <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_SELECT_PLACEHOLDER" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template name="submit-inputs-button">
        <div class="flex-actions">
            <xsl:call-template name="submit-button"/>
            <xsl:call-template name="reinit-button"/>
        </div>
    </xsl:template>
    
    <xsl:template name="submit-button">
        <button type="submit" class="btn btn-primary btn-search">
            <xsl:attribute name="onclick" ><xsl:call-template name="search-js-submit-button"/></xsl:attribute>
            <i18n:text i18n:key="SKIN_SEARCH_SUBMIT" i18n:catalogue="skin.{$skin}"/>
        </button>
    </xsl:template>
    
    <xsl:template name="reinit-button">
        <button type="button" class="btn btn-primary btn-reinit" id="reinit-{$uniqueId}">
            <i18n:text i18n:key="SKIN_SEARCH_RESET" i18n:catalogue="skin.{$skin}"/>
        </button>
        <script>
            $j(function() {
                $j('#reinit-<xsl:value-of select="$uniqueId"/>').on('click', function() {
                    var form = $j(this).closest('form[data-ametys-search-role="form"]');
                    form.find('input[type="text"], input[type="search"]').val('');
                    form.find('select').each(function() {
                        $j(this).val('');
                    });
                    form.find('[role="listbox"] li[aria-selected="true"]').each(function() {
                        $j(this).trigger('click');
                    });
                });
            });
        </script>
    </xsl:template>
    
</xsl:stylesheet>