<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->

<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:exsl="http://exslt.org/common"
        exclude-result-prefixes="ametys resolver"> 
        
    <xsl:import href="skin://services/web/pages/services/search/common/criteria.xsl"/>
    
    <!-- Criteria in grid -->
    <xsl:template name="form-search">
        <div class="grid-form">
            <xsl:for-each select="/search/form/fields/criterion">
                <xsl:apply-templates select="." mode="field">
                    <xsl:with-param name="value" select="/search/form/values/criterion[@name = current()/@name]"/>
                </xsl:apply-templates>
            </xsl:for-each>
        </div>
        
        <xsl:call-template name="submit-inputs"/>
        
    </xsl:template>
    
    <xsl:template name="form-criteria-hidden">
        <form hidden="hidden" data-ametys-search-role="form-criteria-hidden">
            <xsl:for-each select="/search/form/fields/criterion">
                <input type="hidden" name="{@name}" value="{/search/form/values/criterion[@name = current()/@name]}"/>
            </xsl:for-each>
            <input type="hidden" name="skillId" value="{/search/skill/@id}"/>
        </form>
    </xsl:template>
    
    <xsl:template name="skill-criteria">
        <xsl:if test="/search/skill">
            <div class="facets" role="group" aria-label="skin.{$skin}:SKIN_SERVICE_ODF_SEARCH_SKILLS_GROUP_ARIA_LABEL" i18n:attr="aria-label">
                <h2 class="sidebar-title"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_SKILLS" i18n:catalogue="skin.{$skin}"/></h2>
                                                            
                <div id="searchSkillTags_{$uniqueId}" class="sidebar-active-selection">
                    <div class="tag-active">
                        <span><xsl:value-of select="/search/skill"/></span>
                        <button aria-label="skin.{$skin}:SKIN_SERVICE_ODF_SEARCH_SKILLS_DELETE" i18n:attr="aria-label">
                            <xsl:attribute name="onclick"><xsl:call-template name="remove-skill-js"/></xsl:attribute>
                            <svg xmlns="http://www.w3.org/2000/svg" focusable="false" aria-hidden="true" fill="none" viewBox="0 0 10 10" height="10" width="10"><path fill="#2E1E3D" d="M5 4.09091L9.09091 0L10 0.909091L5.90909 5L10 9.09091L9.09091 10L5 5.90909L0.909091 10L0 9.09091L4.09091 5L0 0.909091L0.909091 0L5 4.09091Z"></path>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="remove-skill-js">
        <xsl:param name="callback-function" select="$callback-function"/>
        
        <!-- Reset skill input -->
        <xsl:variable name="code">
            var skillInput = $j("form[data-ametys-search-role='form-criteria-hidden'] input[name=skillId]");
            skillInput.val();
        </xsl:variable>
        <xsl:value-of select="normalize-space($code)"/>
        <!-- submit search -->
        <xsl:call-template name="search-js-submit-button"/>
    </xsl:template>
</xsl:stylesheet>