<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->

<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:exsl="http://exslt.org/common"
        exclude-result-prefixes="ametys resolver"> 
        
    <xsl:variable name="maxVisibleFacetItems">5</xsl:variable>
    
    <xsl:template name="facet-filter">
        <xsl:if test="/search/form/facets/facet[@total > 0]">
            <xsl:variable name="unique" select="concat('search-facet-', substring-after(math:random(), '.'))"/>
            <div id="{$unique}" class="facets" data-ametys-search-role="facet-filters" role="group" aria-label="plugin.web:PLUGINS_WEB_SERVICE_SEARCH_FILTERS_GROUP_ARIA_LABEL" i18n:attr="aria-label">
                
                <xsl:call-template name="facet-filter-title"/>
                
                <xsl:call-template name="facet-selected-facets"/>
                
                <xsl:for-each select="/search/form/facets/facet[@total > 0]">
                    <details class="sidebar-details">
                        <xsl:if test="item[@selected = 'true']">
                            <xsl:attribute name="open">open</xsl:attribute>
                        </xsl:if>
                        <xsl:apply-templates select="." mode="facet-filter-name"/>
                        <div class="checkbox-list" data-ametys-search-role="facet-filter" data-ametys-search-facet-name="{current()/@name}">
                            <xsl:call-template name="facet-filter-list"/>
                        </div>
                        <xsl:call-template name="facet-filter-show-more"/>
                    </details>
                </xsl:for-each>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="facet-filter-mobile-btn">
        <button class="btn btn-primary btn-mobile-filters">
            <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_FILTER" i18n:catalogue="skin.{$skin}"/>
        </button>
    </xsl:template>
    
    <xsl:template name="facet-filter-title">
        <h2 class="sidebar-title"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_FACETS_TITLE" i18n:catalogue="skin.{$skin}"/></h2>
    </xsl:template>
    
    <xsl:template name="facet-selected-facets">
        <xsl:if test="/search/form/facets/facet/item[@selected = 'true']">
            <div class="sidebar-active-selection">
                <xsl:for-each select="/search/form/facets/facet[item/@selected = 'true']">
                    <xsl:variable name="facetName" select="@name"/>
                    <xsl:for-each select="item[@selected = 'true']">
                        <div class="tag-active">
                            <span><xsl:value-of select="."/></span>
                            <button data-value="{@value}" data-facet="{$facetName}" onclick="removeFilter(this)">
                                <xsl:variable name="i18nparams"><page><xsl:value-of select="."/></page></xsl:variable> 
                                <xsl:attribute name="aria-label">
                                    <xsl:value-of select="ametys:translate(concat('skin.', $skin, ':SKIN_SERVICE_ODF_SEARCH_REMOVE_FILTER'), $lang, $i18nparams)"/>
                                </xsl:attribute>
                                <svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
                                    <path d="M5 4.09091L9.09091 0L10 0.909091L5.90909 5L10 9.09091L9.09091 10L5 5.90909L0.909091 10L0 9.09091L4.09091 5L0 0.909091L0.909091 0L5 4.09091Z" fill="#2E1E3D"></path>
                                </svg>
                            </button>
                        </div>
                    </xsl:for-each>
                </xsl:for-each>
            </div>
            <script>
                function removeFilter(btn)
                {
                    let facetName = $j(btn).attr('data-facet');
                    let facetValue = $j(btn).attr('data-value');
                    let $facet = $j(`.sidebar-details .checkbox-item input[name='${facetName}'][value='${facetValue}']`);
                    if ($facet.length)
                    {
                        // Trigger click event directly on DOM, as inline since jquery 3.4.1 onclick on a checkbox input is executed 3 times when called via $(...).trigger('click')
                        // https://github.com/jquery/jquery/issues/4493
                        // https://github.com/jquery/jquery/wiki/Won't-Fix#inline-event-handlers
                        $facet[0].click();
                    }
                }
            </script>
        </xsl:if>
    </xsl:template>
    
    <!-- Override to sort by count -->
    <xsl:template name="facet-filter-elements">
        <xsl:for-each select="item[@count > 0]">
            <xsl:sort select="@count" order="descending"/>
            
            <xsl:call-template name="facet-filter-element"/>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="facet" mode="facet-filter-name">
        <summary>
            <xsl:apply-templates select="." mode="facet-filter-icon"/>
            <xsl:value-of select="label"/>
        </summary>
    </xsl:template>
    
    <xsl:template match="facet[contains(@name, 'orgUnit')]" mode="facet-filter-icon">
        <svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
            <path d="M15.6756 3.37844L8.35125 0.563749C8.1249 0.47875 7.87541 0.47875 7.64906 0.563749L0.324375 3.37844C0.229094 3.41419 0.14699 3.47816 0.089028 3.56181C0.0310665 3.64545 7.63353e-06 3.74479 0 3.84656L0 5C0 5.27625 0.22375 5.5 0.5 5.5H15.5C15.7762 5.5 16 5.27625 16 5V3.84656C16 3.63812 15.8706 3.45156 15.6756 3.37844ZM2 6.5V11.5H1.5C1.22375 11.5 1 11.7237 1 12V13.5H15V12C15 11.7237 14.7762 11.5 14.5 11.5H14V6.5H12V11.5H9V6.5H7V11.5H4V6.5H2ZM15.5 14.5H0.5C0.22375 14.5 0 14.7237 0 15V16C0 16.2762 0.22375 16.5 0.5 16.5H15.5C15.7762 16.5 16 16.2762 16 16V15C16 14.7237 15.7762 14.5 15.5 14.5Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="facet[contains(@name, 'educationEntryLevel')]" mode="facet-filter-icon">
        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" height="21" width="20" viewBox="0 0 20 21">
            <g>
              <path d="M7.7,14.74c-.29.29-.29.77,0,1.06.29.29.77.29,1.06,0l4.77-4.77c.29-.29.29-.77,0-1.06l-4.77-4.77c-.29-.29-.77-.29-1.06,0-.29.29-.29.77,0,1.06l3.49,3.49H1c-.41,0-.75.34-.75.75s.34.75.75.75h10.19l-3.49,3.49Z"/>
              <path d="M10,.75h-2c-.41,0-.75.34-.75.75s.34.75.75.75h2c4.55,0,8.25,3.7,8.25,8.25s-3.7,8.25-8.25,8.25h-2c-.41,0-.75.34-.75.75s.34.75.75.75h2c5.38,0,9.75-4.37,9.75-9.75S15.38.75,10,.75Z"/>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template match="facet[contains(@name, 'degree')]" mode="facet-filter-icon">
        <svg width="20" height="18" viewBox="0 0 20 18" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M3.63636 10.0729V13.7093L10 17.182L16.3636 13.7093V10.0729L10 13.5456L3.63636 10.0729ZM10 0.818359L0 6.2729L10 11.7274L18.1818 7.26381V13.5456H20V6.2729L10 0.818359Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="facet[contains(@name, 'domain') or contains(@name, 'courseType')]" mode="facet-filter-icon">
        <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
            <path d="M7.68624 1.07333L5.58443 5.33488L0.881935 6.02046C0.0386395 6.14277 -0.299323 7.1824 0.312228 7.77786L3.71438 11.0931L2.90971 15.7763C2.76487 16.6228 3.65644 17.2569 4.40318 16.861L8.61 14.6498L12.8168 16.861C13.5636 17.2537 14.4551 16.6228 14.3103 15.7763L13.5056 11.0931L16.9078 7.77786C17.5193 7.1824 17.1814 6.14277 16.3381 6.02046L11.6356 5.33488L9.53376 1.07333C9.15718 0.313724 8.06604 0.304068 7.68624 1.07333Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="facet[contains(@name, 'place') or contains(@name, 'campus')]" mode="facet-filter-icon">
        <svg width="13" height="21" viewBox="0 0 13 21" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M7.08496 19.9219L6.19922 20.9707L5.31445 19.9219V12.583H7.08496V19.9219ZM12.3965 1.04883L9.74023 2.09668V10.4854L12.3965 11.5342V12.583H7.08496V12.582H5.31445V12.583H0V11.5342L2.65625 10.4854V2.09668L0 1.04883V0H12.3965V1.04883Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="facet[contains(@name, 'formofteachingOrg')]" mode="facet-filter-icon">
        <svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
            <path d="M11.6873 3.68744C11.6873 1.92704 10.2602 0.5 8.49983 0.5C6.73944 0.5 5.3124 1.92704 5.3124 3.68744C5.3124 5.44783 6.73944 6.87488 8.49983 6.87488C10.2602 6.87488 11.6873 5.44783 11.6873 3.68744ZM7.75577 8.50512C5.78586 7.2992 2.59511 6.96784 0.989434 6.87654C0.449894 6.84599 0 7.25704 0 7.77599V15.1735C0 15.6493 0.384817 16.0461 0.879534 16.0716C2.32915 16.1477 5.26193 16.4262 7.28894 17.4472C7.60005 17.6039 7.96893 17.3904 7.96893 17.0531V8.88562C7.96859 8.73056 7.8919 8.58846 7.75577 8.50512ZM16.0102 6.87654C14.4049 6.96751 11.2138 7.2992 9.24423 8.50512C9.1081 8.58846 9.03141 8.73621 9.03141 8.89126V17.0521C9.03141 17.3904 9.40128 17.6043 9.71338 17.4472C11.7401 16.4272 14.6712 16.1487 16.1205 16.0726C16.6152 16.0467 17 15.65 17 15.1742V7.77599C16.9997 7.25704 16.5498 6.84599 16.0102 6.87654Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="facet[contains(@name, 'level') or contains(@name, 'educationLevel')]" mode="facet-filter-icon">
        <svg width="17" height="14" viewBox="0 0 17 14" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
            <path d="M1.275 0.200195C0.571891 0.200195 0 0.772086 0 1.4752V3.1752C0 3.41001 0.190187 3.6002 0.425 3.6002H2.55V1.4752C2.55 0.772086 1.97811 0.200195 1.275 0.200195ZM6.8 11.1591V9.5502H14.45V2.7502C14.45 1.34398 13.3062 0.200195 11.9 0.200195H2.96411C3.23372 0.556399 3.4 0.994946 3.4 1.4752V11.2502C3.4 12.2827 4.32039 13.1003 5.38555 12.9268C6.22147 12.7908 6.8 12.0062 6.8 11.1591ZM7.65 10.4002V11.2502C7.65 12.6562 6.50622 13.8002 5.1 13.8002H14.025C15.6682 13.8002 17 12.4684 17 10.8252C17 10.5904 16.8098 10.4002 16.575 10.4002H7.65Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="facet[contains(@name, 'Code')]" mode="facet-filter-icon">
        <svg xmlns="http://www.w3.org/2000/svg" focusable="false" aria-hidden="true" class="icon" fill="none" viewBox="0 0 18 14" height="14" width="18">
            <path d="M7.19434 1.96582L3.32031 6.55371L7.19434 11.1406L5.53418 13.1064L0 6.55371L5.53418 0L7.19434 1.96582ZM17.71 6.55371L12.1758 13.1064L10.5156 11.1406L14.3887 6.55371L10.5156 1.96582L12.1758 0L17.71 6.55371Z"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="facet[contains(@name, 'timeSlot') or contains(@name, 'teachingTerm')]" mode="facet-filter-icon">
        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
            <path d="M9.99935 1.66699C14.6018 1.66699 18.3327 5.39783 18.3327 10.0003C18.3327 14.6028 14.6018 18.3337 9.99935 18.3337C5.39685 18.3337 1.66602 14.6028 1.66602 10.0003C1.66602 5.39783 5.39685 1.66699 9.99935 1.66699ZM9.99935 3.33366C8.23124 3.33366 6.53555 4.03604 5.2853 5.28628C4.03506 6.53652 3.33268 8.23222 3.33268 10.0003C3.33268 11.7684 4.03506 13.4641 5.2853 14.7144C6.53555 15.9646 8.23124 16.667 9.99935 16.667C11.7675 16.667 13.4632 15.9646 14.7134 14.7144C15.9636 13.4641 16.666 11.7684 16.666 10.0003C16.666 8.23222 15.9636 6.53652 14.7134 5.28628C13.4632 4.03604 11.7675 3.33366 9.99935 3.33366ZM9.99935 5.00033C10.2035 5.00035 10.4005 5.07529 10.553 5.21092C10.7055 5.34655 10.803 5.53345 10.8268 5.73616L10.8327 5.83366V9.65533L13.0885 11.9112C13.238 12.0611 13.3247 12.2624 13.3312 12.474C13.3377 12.6856 13.2633 12.8918 13.1233 13.0506C12.9833 13.2094 12.7881 13.3089 12.5773 13.329C12.3665 13.3491 12.156 13.2882 11.9885 13.1587L11.9102 13.0895L9.41018 10.5895C9.28066 10.4599 9.19748 10.2912 9.17352 10.1095L9.16602 10.0003V5.83366C9.16602 5.61264 9.25381 5.40068 9.41009 5.2444C9.56637 5.08812 9.77833 5.00033 9.99935 5.00033Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>

    <xsl:template match="facet[contains(@name, 'educationLanguage') or contains(@name, 'teachingLanguage')]" mode="facet-filter-icon">
        <svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
            <path d="M10.579 3.55952C8.91932 3.55952 7.54858 2.48221 5.46189 2.48221C4.68898 2.48221 3.99662 2.61799 3.35438 2.85428C3.44339 2.62182 3.48127 2.37292 3.46545 2.12451C3.41057 1.24379 2.68857 0.537342 1.80686 0.501476C0.815963 0.46115 0 1.25249 0 2.23443C0 2.82371 0.294143 3.34401 0.743333 3.65745V15.6144C0.743333 16.025 1.07613 16.3578 1.48667 16.3578H1.98222C2.39276 16.3578 2.72556 16.025 2.72556 15.6144V12.6907C3.60241 12.317 4.69483 12.0055 6.26986 12.0055C7.9296 12.0055 9.30031 13.0828 11.387 13.0828C12.8789 13.0828 14.0713 12.5781 15.1813 11.8173C15.4502 11.633 15.61 11.327 15.61 11.001V3.47162C15.61 2.74709 14.8583 2.26773 14.2012 2.57293C13.1377 3.06687 11.8333 3.55952 10.579 3.55952Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="facet[contains(@name, 'internationalEducation')]" mode="facet-filter-icon">
        <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M9.003 18C7.759 18 6.589 17.764 5.493 17.292C4.39767 16.8193 3.44467 16.178 2.634 15.368C1.82333 14.558 1.18167 13.606 0.709 12.512C0.236333 11.418 0 10.2483 0 9.003C0 7.75767 0.236333 6.58767 0.709 5.493C1.181 4.39767 1.82133 3.44467 2.63 2.634C3.43867 1.82333 4.391 1.18167 5.487 0.709C6.583 0.236333 7.753 0 8.997 0C10.241 0 11.411 0.236333 12.507 0.709C13.6023 1.181 14.5553 1.82167 15.366 2.631C16.1767 3.44033 16.8183 4.39267 17.291 5.488C17.7637 6.58333 18 7.753 18 8.997C18 10.241 17.764 11.411 17.292 12.507C16.82 13.603 16.1787 14.556 15.368 15.366C14.5573 16.176 13.6053 16.8177 12.512 17.291C11.4187 17.7643 10.249 18.0007 9.003 18ZM9 17C11.2333 17 13.125 16.225 14.675 14.675C16.225 13.125 17 11.2333 17 9C17 8.88333 16.999 8.76567 16.997 8.647C16.995 8.52833 16.9877 8.41467 16.975 8.306C16.9303 8.75067 16.7537 9.11867 16.445 9.41C16.1357 9.70067 15.7567 9.846 15.308 9.846H12.769C12.3037 9.846 11.9053 9.68067 11.574 9.35C11.2427 9.01933 11.077 8.62167 11.077 8.157V7.312H7.692V5.622C7.692 5.15733 7.858 4.758 8.19 4.424C8.52133 4.09 8.91967 3.923 9.385 3.923H10.231V3.153C10.231 2.66767 10.3897 2.28567 10.707 2.007C11.0243 1.72833 11.4033 1.56767 11.844 1.525C11.3953 1.35167 10.9353 1.221 10.464 1.133C9.99267 1.045 9.50467 1.00067 9 1C6.76667 1 4.875 1.775 3.325 3.325C1.775 4.875 1 6.76667 1 9V9.289C1 9.37833 1.00667 9.47433 1.02 9.577H5.5C6.44667 9.577 7.24733 9.90467 7.902 10.56C8.55733 11.2147 8.885 12.0123 8.885 12.953V13.808H6.346V16.538C6.75667 16.686 7.18533 16.8 7.632 16.88C8.07867 16.96 8.53467 17 9 17Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="facet" mode="facet-filter-icon">
        <svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
            <path d="M11.6873 3.68744C11.6873 1.92704 10.2602 0.5 8.49983 0.5C6.73944 0.5 5.3124 1.92704 5.3124 3.68744C5.3124 5.44783 6.73944 6.87488 8.49983 6.87488C10.2602 6.87488 11.6873 5.44783 11.6873 3.68744ZM7.75577 8.50512C5.78586 7.2992 2.59511 6.96784 0.989434 6.87654C0.449894 6.84599 0 7.25704 0 7.77599V15.1735C0 15.6493 0.384817 16.0461 0.879534 16.0716C2.32915 16.1477 5.26193 16.4262 7.28894 17.4472C7.60005 17.6039 7.96893 17.3904 7.96893 17.0531V8.88562C7.96859 8.73056 7.8919 8.58846 7.75577 8.50512ZM16.0102 6.87654C14.4049 6.96751 11.2138 7.2992 9.24423 8.50512C9.1081 8.58846 9.03141 8.73621 9.03141 8.89126V17.0521C9.03141 17.3904 9.40128 17.6043 9.71338 17.4472C11.7401 16.4272 14.6712 16.1487 16.1205 16.0726C16.6152 16.0467 17 15.65 17 15.1742V7.77599C16.9997 7.25704 16.5498 6.84599 16.0102 6.87654Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
    <xsl:template name="facet-filter-element">
        <xsl:variable name="id" select="concat(../@name, '-', substring-after(math:random(), '.'))"/>
        <div class="checkbox-item">
            <xsl:call-template name="facet-filter-element-checkbox">
               <xsl:with-param name="selected" select="@selected"/>
               <xsl:with-param name="id" select="$id"/>
           </xsl:call-template>
           <label for="{$id}"><xsl:value-of select="text()"/> (<xsl:value-of select="@count"/>)</label>
        </div>
    </xsl:template>
    
    <xsl:template name="facet-filter-show-more">
        <button type="button" class="btn btn-primary btn-showmore"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_FACETS_SHOW_MORE" i18n:catalogue="skin.{$skin}"/></button>
    </xsl:template>
    
</xsl:stylesheet>