<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->

<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:exsl="http://exslt.org/common"
        exclude-result-prefixes="ametys resolver"> 
        
    <xsl:import href="skin://services/web/pages/services/search/common/criteria.xsl"/>
    
    <xsl:template match="criterion" mode="field">
        <xsl:param name="value"/>
        
        <xsl:apply-templates select="." mode="field-label"/>
            
        <xsl:apply-templates select="." mode="field-input">
            <xsl:with-param name="value" select="$value"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <!-- No visible label -->
    <xsl:template match="criterion" mode="field-label">
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <xsl:variable name="labelFor"><xsl:value-of select="$id"/><xsl:if test="type = 'date' or type = 'datetime'">-clone</xsl:if></xsl:variable>
        <label for="{$labelFor}" class="sr-only">
        	<xsl:apply-templates select="." mode="field-label-text"/>
        </label>
    </xsl:template>
    
    <!-- Use label for placeholder -->
    <xsl:template match="criterion[enumeration]" mode="field-input-data-placeholder">
        <xsl:attribute name="data-placeholder"><xsl:value-of select="label"/></xsl:attribute>
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="field-input-placeholder">
        <xsl:value-of select="label"/>
    </xsl:template>
    
    <xsl:template name="submit-inputs-button">
       <xsl:call-template name="submit-button"/>
    </xsl:template>
    
</xsl:stylesheet>