<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        exclude-result-prefixes="ametys resolver">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    <xsl:import href="skin://services/web/pages/services/search/default/criteria.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">hero-6-fields hero-search</xsl:variable>

    <xsl:variable name="header" select="ametys:serviceParameter('header')"/>
    
    <xsl:template name="common-service-head-css">
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/hero-search/hero-search.css')}"/>    
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/hero-6-fields/hero-6-fields.css')}" />
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('templates/common/scss/autocomplete.css')}"/>   
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
    	<xsl:call-template name="search-service-head-js"/>
        
        <script type="text/javascript" src="{ametys:skinURL('templates/common/js/select.js')}"></script>
        <script type="text/javascript" src="{ametys:skinURL('templates/common/js/search-autocomplete.js')}"></script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="container">
            <div class="hero__form">
                <xsl:if test="normalize-space($header) != ''">
                    <h2 class="hero__title"><xsl:value-of select="$header"/></h2>
                </xsl:if>
        
                <xsl:call-template name="form-criteria"/>
            </div>
        </div>
    </xsl:template>
    
    <!-- Criteria in grid -->
    <xsl:template name="form-search">
        <div class="grid-form">
            <xsl:for-each select="/search/form/fields/criterion">
                <xsl:apply-templates select="." mode="field">
                    <xsl:with-param name="value" select="/search/form/values/criterion[@name = current()/@name]"/>
                </xsl:apply-templates>
            </xsl:for-each>
        </div>
        
        <xsl:call-template name="submit-inputs"/>
    </xsl:template>
    
    <xsl:template name="autocomplete-show-more-results-link">true</xsl:template><!-- show "more results" link in dropdown -->
    
    <xsl:template name="reinit-button"/>
    
</xsl:stylesheet>