<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        exclude-result-prefixes="ametys resolver">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    
    <xsl:variable name="is-empty" select="count(/search/hits/hit) = 0"/>    
    
    <xsl:template name="common-service-head-css">
        <!-- BEGIN head-css-slick-carousel -->
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('templates/common/js/vendor/slick/slick.css')}" type="text/css" />
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('templates/common/js/vendor/slick/slick-theme.css')}" type="text/css" />
        <!-- END head-css-slick-carousel -->
        
        <link media="screen, print" rel="stylesheet" href="{ametys:skinURL('templates/common/scss/carousel.css')}" type="text/css" />
        <link media="screen, print" rel="stylesheet" href="{ametys:skinURL('zones/news/news.css')}" type="text/css" />
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="search-service-head-js"/>
        
        <script type="text/javascript" src="{ametys:skinURL('templates/common/js/vendor/slick/slick.js')}"></script>
        <script type="text/javascript" src="{$uri-prefix}/skins/{$skin}/resources/templates/common/js/carousel.{$lang}.js"></script>
        
        <script type="text/javascript" src="{ametys:skinURL('zones/news/news.js')}"></script>
        
        <script type="text/javascript">
          $j(function(){
              Carousel.initialize('#news-<xsl:value-of select="$uniqueId"/>', {
                regionLabel: "<xsl:value-of select="$header"/>",
                slidesToShow: 4,
                slidesToScroll: 4,
                responsive: [
                  {
                    breakpoint: 1480,
                    settings: {
                      slidesToShow: 4,
                      slidesToScroll: 4,
                    }
                  },
                  {
                    breakpoint: 950,
                    settings: {
                      slidesToShow: 3,
                      slidesToScroll: 3,
                    }
                  },
                  {
                    breakpoint: 750,
                    settings: {
                      slidesToShow: 2,
                      slidesToScroll: 2,
                    }
                  },
                  {
                    breakpoint: 500,
                    settings: {
                      slidesToShow: 1,
                      slidesToScroll: 1,
                    }
                  }
                ]
              });
          })
        </script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title-rendering"/>
    
	<xsl:template name="header">
        <xsl:if test="$header != ''">        
    	   	<h1 class="service-title"><xsl:value-of select="$header"/></h1>
        </xsl:if>
   </xsl:template>
    
    <!-- The service HTML structure when there is something in the service -->
    <xsl:template name="common-service-body-nonempty">
        <div class="ametys-cms-service news">
        	<div class="container">
                <xsl:call-template name="header"/>
                
                <xsl:call-template name="search-results"/>
	        </div>
        </div>
    </xsl:template>
    
    <xsl:template name="search-results">
        <div data-ametys-search-role="search-results">
            <xsl:call-template name="form-criteria-hidden"/>
            
            <xsl:call-template name="hits"/>
            <xsl:call-template name="hits-mobile"/>
        </div>
    </xsl:template>
    
    <xsl:template name="hits">
    
        <div id="news-{$uniqueId}" class="news__carousel">
            <ul data-ametys-search-role="hits" class="news__list" data-carousel="true">
                <xsl:for-each select="/search/hits/hit">
                    <xsl:call-template name="hit"/>
                </xsl:for-each>
            </ul>
            
            <div class="news-nav-wrapper" data-carousel-nav="true"></div>
        </div>
    </xsl:template> 
    
    <xsl:template name="hits-mobile">
        <button class="news-popup__btn" aria-haspopup="dialog">
            <i18n:text i18n:key="SKIN_ITEMS_POPUP_OPEN" i18n:catalogue="skin.{$skin}"/>
        </button>
        
        <xsl:call-template name="hits-popup"/>
    </xsl:template>
    
    <xsl:template name="hits-popup">
        <div class="news-popup" role="dialog" aria-modal="true" aria-hidden="true" aria-labelledby="news-popup-title">
            <div class="container">
                <xsl:call-template name="hits-popup-close" />
        
                <h1 id="news-popup-title" class="service-title">
                    <xsl:value-of select="$header" />
                </h1>
                <ul data-ametys-search-role="hits" class="news__list__popup">
                    <xsl:for-each select="/search/hits/hit">
                        <xsl:call-template name="hit"/>
                    </xsl:for-each>
                </ul>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="hits-popup-close">
        <button class="news-popup__close" title="skin.{$skin}:SKIN_ITEMS_POPUP_CLOSE" i18n:attr="title">
            <svg width="35" height="35" viewBox="0 0 35 35" fill="none" xmlns="http://www.w3.org/2000/svg" focusable="false" aria-hidden="true">
                <rect width="35" height="35" rx="17.5" fill="#FFCC00"></rect>
                <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M14.459 18.3861L17.8858 21.7469L16.6081 23L11 17.5L16.6081 12L17.8858 13.2531L14.459 16.6139L24 16.6139V18.3861L14.459 18.3861Z" fill="#521C7E"></path>
            </svg>
        </button>
    </xsl:template>
    
    <xsl:template name="hit">
        <li>
            <xsl:apply-templates select="."/>
        </li>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">news__item</xsl:template> 
    
</xsl:stylesheet>