<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        exclude-result-prefixes="ametys resolver">
    
    <xsl:import href="skin://services/web/pages/services/search/search-default.xsl"/>
    
    <xsl:template name="results-count">
        <div class="nb-results">
            <xsl:choose>
                <xsl:when test="not(hits) or hits/@total = '0'"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_COURSES_NO_RESULT" i18n:catalogue="skin.{$skin}"/></xsl:when>
                <xsl:when test="hits/@total = '1'"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_COURSES_ONE_RESULT" i18n:catalogue="skin.{$skin}"/></xsl:when>
                <xsl:otherwise>
                    <i18n:translate>
                        <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_COURSES_RESULTS" i18n:catalogue="skin.{$skin}"/>
                        <i18n:param><xsl:value-of select="hits/@total"/></i18n:param>
                    </i18n:translate>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="autocomplete-dropdown-category-1">
        <!-- Cours -->                
        <xsl:call-template name="search-autocomplete-category">
            <xsl:with-param name="label"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_COURSES" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <path d="M13.5996 12.6406L8 16L4 13.6006L2.39941 12.6406V7.84082L8 11.2002L13.5996 7.84082V12.6406ZM1.59961 7.3584V11.0205L0 12.7979V6.39844L1.59961 7.3584ZM16.001 4.7998L8 9.59961L2.66699 6.39941H8V4.7998H0L8 0L16.001 4.7998Z" fill="#521C7E"></path>
                </svg>
            </xsl:with-param>
            <xsl:with-param name="data">pages</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="autocomplete-dropdown-category-2"/>
    
</xsl:stylesheet>