<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:cms="http://ametys.org/cms/3.0"
                            xmlns:docbook="http://docbook.org/ns/docbook" 
                            exclude-result-prefixes="ametys resolver cms docbook">

    <xsl:import href="plugin:web://stylesheets/content/common.xsl"/>
    
    <xsl:template name="common-content-head-css">
         <link rel="stylesheet" href="{ametys:skinURL('richtext/scss/richtext.css')}"/>
         
         <xsl:call-template name="common-content-head-additional-css"/>
         <xsl:call-template name="common-content-head-custom-css"/>
    </xsl:template>  
    
    <xsl:template name="common-content-head-additional-css"/>
    <xsl:template name="common-content-head-custom-css"/>
    
    <xsl:template name="common-content-head-js">
        <xsl:call-template name="common-content-head-additional-js"/>
        <xsl:call-template name="common-content-head-custom-js"/>
    </xsl:template>     
    
    <xsl:template name="common-content-head-additional-js"/>
    <xsl:template name="common-content-head-custom-js"/>
    
    <xsl:template name="common-content-head-title">
        <xsl:call-template name="common-content-head-title-content"/>
    </xsl:template> 
    
    <xsl:template name="common-content-body-title-content">
        <xsl:param name="title" select="metadata/title"/>
        <xsl:param name="subtitle" select="metadata/document-subtitle"/>
        
        <xsl:if test="not($zone = 'default') or not($template = 'page-content') or not(ametys:pageId())">
            <h1 class="ametys-content-title">
                <xsl:value-of select="$title"/>
            </h1>
        
            <xsl:if test="$subtitle != ''">
                <h2 class="ametys-content-subtitle"><xsl:value-of select="$subtitle"/></h2>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="common-content-body-image">
    </xsl:template>  
    
    <xsl:template name="common-content-body-content-rich">
        <xsl:param name="level" select="0"/>
        <xsl:param name="content" select="metadata/content"/>

        <xsl:if test="cms:isNotRichTextEmpty($content)">
            <xsl:variable name="raw-is-title-visible">
                <xsl:call-template name="common-content-body-title-content"/>
            </xsl:variable>
            
            <xsl:variable name="truelevel">
                <xsl:choose>
                    <xsl:when test="string-length($raw-is-title-visible) &gt; 0"><xsl:value-of select="2 + number($level)"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="1 + number($level)"/></xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
                    
            <div class="ametys-richtext">
	            <xsl:apply-templates select="$content/docbook:article">
	                <xsl:with-param name="level" select="$truelevel"/>
	            </xsl:apply-templates>
            </div>
        </xsl:if>    
    </xsl:template>
    
    <xsl:template name="common-content-body-publish-date"/>
                            
</xsl:stylesheet>
