<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:url="org.ametys.core.util.URIUtils"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:filename="org.ametys.core.util.FilenameUtils"
        xmlns:math="http://exslt.org/math" 
        exclude-result-prefixes="sitemap ametys resolver odf escaper filename url math">
    
    <xsl:import href="plugin:socialnetworking?://stylesheets/helpers/sendByMail.xsl" />
    
    <xsl:template name="main-banner">
        <xsl:variable name="imgUrl"><xsl:call-template name="main-banner-illustration-url"/></xsl:variable>
        <div class="hero-formation" style="background-image: url({ametys:escapeURLforCSS($imgUrl)});">
            <div class="container">
                <div class="hero-formation__content">
                    <div class="hero-formation__top">
                        <xsl:call-template name="main-banner-actions"/>
                        <xsl:call-template name="main-banner-title"/>
                    </div>
                    
                    <xsl:call-template name="main-banner-benefits"/>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="main-banner-title">
        <h1 class="hero-formation__title"><xsl:value-of select="metadata/title"/></h1>
    </xsl:template>
    
    <xsl:template name="main-banner-actions">
        <div class="hero-formation__actions">
            <!-- Share -->
            <xsl:call-template name="main-banner-action-share"/>
            <!-- Download -->
            <xsl:call-template name="main-banner-action-download"/>
            <!-- Add to wishlist (cart) -->
            <!-- xsl:call-template name="main-banner-action-wishlist"/-->
        </div>
    </xsl:template>
    
    <xsl:template name="main-banner-illustration-url">
        <xsl:variable name="image" select="metadata/illustration/image"/>
        <xsl:choose>
            <xsl:when test="$image">
                <xsl:call-template name="get-image-uri">
                    <xsl:with-param name="img" select="$image"/>
                    <xsl:with-param name="height" select="360"/>
                    <xsl:with-param name="width" select="1903"/>
                    <xsl:with-param name="isCropped" select="true()"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="main-banner-illustration-default-url"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="main-banner-illustration-default-url">
        <xsl:value-of select="ametys:skinURL('templates/common/img/banners/default.png')"/>
    </xsl:template>
    
    <!-- <xsl:template name="main-banner-illustration-default-url">
        <xsl:value-of select="ametys:skinURL('templates/common/img/banners/default.png')"/>
    </xsl:template> -->
    
    <xsl:template name="main-banner-action-share">
        <xsl:if test="ametys:pluginAvailable('socialnetworking')">
            <button id="sendByMail-btn-{$uniqueId}" class="btn btn-primary btn-share" aria-haspopup="dialog" onclick="sendByMail_form_popup_{$uniqueId}()"><i18n:text i18n:key="PROGRAM_HEADER_SHARE" i18n:catalogue="skin.odf-orientation"/></button>
            
            <xsl:variable name="sendByMail-page-id" select="ametys:pageId()"/>
            <xsl:variable name="sendByMail-url"><xsl:call-template name="sendByMail-get-url"/></xsl:variable>
            
            <div id="sendByMail-{$uniqueId}" style="display: none">
                <form id="sendByMail-form-{$uniqueId}" action="{$sendByMail-url}" method="post" class="sendByMail-form">
                    <div>
                        <input type="hidden" name="page-id" id="sendByMail-{$uniqueId}-id" value="{$sendByMail-page-id}"/>
                        <xsl:call-template name="sendByMail-form-hint"/>
                        <xsl:call-template name="sendByMail-form-field-name"/>
                        <xsl:call-template name="sendByMail-form-field-mail-by"/>
                        <xsl:call-template name="sendByMail-form-field-mail-to"/>
                        <xsl:call-template name="sendByMail-form-field-content"/>
                        <xsl:if test="$captchaRequired">
                          <xsl:call-template name="sendByMail-form-field-captcha"/>
                        </xsl:if>                   
                    </div>
                </form>
            </div>
        
            <xsl:call-template name="sendByMail-form-script"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="main-banner-action-download">
        <div class="btn-download-group">
            <button class="btn btn-primary btn-download">
              <i18n:text i18n:key="PROGRAM_HEADER_DOWNLOAD" i18n:catalogue="skin.odf-orientation"/>
            </button>
            <xsl:call-template name="main-banner-download-menu"/>
            <xsl:call-template name="main-banner-download-menu-js"/>
        </div>
    </xsl:template>
    
    <!-- +
         | This template is for downloads menu
         | By default display the download link for program to PDF, then the attachments
         + -->
    <xsl:template name="main-banner-download-menu">
        <!-- enable/disable the PDF download of the program -->
        <xsl:param name="pdfDownload" select="true()"/>
        <!-- Text for the PDF -->
        <xsl:param name="pdfText"><i18n:text i18n:key="PROGRAM_DOWNLOAD_PDF" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <!-- Url of PDF  -->
        <xsl:param name="pdfUrl" select="concat($uri-prefix, '/plugins/odf-web/', $site, '/_content/', /view/content/@name, '/main-orientation/', filename:filterName(/view/content/@title), '.pdf')"/>
        <!-- enable/disable the educational booklet PDF download of the program -->
        <xsl:param name="educationalBookletDownload" select="true()"/>
         <!-- Text for the full PDF -->
        <xsl:param name="educationalBookletText"><i18n:text i18n:key="PROGRAM_DOWNLOAD_EDUCATIONAL_BOOKLET" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <!-- Attachments -->
        <xsl:param name="attachments" select="metadata/attachments"/>
        
        <xsl:variable name="educationalBooklet" select="odf:getEducationalBooklet(/view/content/@id)"/>
        
        <xsl:if test="$pdfDownload or $attachments/entry/attachment or ($educationalBookletDownload and $educationalBooklet)">
            <div class="btn-download-dropdown" aria-hidden="true">
              <ul>
                <!-- PDF -->
                <xsl:if test="$pdfDownload">
                    <xsl:call-template name="main-banner-download-item">
                        <xsl:with-param name="downloadUrl" select="url:encodePath($pdfUrl)"/>
                        <xsl:with-param name="downloadText" select="$pdfText"/>
                        <xsl:with-param name="fileName" select="concat(/view/content/@name, '.pdf')"/>
                    </xsl:call-template>
                </xsl:if>
                
                <!-- Education booklet -->
                <xsl:if test="$educationalBookletDownload and $educationalBooklet">
                    <xsl:call-template name="main-banner-download-item">
                        <xsl:with-param name="downloadUrl" select="resolver:resolve($educationalBooklet/@type, $educationalBooklet/@path, false())"/>
                        <xsl:with-param name="downloadText" select="$educationalBookletText"/>
                        <xsl:with-param name="fileName" select="$educationalBooklet/@filename"/>
                    </xsl:call-template>
                </xsl:if>
                            
                <!-- Other attachments -->
                <xsl:for-each select="$attachments/entry[attachment]">
                    <xsl:call-template name="main-banner-download-item">
                        <xsl:with-param name="downloadUrl" select="resolver:resolve(attachment/@type, attachment/@path, true())"/>
                        <xsl:with-param name="downloadText" select="attachment-text"/>
                        <xsl:with-param name="fileName" select="attachment/@filename"/>
                    </xsl:call-template>
                </xsl:for-each>
              </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="main-banner-download-item">
        <xsl:param name="downloadUrl"/>
        <xsl:param name="downloadText"/>
        <xsl:param name="fileName"/>
        
        <li>
            <a href="{$downloadUrl}" target="_blank">
                <xsl:choose>
                    <xsl:when test="normalize-space($downloadText) != '' or $downloadText"> <xsl:copy-of select="$downloadText"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="$fileName"/></xsl:otherwise>
                </xsl:choose>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="main-banner-download-menu-js">
        <script>
            document.addEventListener('DOMContentLoaded', () => {
              setTimeout(() => {
                const groups = document.querySelectorAll('.btn-download-group');
            
                groups.forEach((group, index) => {
                  const btn = group.querySelector('.btn-download');
                  const menu = group.querySelector('.btn-download-dropdown');
                  if (!btn || !menu) return;
            
                  // ----- Accessibilité ARIA -----
                  const menuId = `download-menu-${index}`;
                  btn.setAttribute('type', 'button');
                  //btn.setAttribute('aria-haspopup', 'true');
                  btn.setAttribute('aria-expanded', 'false');
                  btn.setAttribute('aria-controls', menuId);
            
                  menu.setAttribute('id', menuId);
                  menu.setAttribute('role', 'menu');
                  menu.setAttribute('aria-hidden', 'true');
            
                  const items = menu.querySelectorAll('a');
                  items.forEach(a => {
                    a.setAttribute('role', 'menuitem');
                    a.setAttribute('tabindex', '-1');
                  });
            
                  // ----- Fonctions -----
                  const adjustMenuAlignment = () => {
                    // Vérifier si on est en mobile (largeur d'écran &lt; 768px)
                    if (window.innerWidth &lt; 768) {
                      // Calculer la position du bouton par rapport à la largeur de l'écran
                      const buttonRect = btn.getBoundingClientRect();
                      const buttonCenter = buttonRect.left + (buttonRect.width / 2);
                      const screenCenter = window.innerWidth / 2;
            
                      // Si le bouton est plus à gauche que le centre de l'écran
                      if (buttonCenter &lt; screenCenter) {
                        menu.classList.add('align-left');
                      } else {
                        menu.classList.remove('align-left');
                      }
                    } else {
                      // En desktop, toujours aligner à droite
                      menu.classList.remove('align-left');
                    }
                  };
      
                  const openMenu = () => {
                    adjustMenuAlignment();
                    menu.setAttribute('aria-hidden', 'false');
                    btn.setAttribute('aria-expanded', 'true');
                    items[0].focus();
                  };
            
                  const closeMenu = () => {
                    menu.setAttribute('aria-hidden', 'true');
                    btn.setAttribute('aria-expanded', 'false');
                    btn.focus();
                  };
            
                  // ----- Événements -----
                  btn.addEventListener('click', (e) => {
                    const isOpen = btn.getAttribute('aria-expanded') === 'true';
                    if (isOpen) closeMenu();
                    else openMenu();
                  });
            
                  // Fermer sur clic extérieur
                  document.addEventListener('click', (e) => {
                    if (!group.contains(e.target)) {
                      if (btn.getAttribute('aria-expanded') === 'true') closeMenu();
                    }
                  });
            
                  // Gestion clavier
                  group.addEventListener('keydown', (e) => {
                    const isOpen = btn.getAttribute('aria-expanded') === 'true';
                    const currentIndex = Array.from(items).indexOf(document.activeElement);
            
                    switch (e.key) {
                      case 'Escape':
                        if (isOpen) {
                          e.preventDefault();
                          closeMenu();
                        }
                        break;
                      case 'ArrowDown':
                        e.preventDefault();
                        if (!isOpen) openMenu();
                        else {
                          const next = items[currentIndex + 1] || items[0];
                          next.focus();
                        }
                        break;
                      case 'ArrowUp':
                        e.preventDefault();
                        if (isOpen) {
                          const prev = items[currentIndex - 1] || items[items.length - 1];
                          prev.focus();
                        }
                        break;
                      case 'Tab':
                        // Ferme quand on sort du menu
                        if (isOpen &amp;&amp; !group.contains(document.activeElement)) {
                          closeMenu();
                        }
                        break;
                      case 'Enter':
                        // Active le lien sélectionné si focusé
                        if (isOpen &amp;&amp; document.activeElement.tagName === 'A') {
                          document.activeElement.click();
                          closeMenu();
                        }
                        break;
                    }
                    
                    // Recalculer l'alignement lors du redimensionnement de la fenêtre
                      window.addEventListener('resize', () => {
                        if (btn.getAttribute('aria-expanded') === 'true') {
                          adjustMenuAlignment();
                        }
                      });
                  });
                });
              }, 1);
            });
        </script>
    </xsl:template>
    
    <xsl:template name="main-banner-action-wishlist">
        <button class="btn btn-primary btn-like"><i18n:text i18n:key="PROGRAM_HEADER_CART_ADD" i18n:catalogue="skin.odf-orientation"/></button>
    </xsl:template>
    
</xsl:stylesheet>