<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:cms="http://ametys.org/cms/3.0"
        exclude-result-prefixes="sitemap ametys resolver odf escaper cms">

    <xsl:template name="main-banner-benefits">
        <xsl:apply-templates select="/view/contentType[@view='main-orientation']/fieldset[@name='benefits']" mode="display"/>
    </xsl:template>
    
    <xsl:template match="fieldset[@name = 'benefits']" mode="display">
       <xsl:variable name="self" select="."/>
       
       <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <section class="program-meta" aria-labelledby="meta-title">
                <h2 id="meta-title" class="sr-only"><xsl:value-of select="label"/></h2>
                
                <dl class="meta-list">
                    <xsl:apply-templates select="metadata" mode="benefits" />
                </dl>
            </section>
       </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'keywords']" mode="benefits">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        <xsl:param name="content" select="/view/content"/><!-- Use for benefits displayed in popup -->
        
        <xsl:if test="$value">
            <div class="meta-item">
                <div class="icon-container">
                    <xsl:apply-templates select="." mode="benefits-icon"/>
                </div>
                <xsl:variable name="definition" select="."/>
                
                 <div class="meta-text">
                    <dt><xsl:value-of select="label"/></dt>
                    
                    <dd class="keywords-wrapper">
                        <span class="keywords-visible">
                            <xsl:for-each select="$value[position() &lt;= 3]">
                                <xsl:if test="position() != 1">, </xsl:if>
                                <xsl:apply-templates select="$definition" mode="benefits-value">
                                    <xsl:with-param name="value" select="."/>
                                    <xsl:with-param name="content" select="$content"/>
                                </xsl:apply-templates>
                            </xsl:for-each>
                        </span>
                        <xsl:if test="$value[position() &gt; 3]">
                            <div class="keywords-dropdown-group">
                                <button type="button" class="more-keyword" aria-expanded="false">
                                    <xsl:choose>
                                        <xsl:when test="count($value[position() &gt; 3]) = 1">
                                            <i18n:text i18n:key="PROGRAM_KEYWORDS_MORE_SINGLE" i18n:catalogue="skin.{$skin}"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <i18n:translate>
                                                <i18n:text i18n:key="PROGRAM_KEYWORDS_MORE_PLURAL" i18n:catalogue="skin.{$skin}"/>
                                                <i18n:param><xsl:value-of select="count($value[position() &gt; 3])"/></i18n:param>
                                            </i18n:translate>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </button>
                                <div class="keywords-dropdown" aria-hidden="true">
                                    <div class="keywords-dropdown__content">
                                        <xsl:for-each select="$value[position() &gt; 3]">
                                            <xsl:if test="position() != 1">, </xsl:if>
                                            <xsl:apply-templates select="$definition" mode="benefits-value">
                                                <xsl:with-param name="value" select="."/>
                                                <xsl:with-param name="content" select="$content"/>
                                            </xsl:apply-templates>
                                        </xsl:for-each>
                                    </div>
                                </div>
                            </div>
                       </xsl:if>
                  </dd>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata" mode="benefits">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        <xsl:param name="content" select="/view/content"/><!-- Use for benefits displayed in popup -->
        
        <xsl:if test="($value and @type != 'content') or ($value/@id and @type = 'content')">
            <div class="meta-item">
                <div class="icon-container">
                    <xsl:apply-templates select="." mode="benefits-icon"/>
                </div>
                <xsl:variable name="definition" select="."/>
                
                 <div class="meta-text">
                    <dt><xsl:value-of select="label"/></dt>
                    <dd>
                        <xsl:for-each select="$value">
                            <xsl:if test="position() != 1">, </xsl:if>
                            <xsl:apply-templates select="$definition" mode="benefits-value">
                                <xsl:with-param name="value" select="."/>
                                <xsl:with-param name="content" select="$content"/>
                            </xsl:apply-templates>
                        </xsl:for-each>
                    </dd>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@type='content']" mode="benefits-value">
        <xsl:param name="value"/>
        
        <xsl:value-of select="$value/@title"/>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'nbHours']" mode="benefits-value">
        <xsl:param name="value"/>
        
        <xsl:value-of select='format-number($value, "#,##")' />h
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'ects' and @type = 'content']" mode="benefits-value">
        <xsl:param name="value"/>
        
        <xsl:value-of select="$value/@title"/> <i18n:text i18n:key="PROGRAM_ECTS_UNITS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'ects' and @type  = 'double']" mode="benefits-value">
        <xsl:param name="value"/>
        <xsl:param name="content"/>
        
        <xsl:variable name="currentEcts">
            <xsl:choose>
                <xsl:when test="$content/@path">
                    <!-- ECTS display outside content's page -->
                    <xsl:value-of select="odf:getEcts($content/@id, $content/@path)"/>
                </xsl:when>
                <xsl:otherwise>
                    <!-- ECTS display on content's page -->
                    <xsl:value-of select="odf:getCurrentEcts()"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ects"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="$currentEcts"/></xsl:call-template></xsl:variable>
        <xsl:value-of select="$ects"/> <i18n:text i18n:key="PROGRAM_ECTS_UNITS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template match="metadata" mode="benefits-value">
        <xsl:param name="value"/>
        
        <xsl:value-of select="$value"/>
    </xsl:template>
    
    <!-- FIXME Missing SVG -->
    <!--<xsl:template match="metadata[@name = 'orgUnit']" mode="benefits-icon">
    </xsl:template-->
    
    <!-- FIXME Missing SVG -->
    <!-- xsl:template match="metadata[@name = 'educationLanguage']" mode="benefits-icon">
        <span class="ametys-icon-globe"></span>
    </xsl:template-->
    
    <xsl:template match="metadata[@name = 'educationLevel']" mode="benefits-icon">
        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" height="21" width="20" viewBox="0 0 20 21">
            <g>
              <path d="M7.7,14.74c-.29.29-.29.77,0,1.06.29.29.77.29,1.06,0l4.77-4.77c.29-.29.29-.77,0-1.06l-4.77-4.77c-.29-.29-.77-.29-1.06,0-.29.29-.29.77,0,1.06l3.49,3.49H1c-.41,0-.75.34-.75.75s.34.75.75.75h10.19l-3.49,3.49Z"/>
              <path d="M10,.75h-2c-.41,0-.75.34-.75.75s.34.75.75.75h2c4.55,0,8.25,3.7,8.25,8.25s-3.7,8.25-8.25,8.25h-2c-.41,0-.75.34-.75.75s.34.75.75.75h2c5.38,0,9.75-4.37,9.75-9.75S15.38.75,10,.75Z"/>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'ects']" mode="benefits-icon">
        <svg width="20" height="18" viewBox="0 0 20 18" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M3.63636 10.0729V13.7093L10 17.182L16.3636 13.7093V10.0729L10 13.5456L3.63636 10.0729ZM10 0.818359L0 6.2729L10 11.7274L18.1818 7.26381V13.5456H20V6.2729L10 0.818359Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'duration']" mode="benefits-icon">
        <svg width="11" height="18" viewBox="0 0 11 18" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M10.8 18L10.791 12.6L7.2 9L10.791 5.391L10.8 0H0V5.4L3.6 9L0 12.591V18H10.8ZM1.8 4.95V1.8H9V4.95L5.4 8.55L1.8 4.95Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'keywords']" mode="benefits-icon">
        <svg width="20" height="12" viewBox="0 0 20 12" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M10.5909 4.18177C9.84545 2.06359 7.82727 0.54541 5.45455 0.54541C2.44545 0.54541 0 2.99086 0 5.99996C0 9.00905 2.44545 11.4545 5.45455 11.4545C7.82727 11.4545 9.84545 9.93632 10.5909 7.81814H14.5455V11.4545H18.1818V7.81814H20V4.18177H10.5909ZM5.45455 7.81814C4.45455 7.81814 3.63636 6.99996 3.63636 5.99996C3.63636 4.99996 4.45455 4.18177 5.45455 4.18177C6.45455 4.18177 7.27273 4.99996 7.27273 5.99996C7.27273 6.99996 6.45455 7.81814 5.45455 7.81814Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'orgUnit']" mode="benefits-icon">
        <svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
            <path d="M15.6756 3.37844L8.35125 0.563749C8.1249 0.47875 7.87541 0.47875 7.64906 0.563749L0.324375 3.37844C0.229094 3.41419 0.14699 3.47816 0.089028 3.56181C0.0310665 3.64545 7.63353e-06 3.74479 0 3.84656L0 5C0 5.27625 0.22375 5.5 0.5 5.5H15.5C15.7762 5.5 16 5.27625 16 5V3.84656C16 3.63812 15.8706 3.45156 15.6756 3.37844ZM2 6.5V11.5H1.5C1.22375 11.5 1 11.7237 1 12V13.5H15V12C15 11.7237 14.7762 11.5 14.5 11.5H14V6.5H12V11.5H9V6.5H7V11.5H4V6.5H2ZM15.5 14.5H0.5C0.22375 14.5 0 14.7237 0 15V16C0 16.2762 0.22375 16.5 0.5 16.5H15.5C15.7762 16.5 16 16.2762 16 16V15C16 14.7237 15.7762 14.5 15.5 14.5Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
        
    <!-- xsl:template match="metadata[@name = 'teachingTerm']" mode="benefits-icon">
        <span class="far fa-calendar-alt"></span>
    </xsl:template-->
    
    <!-- Default icon for benefits -->
    <xsl:template match="metadata" mode="benefits-icon">
        <svg width="20" height="18" viewBox="0 0 20 18" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M3.63636 10.0729V13.7093L10 17.182L16.3636 13.7093V10.0729L10 13.5456L3.63636 10.0729ZM10 0.818359L0 6.2729L10 11.7274L18.1818 7.26381V13.5456H20V6.2729L10 0.818359Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
</xsl:stylesheet>