<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:cms="http://ametys.org/cms/3.0"
        exclude-result-prefixes="sitemap ametys resolver odf cms">
    
    <xsl:template match="fieldset[@name = 'key-info']" mode="display">
       <xsl:variable name="self" select="."/>
       
       <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <div class="ametys-sidebar-el">
												
				<h2 class="ametys-sidebar-title"><xsl:value-of select="label"/></h2>
				
				<dl class="meta-list">
					<xsl:apply-templates select="metadata" mode="key-info" />
                </dl>
            </div>
       </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@type = 'content']" mode="key-info">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        <xsl:param name="definition" select="."/>
        
        <xsl:if test="$value and $value/@id">
            <xsl:apply-templates select="." mode="key-info-row">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata" mode="key-info">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        <xsl:param name="definition" select="."/>
        
        <xsl:if test="$value and $value != ''">
            <xsl:apply-templates select="." mode="key-info-row">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata" mode="key-info-row">
        <xsl:param name="value"/>
        <xsl:param name="definition" select="."/>
        
        <div class="meta-item">
            <xsl:apply-templates select="." mode="key-info-icon"/>
            
            <div class="meta-text">
                <dt><xsl:value-of select="label"/></dt>
                <dd>
                    <xsl:apply-templates select="$definition" mode="key-info-value">
                        <xsl:with-param name="value" select="$value"/>
                    </xsl:apply-templates>
                </dd>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="metadata" mode="key-info-value">
        <xsl:param name="value"/>
        <xsl:param name="definition" select="."/>
        
        <xsl:for-each select="$value">
            <xsl:if test="position() != 1"><br/></xsl:if>
            <xsl:apply-templates select="$definition" mode="value">
                <xsl:with-param name="value" select="."/>
            </xsl:apply-templates>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'erasmusCode']|metadata[@name = 'romeCode']|metadata[@name = 'fapCode']|metadata[@name = 'nsfCode']|metadata[@name = 'siseCode']|metadata[@name = 'dgesipCode']" mode="key-info-icon">
        <svg width="18" height="14" viewBox="0 0 18 14" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M7.19434 1.96582L3.32031 6.55371L7.19434 11.1406L5.53418 13.1064L0 6.55371L5.53418 0L7.19434 1.96582ZM17.71 6.55371L12.1758 13.1064L10.5156 11.1406L14.3887 6.55371L10.5156 1.96582L12.1758 0L17.71 6.55371Z"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'place']|metadata[@name = 'campus']|metadata[@name = 'geocode']|metadata[@name = 'teachingLocation']" mode="key-info-icon">
        <svg width="13" height="21" viewBox="0 0 13 21" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M7.08496 19.9219L6.19922 20.9707L5.31445 19.9219V12.583H7.08496V19.9219ZM12.3965 1.04883L9.74023 2.09668V10.4854L12.3965 11.5342V12.583H7.08496V12.582H5.31445V12.583H0V11.5342L2.65625 10.4854V2.09668L0 1.04883V0H12.3965V1.04883Z"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'duration']|metadata[@name = 'teachingStart']|metadata[@name = 'teachingEnd']|metadata[@name = 'registrationStart']|metadata[@name = 'registrationDeadline']|metadata[@name = 'startDate']|metadata[@name='timeSlot']" mode="key-info-icon">
        <span class="icon fas fa-clock"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'speciality']" mode="key-info-icon">
        <span class="icon fas fa-star"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'programField']|metadata[@name = 'availableCertification']|metadata[@name = 'formofteachingOrg']" mode="key-info-icon">
        <svg width="16" height="21" viewBox="0 0 16 21" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M7.96875 0C10.1891 1.97538 12.9494 3.14551 15.9404 3.14551V11.5332C15.9404 13.8498 14.5522 16.6413 12.8477 17.7627L7.96973 20.9707L3.09277 17.7627C1.38466 16.639 7.69146e-05 13.8461 0 11.5332V3.14355C2.98982 3.14355 5.74885 1.97397 7.96875 0ZM6.93359 8.89258L3.7793 8.96875L6.29395 11.2266L5.37988 14.8037L7.96973 12.6689L10.5605 14.8037L9.64648 11.2266L12.1611 8.96875L9.00586 8.89258L7.96973 5.36328L6.93359 8.89258Z"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'degree']|metadata[@name = 'mention']|metadata[@name = 'availableCertification']" mode="key-info-icon">
        <svg width="18" height="21" viewBox="0 0 18 21" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M15.0527 16.5674L8.85449 20.9717L4.42676 17.8262L2.65625 16.5674V10.2764L8.85449 14.6807L15.0527 10.2764V16.5674ZM1.77051 9.64648V14.4463L0 16.7764V8.3877L1.77051 9.64648ZM17.71 6.29102L8.85449 12.583L2.95117 8.38867H8.85449V6.29102H0L8.85449 0L17.71 6.29102Z"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'teachingLanguage']|metadata[@name = 'openToExchangeStudents']" mode="key-info-icon">
        <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M9.003 18C7.759 18 6.589 17.764 5.493 17.292C4.39767 16.8193 3.44467 16.178 2.634 15.368C1.82333 14.558 1.18167 13.606 0.709 12.512C0.236333 11.418 0 10.2483 0 9.003C0 7.75767 0.236333 6.58767 0.709 5.493C1.181 4.39767 1.82133 3.44467 2.63 2.634C3.43867 1.82333 4.391 1.18167 5.487 0.709C6.583 0.236333 7.753 0 8.997 0C10.241 0 11.411 0.236333 12.507 0.709C13.6023 1.181 14.5553 1.82167 15.366 2.631C16.1767 3.44033 16.8183 4.39267 17.291 5.488C17.7637 6.58333 18 7.753 18 8.997C18 10.241 17.764 11.411 17.292 12.507C16.82 13.603 16.1787 14.556 15.368 15.366C14.5573 16.176 13.6053 16.8177 12.512 17.291C11.4187 17.7643 10.249 18.0007 9.003 18ZM9 17C11.2333 17 13.125 16.225 14.675 14.675C16.225 13.125 17 11.2333 17 9C17 8.88333 16.999 8.76567 16.997 8.647C16.995 8.52833 16.9877 8.41467 16.975 8.306C16.9303 8.75067 16.7537 9.11867 16.445 9.41C16.1357 9.70067 15.7567 9.846 15.308 9.846H12.769C12.3037 9.846 11.9053 9.68067 11.574 9.35C11.2427 9.01933 11.077 8.62167 11.077 8.157V7.312H7.692V5.622C7.692 5.15733 7.858 4.758 8.19 4.424C8.52133 4.09 8.91967 3.923 9.385 3.923H10.231V3.153C10.231 2.66767 10.3897 2.28567 10.707 2.007C11.0243 1.72833 11.4033 1.56767 11.844 1.525C11.3953 1.35167 10.9353 1.221 10.464 1.133C9.99267 1.045 9.50467 1.00067 9 1C6.76667 1 4.875 1.775 3.325 3.325C1.775 4.875 1 6.76667 1 9V9.289C1 9.37833 1.00667 9.47433 1.02 9.577H5.5C6.44667 9.577 7.24733 9.90467 7.902 10.56C8.55733 11.2147 8.885 12.0123 8.885 12.953V13.808H6.346V16.538C6.75667 16.686 7.18533 16.8 7.632 16.88C8.07867 16.96 8.53467 17 9 17Z"></path>
        </svg>
    </xsl:template>
    
    <!-- Default icon for a key information -->
    <xsl:template match="metadata" mode="key-info-icon">
        <svg width="15" height="21" viewBox="0 0 15 21" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon" aria-hidden="true" focusable="false">
            <path d="M11.5049 0C11.9973 0 12.3965 0.465692 12.3965 1.04883V2.09668H2.6582C2.1682 2.09696 1.77057 2.56261 1.77051 3.14551C1.77051 3.72445 2.16917 4.19408 2.66211 4.19434H3.54102V12.582L5.31152 10.4854L7.08301 12.582V4.19434H13.2764C13.7687 4.19445 14.168 4.66096 14.168 5.24414V18.8799C14.168 20.0345 13.3758 20.9705 12.4023 20.9707H1.76562C0.790556 20.9706 0.000107691 20.0293 0 18.8838V2.08789C0 0.935025 0.794545 0 1.77637 0H11.5049Z"></path>
        </svg>
    </xsl:template>

</xsl:stylesheet>