<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
							  xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:fo="http://www.w3.org/1999/XSL/Format"
                              xmlns:cms="http://ametys.org/cms/3.0" 
                              xmlns:odf="org.ametys.odf.OdfXSLTHelper"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="cms ametys">
         
    <xsl:param name="exportMode"/>
                         
    <xsl:template match="/">
        <fo:root>
            <fo:layout-master-set>
            	<!-- Master 2 columns -->
                <fo:simple-page-master master-name="page-2-columns" page-width="210mm" page-height="297mm" margin-left="0cm" 
                    margin-right="0cm" margin-top="2cm" margin-bottom="1.5cm">
                    <fo:region-body margin-top="2.5cm" margin-bottom="2cm" column-count="2" column-gap="30" margin-left="1.5cm" margin-right="1.5cm">
                        <xsl:call-template name="region-body-definition"/>
                    </fo:region-body>
                    <fo:region-before>
                        <xsl:call-template name="region-before-definition"/>
                    </fo:region-before>
                    <fo:region-after>
                        <xsl:call-template name="region-after-definition"/>
                    </fo:region-after>
                </fo:simple-page-master>
                
                <!-- Master single columns -->
                <fo:simple-page-master master-name="page" page-width="210mm" page-height="297mm" margin-left="0cm" 
                    margin-right="0cm" margin-top="1.5cm" margin-bottom="1.5cm">
                    <fo:region-body margin-top="2.5cm" margin-bottom="2cm" column-count="1" margin-left="1.5cm" margin-right="1.5cm">
                        <xsl:call-template name="region-body-definition"/>
                    </fo:region-body>
                    <fo:region-before>
                        <xsl:call-template name="region-before-definition"/>
                    </fo:region-before>
                    <fo:region-after>
                        <xsl:call-template name="region-after-definition"/>
                    </fo:region-after>
                </fo:simple-page-master>
            </fo:layout-master-set>
            
            <xsl:apply-templates select="/view/content"/>
        </fo:root>
    </xsl:template>
    
    <xsl:template name="xsl-region-before">
    	<fo:static-content flow-name="xsl-region-before" space-after="1cm">
			<xsl:call-template name="xsl-region-before-content"/>
       </fo:static-content>
    </xsl:template>
    
    <xsl:template name="xsl-region-before-content">
    	<fo:block margin-top="0cm" margin-right="1.5cm" margin-left="1.5cm">
        	<fo:external-graphic src="url('skin:{$skin}://resources/templates/common/img/logo-header.svg')" content-width="scale-to-fit" content-height="1.5cm" vertical-align="top"/>
	        <fo:external-graphic src="url('skin:{$skin}://resources/templates/common/img/header.png')" width="12.9cm" height="2cm" content-width="scale-to-fit" />
	    </fo:block>
    </xsl:template>
    
    <xsl:template name="xsl-region-after">
        <fo:static-content flow-name="xsl-region-after">
            <fo:block margin-left="0cm" margin-right="0cm" margin-bottom="2cm">
                <xsl:call-template name="main-region-after-block"/>
                
                <fo:table table-layout="fixed" margin-top="0pt" padding="0pt">
                	<fo:table-column column-width="4cm"/>
	                <fo:table-column/>
	                <fo:table-column column-width="4cm"/>
	                
	                <fo:table-body>
	                    <fo:table-row>
	                    	<fo:table-cell vertical-align="middle" text-align="left" padding-left="1.5cm">
	                            <fo:block>
	                            	<xsl:call-template name="footer-pages-style"/>
	                            	<fo:page-number /> / <fo:page-number-citation ref-id="theEnd" />
	                            </fo:block>
	                        </fo:table-cell>
	                    	 <fo:table-cell margin-left="0cm" padding="0" text-align="center" vertical-align="middle">
	                        	<fo:block>
	                        		<xsl:call-template name="footer-copyright-style"/>
						        	<i18n:text i18n:key="PDF_FOOTER_COPYRIGHT_LABEL" i18n:catalogue="skin.{$skin}"/>       
				        			<xsl:if test="//content/@lastValidatedAt">
							        	 <fo:block><i18n:text i18n:key="PDF_LAST_UPDATE" i18n:catalogue="skin.{$skin}"/>
							                <i18n:date src-pattern="yyyy-MM-dd'T'hh:mm:ss" pattern="dd MMMM yyyy" value="{//content/@lastModifiedAt}"/>
							             </fo:block>
							        </xsl:if>	
						        </fo:block>
	                        </fo:table-cell>
	                        <fo:table-cell vertical-align="middle" text-align="right" padding-right="1.5cm">
	                        	<xsl:call-template name="xsl-region-after-content"/>
	                        </fo:table-cell>
	                       
	                    </fo:table-row>
	                </fo:table-body>
	            </fo:table>
            </fo:block>
        </fo:static-content> 
    </xsl:template>
    
    <xsl:template name="xsl-region-after-content">
		<fo:block><fo:external-graphic src="url('skin:{$skin}://resources/templates/common/img/logo-header-mobile.svg')" width="1cm" height="2cm" content-width="scale-to-fit" text-align="right"/></fo:block>
    </xsl:template>
    
    <!-- +
         | Common templates for program, subprograms and courses
         + -->
          
    <!-- // Custom display for contacts -->
    <xsl:template match="metadata[@name='contacts']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value/@entryCount != '0' and $value/entry/persons">
            <fo:block page-break-inside="avoid">
                <fo:block xsl:use-attribute-sets="section-title">
                    <xsl:value-of select="label"/>
                </fo:block>
                    
                <xsl:for-each select="$value/entry">
                    <xsl:variable name="role" select="role"/>
                    
                    <xsl:for-each select="persons">
                        <xsl:call-template name="contact">
                            <xsl:with-param name="contact" select="."/>
                            <xsl:with-param name="role" select="$role"/>
                        </xsl:call-template>
                    </xsl:for-each>
                </xsl:for-each>
            </fo:block>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="contact">
        <xsl:param name="contact"/>
        <xsl:param name="role"/>
        
        <fo:block xsl:use-attribute-sets="contact">
            <xsl:call-template name="contact-role">
                <xsl:with-param name="role" select="$role"/>
            </xsl:call-template>
            
            <xsl:call-template name="contact-title">
                <xsl:with-param name="contact" select="$contact"/>
            </xsl:call-template>
            
            <xsl:call-template name="contact-info-item">
                <xsl:with-param name="contentId" select="$contact/@id"/>
                <xsl:with-param name="dataPath" select="'phone'"/>
                <xsl:with-param name="glyph" select="'&#xf095;'"/>
            </xsl:call-template>
            
            <xsl:call-template name="contact-info-item">
                <xsl:with-param name="contentId" select="$contact/@id"/>
                <xsl:with-param name="dataPath" select="'mail'"/>
                <xsl:with-param name="glyph" select="'&#xf0e0;'"/>
            </xsl:call-template>
        </fo:block>
    </xsl:template>
    
    <xsl:template name="contact-title">
        <xsl:param name="contact"/>
        
        <xsl:variable name="firstname" select="ametys:contentAttribute($contact/@id, 'givenName')"/>
        <xsl:variable name="lastname" select="ametys:contentAttribute($contact/@id, 'lastName')"/>
        
        <fo:block xsl:use-attribute-sets="contact-title">
            <xsl:choose>
                <xsl:when test="$firstname != '' and $lastname != ''">
                    <xsl:value-of select="concat($firstname, ' ', $lastname)"/>
                </xsl:when>
                <xsl:when test="$lastname != ''">
                    <xsl:value-of select="$lastname"/>
                </xsl:when>
                <xsl:when test="$firstname != ''">
                    <xsl:value-of select="$firstname"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$contact/title"/>
                </xsl:otherwise>
            </xsl:choose>
        </fo:block>
    </xsl:template>
    
    <xsl:template name="contact-role">
        <xsl:param name="role"/>
        
        <xsl:if test="$role">
            <fo:block xsl:use-attribute-sets="contact-role"><xsl:value-of select="$role/@title"/></fo:block>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="contact-info-item">
        <xsl:param name="contentId"/>
        <xsl:param name="dataPath"/>
        <xsl:param name="glyph"/>
        
        <xsl:variable name="value" select="ametys:contentAttribute($contentId, $dataPath)"/>
        
        <xsl:if test="$value != ''">
            <fo:block xsl:use-attribute-sets="contact-info">
                <fo:inline xsl:use-attribute-sets="glyph-icon" font-family="FontAwesome" font-weight="bold"><xsl:value-of select="$glyph"/></fo:inline>
                <xsl:text> </xsl:text><xsl:value-of select="$value"/>
            </fo:block>
        </xsl:if>
    </xsl:template>
    
    <xsl:attribute-set name="contact"/>
    <xsl:attribute-set name="contact-title"/>
    <xsl:attribute-set name="contact-role"/>
    <xsl:attribute-set name="contact-info"/>
    <!-- // End contact -->
    
    <!-- // Custom display for place and campus -->
    <xsl:template match="metadata[@name='place']|metadata[@name='campus']|metadata[@name='teachingLocation']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <fo:block page-break-inside="avoid" >
                <fo:block xsl:use-attribute-sets="section-title">
                    <xsl:value-of select="label"/>
                </fo:block>
                
                <xsl:variable name="definition" select="."/>
                
                <xsl:for-each select="$value">
                    <fo:block xsl:use-attribute-sets="location">
                        <xsl:call-template name="para-style"/>
                        <xsl:apply-templates select="$definition" mode="icon"/><xsl:text> </xsl:text>
                        <xsl:apply-templates select="$definition" mode="value">
                            <xsl:with-param name="value" select="."/>
                        </xsl:apply-templates>
                    </fo:block>
                </xsl:for-each>
            </fo:block>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'place']" mode="icon">
        <fo:inline xsl:use-attribute-sets="glyph-icon" font-family="FontAwesome" font-weight="bold">&#xf3c5;</fo:inline>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'campus']" mode="icon">
        <fo:inline xsl:use-attribute-sets="glyph-icon" font-family="FontAwesome" font-weight="bold">&#xf549;</fo:inline>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'teachingLocation']" mode="icon">
        <fo:inline xsl:use-attribute-sets="glyph-icon" font-family="FontAwesome" font-weight="bold">&#xf3c5;</fo:inline>
    </xsl:template>
    
    <xsl:attribute-set name="location"/>
    <!-- // End place and campus -->
    
    <!-- // Table of courses (mode simple) -->
    <xsl:template match="courselist" mode="program">
    	<xsl:param name="level">0</xsl:param>
    	
        <xsl:if test="course">
	    	<xsl:choose>
	    		<xsl:when test="$level = 0">
	    			<fo:block page-break-inside="avoid" xsl:use-attribute-sets="course-table">
			            <fo:table padding="10pt">
			                <fo:table-column/>
			                <fo:table-column column-width="1.8cm"/><!-- ects -->
			                <fo:table-column column-width="1.5cm"/><!-- total hours -->
			                <fo:table-body>
			                    <xsl:apply-templates select="course" mode="program"/>
			                </fo:table-body>
			            </fo:table>
			        </fo:block>
	    		</xsl:when>
	    		<xsl:otherwise>
	    			<xsl:apply-templates select="course" mode="program">
	    				<xsl:with-param name="level" select="$level"/>
	        		</xsl:apply-templates>
	    		</xsl:otherwise>
	    	</xsl:choose>
        </xsl:if>
        
    </xsl:template>
    
    <xsl:template match="course" mode="program">
    	<xsl:param name="level">0</xsl:param>
    	
		<fo:table-row>
            <xsl:choose>
                <xsl:when test="$level = 0">
                    <fo:table-cell xsl:use-attribute-sets="course-title course-level1">
                        <xsl:apply-templates select="." mode="course-title"/>        
                    </fo:table-cell>
                    <fo:table-cell text-align="right" xsl:use-attribute-sets="course-ects course-level1">
                        <xsl:apply-templates select="." mode="course-ects" />
                    </fo:table-cell>
                    <fo:table-cell text-align="right" xsl:use-attribute-sets="course-hours course-level1">
                        <xsl:apply-templates select="." mode="course-hours"/>
                    </fo:table-cell>
                </xsl:when>
                <xsl:otherwise>
                     <fo:table-cell padding-left="{$level}*10pt" xsl:use-attribute-sets="course-title">
                        <xsl:apply-templates select="." mode="course-title"/>        
                    </fo:table-cell>
                    <fo:table-cell text-align="right" xsl:use-attribute-sets="course-ects">
                        <xsl:apply-templates select="." mode="course-ects" />
                    </fo:table-cell>
                    <fo:table-cell text-align="right" xsl:use-attribute-sets="course-hours">
                        <xsl:apply-templates select="." mode="course-hours"/>
                    </fo:table-cell>
                </xsl:otherwise>
            </xsl:choose>
		</fo:table-row>
        
        <xsl:apply-templates select="courselist" mode="program">
        	<xsl:with-param name="level" select="$level+1"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="course" mode="course-title">
        <fo:block>
            <xsl:choose>
                <xsl:when test="$exportMode = 'educational-booklet'">
                    <fo:basic-link internal-destination="bookmark-course-{@id}">
                        <xsl:value-of select="@title" />
                    </fo:basic-link>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="@title" />
                </xsl:otherwise>
            </xsl:choose>
        </fo:block>
    </xsl:template>
    
    <xsl:template match="course" mode="course-ects">
        <fo:block>
            <xsl:variable name="computedEcts" select="odf:getEcts(@id, @path)"/>
            <xsl:if test="$computedEcts">
                <xsl:variable name="ects"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="$computedEcts"/></xsl:call-template></xsl:variable>
                <xsl:value-of select="$ects"/> <i18n:text i18n:key="PROGRAM_ECTS_UNITS" i18n:catalogue="skin.{$skin}"/>
            </xsl:if>
        </fo:block>
    </xsl:template>
    
    <xsl:template match="course" mode="course-ects-full">
        <fo:block>
            <xsl:variable name="computedEcts" select="odf:getEcts(@id, @path)"/>
            <xsl:if test="$computedEcts">
                <xsl:variable name="ects"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="$computedEcts"/></xsl:call-template></xsl:variable>
                <xsl:value-of select="$ects"/> <i18n:text i18n:key="PROGRAM_ECTS_UNITS" i18n:catalogue="skin.{$skin}"/>
            </xsl:if>
        </fo:block>
    </xsl:template>
    
    <xsl:template match="course" mode="course-nature">
        <fo:block>
            <xsl:if test="attributes/courseType">
                <xsl:value-of select="attributes/courseType"/>
            </xsl:if>
        </fo:block>
    </xsl:template>
    
    <xsl:template match="course" mode="course-hours">
        <xsl:variable name="nbHours">
            <xsl:choose>
                <xsl:when test="attributes/nbHours"><xsl:value-of select="attributes/nbHours"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="courseparts/@totalHours"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <fo:block>
            <xsl:if test="$nbHours != '' and $nbHours != '0.0'">
                <xsl:variable name="hours"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="$nbHours"/></xsl:call-template></xsl:variable>
                <xsl:value-of select="$hours"/>h
            </xsl:if>
        </fo:block>
    </xsl:template>
    
    <xsl:attribute-set name="course-table"/>
    <xsl:attribute-set name="course-title-level1"/>
    <xsl:attribute-set name="course-ects-level1"/>
    <xsl:attribute-set name="course-hours-level1"/>
    <xsl:attribute-set name="course-title"/>
    <xsl:attribute-set name="course-ects"/>
    <xsl:attribute-set name="course-hours"/>
    <!-- // End course -->
    
    <!-- +
         | Table structure with full mode (Nature / CM / TD / TP / Crédits )
         + -->
    <xsl:template match="courselist" mode="program-full">
        <xsl:param name="level">0</xsl:param>
        
        <xsl:if test="local-name(../..) = 'structure'">
            <!-- The list is just under the root item -->
            <xsl:call-template name="structure-table-header"/>
        </xsl:if>
        
        <xsl:if test="course">
            <xsl:choose>
                <xsl:when test="$level = 0">
                    <fo:block page-break-inside="auto" xsl:use-attribute-sets="course-table">
                        <fo:table padding="10pt">
                            <xsl:call-template name="structure-table-columns"/>
                            <fo:table-body>
                                <xsl:apply-templates select="course" mode="program-full"/>
                            </fo:table-body>
                        </fo:table>
                    </fo:block>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="course" mode="program-full">
                        <xsl:with-param name="level" select="$level"/>
                    </xsl:apply-templates>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <!-- +
         | Definition of columns in full mode
         | This template should matched the row header defined in 'structure-table-header' template
         + -->
    <xsl:template name="structure-table-columns">
        <fo:table-column/><!-- Title -->
        <fo:table-column column-width="1.5cm"/><!-- Nature -->
        <fo:table-column column-width="1cm"/><!-- CM -->
        <fo:table-column column-width="1cm"/><!-- TD -->
        <fo:table-column column-width="1cm"/><!-- TP -->
        <fo:table-column column-width="1.8cm"/><!-- ects -->
    </xsl:template>
    
    <!-- +
         | Table header for full mode
         | This template should matched the columns defined in 'structure-table-columns' template
         + -->
    <xsl:template name="structure-table-header">
        <fo:table padding="10pt">
            <xsl:call-template name="structure-table-columns"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell xsl:use-attribute-sets="structure-table-header"><fo:block></fo:block></fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="structure-table-header"><fo:block>Nature</fo:block></fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="structure-table-header"><fo:block>CM</fo:block></fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="structure-table-header"><fo:block>TD</fo:block></fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="structure-table-header"><fo:block>TP</fo:block></fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="structure-table-header"><fo:block>Crédits</fo:block></fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>
    
    <xsl:template match="course" mode="program-full">
        <xsl:param name="level">0</xsl:param>
        
        <fo:table-row>
            <xsl:choose>
                <xsl:when test="$level = 0">
                    <fo:table-cell xsl:use-attribute-sets="course-title course-level1">
                        <xsl:apply-templates select="." mode="course-title"/>        
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="course-nature course-level1">
                        <xsl:apply-templates select="." mode="course-nature"/>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="course-hours course-level1">
                        <xsl:apply-templates select="." mode="coursepart-hours">
                            <xsl:with-param name="natureCode" select="'CM'"></xsl:with-param>
                        </xsl:apply-templates>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="course-hours course-level1">
                        <xsl:apply-templates select="." mode="coursepart-hours">
                            <xsl:with-param name="natureCode" select="'TD'"></xsl:with-param>
                        </xsl:apply-templates>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="course-hours course-level1">
                        <xsl:apply-templates select="." mode="coursepart-hours">
                            <xsl:with-param name="natureCode" select="'TP'"></xsl:with-param>
                        </xsl:apply-templates>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="course-ects course-level1">
                        <xsl:apply-templates select="." mode="course-ects-full" />
                    </fo:table-cell>
                </xsl:when>
                <xsl:otherwise>
                    <fo:table-cell padding-left="{$level}*10pt" xsl:use-attribute-sets="course-title">
                        <xsl:apply-templates select="." mode="course-title"/>        
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="course-nature">
                        <xsl:apply-templates select="." mode="course-nature"/>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="course-hours">
                        <xsl:apply-templates select="." mode="coursepart-hours">
                            <xsl:with-param name="natureCode" select="'CM'"></xsl:with-param>
                        </xsl:apply-templates>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="course-hours">
                        <xsl:apply-templates select="." mode="coursepart-hours">
                            <xsl:with-param name="natureCode" select="'TD'"></xsl:with-param>
                        </xsl:apply-templates>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="course-hours">
                        <xsl:apply-templates select="." mode="coursepart-hours">
                            <xsl:with-param name="natureCode" select="'TP'"></xsl:with-param>
                        </xsl:apply-templates>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="course-ects">
                        <xsl:apply-templates select="." mode="course-ects-full" />
                    </fo:table-cell>
                </xsl:otherwise>
            </xsl:choose>
        </fo:table-row>
        
        <xsl:apply-templates select="courselist" mode="program-full">
            <xsl:with-param name="level" select="$level+1"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="course" mode="coursepart-hours">
        <xsl:param name="natureCode"/>
        
        <xsl:variable name="nbHours"><xsl:value-of select="sum(courseparts/coursepart[attributes/nature/@code = $natureCode]/attributes/nbHours)"/></xsl:variable>
        <fo:block>
            <xsl:if test="$nbHours != '' and $nbHours != '0' and $nbHours != '0.0'">
                <xsl:variable name="hours"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="$nbHours"/></xsl:call-template></xsl:variable>
                <xsl:value-of select="$hours"/>h
            </xsl:if>
        </fo:block>
    </xsl:template>
</xsl:stylesheet>
