<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:math="http://exslt.org/math"
							xmlns:exsl="http://exslt.org/common"
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:docbook="http://docbook.org/ns/docbook" 
                            xmlns:xalan="http://xml.apache.org/xalan"
                            xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
                            xmlns:cms="http://ametys.org/cms/3.0" 
							exclude-result-prefixes="ametys resolver cms">

    <xsl:import href="skin://stylesheets/content/default-content.xsl"/>
    <xsl:import href="skin://stylesheets/content/common.xsl"/>
	<xsl:import href="skin://stylesheets/content/course/course.xsl"/>
    
    <xsl:import href="skin://stylesheets/content/utils.xsl"/>   
    <xsl:import href="skin://stylesheets/content/course/zones/banner.xsl"/>   
    <xsl:import href="skin://stylesheets/content/course/zones/benefits.xsl"/>   
    <xsl:import href="skin://stylesheets/content/course/zones/aside.xsl"/>   
    <xsl:import href="skin://stylesheets/content/course/zones/mcc.xsl"/>   
    <xsl:import href="skin://stylesheets/content/course/zones/skills.xsl"/>   
    
    <xsl:template name="common-content-head-other">
        <meta name="ODF.content" content="true"/>
    </xsl:template>
    
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body-content">
        <xsl:call-template name="main-banner"/>
        <xsl:call-template name="main-content"/>
    </xsl:template>
    
    <xsl:template name="main-content">
        <!-- Display tabs -->
        <xsl:apply-templates select="/view/contentType/fieldset[@role = 'tab']" mode="display"/>
    </xsl:template>
    
    <!-- +
         | Default template for display of presentation tab.
         | This tab display information on two columns.
         | A "main" and "aside" fieldsets are expected.
         + -->
    <xsl:template match="fieldset[@role='tab' and @name='presentation']" mode="display">
        <xsl:variable name="self" select="."/>
        
        <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <section id="tab-{generate-id()}" class="ametys-formation-section" role="contentinfo" aria-label="{label}">
                <div class="container">
                    <xsl:if test="cms:isNotFieldsetEmpty(fieldset[@name='main'])">
                        <div class="ametys-formation-section__col">
                           <h2 class="ametys-formation-title"><xsl:value-of select="label"/></h2>
                           
                            <xsl:apply-templates select="fieldset[@name='main']" mode="display"/> 
                            <xsl:apply-templates select="/view/skills" mode="display"/>
                        </div>
                    </xsl:if>
                    <!-- Aside informations -->
                    <xsl:apply-templates select="fieldset[@name='aside']" mode="display"/> 
                </div>
            </section>
        </xsl:if>
    </xsl:template>
    
    <!-- This template ignore the richtext label -->
    <xsl:template match="metadata[@name='description' and @type='rich-text']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value/docbook:article">
            <div class="ametys-richtext">
                <xsl:variable name="definition" select="."/>                      
                <xsl:apply-templates select="$definition" mode="value">
                    <xsl:with-param name="value" select="$value"/>
                </xsl:apply-templates>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'courseParts']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <div class="ametys-cours-section">
                <h3 class="ametys-formation-title-2"><xsl:value-of select="label"/></h3>
                
                <table class="ametys-cours-hours">
                    <xsl:variable name="definition" select="."/>
                    <tbody>
                        <xsl:for-each select="$value">
                            <xsl:apply-templates select="$definition" mode="table-row">
                                <xsl:with-param name="value" select="."/>
                            </xsl:apply-templates>
                        </xsl:for-each>
                    </tbody>
                </table>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'courseParts']" mode="table-row">
        <xsl:param name="value"/>
        
        <tr>
            <td>
                <div class="td-w-icon">
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
                        <path d="M9.99935 1.66699C14.6018 1.66699 18.3327 5.39783 18.3327 10.0003C18.3327 14.6028 14.6018 18.3337 9.99935 18.3337C5.39685 18.3337 1.66602 14.6028 1.66602 10.0003C1.66602 5.39783 5.39685 1.66699 9.99935 1.66699ZM9.99935 3.33366C8.23124 3.33366 6.53555 4.03604 5.2853 5.28628C4.03506 6.53652 3.33268 8.23222 3.33268 10.0003C3.33268 11.7684 4.03506 13.4641 5.2853 14.7144C6.53555 15.9646 8.23124 16.667 9.99935 16.667C11.7675 16.667 13.4632 15.9646 14.7134 14.7144C15.9636 13.4641 16.666 11.7684 16.666 10.0003C16.666 8.23222 15.9636 6.53652 14.7134 5.28628C13.4632 4.03604 11.7675 3.33366 9.99935 3.33366ZM9.99935 5.00033C10.2035 5.00035 10.4005 5.07529 10.553 5.21092C10.7055 5.34655 10.803 5.53345 10.8268 5.73616L10.8327 5.83366V9.65533L13.0885 11.9112C13.238 12.0611 13.3247 12.2624 13.3312 12.474C13.3377 12.6856 13.2633 12.8918 13.1233 13.0506C12.9833 13.2094 12.7881 13.3089 12.5773 13.329C12.3665 13.3491 12.156 13.2882 11.9885 13.1587L11.9102 13.0895L9.41018 10.5895C9.28066 10.4599 9.19748 10.2912 9.17352 10.1095L9.16602 10.0003V5.83366C9.16602 5.61264 9.25381 5.40068 9.41009 5.2444C9.56637 5.08812 9.77833 5.00033 9.99935 5.00033Z" fill="#521C7E"></path>
                    </svg>
                    <xsl:value-of select="$value/title"/>
                </div> 
            </td>
            <td><xsl:value-of select="$value/nature/@title"/></td>
            <td>
                <xsl:if test="$value/nbHours != 0">
                    <xsl:variable name="nbHours"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="$value/nbHours"/></xsl:call-template></xsl:variable>
                    <xsl:value-of select="$nbHours"/>h
                </xsl:if>
            </td>
        </tr>
    </xsl:template>
            
</xsl:stylesheet>
