<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:cms="http://ametys.org/cms/3.0"
        xmlns:docbook="http://docbook.org/ns/docbook" 
        xmlns:math="java.lang.Math"
        xmlns:exslt="http://exslt.org/common"
        exclude-result-prefixes="sitemap ametys resolver odf docbook math cms exslt">

    <xsl:import href="skin://stylesheets/content/common/zones/aside.xsl"/>
    
    <xsl:template match="metadata[@name = 'campus']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
         
        <xsl:if test="$value">
            <div class="ametys-sidebar-el no-bg">
                <h2 class="ametys-sidebar-title"><xsl:value-of select="label"/></h2>
                
                <ul class="link-list">
                    <xsl:variable name="definition" select="."/>
                    <xsl:for-each select="$value">
                        <li>
                            <span class="university">
                                <xsl:apply-templates select="$definition" mode="value">
                                    <xsl:with-param name="value" select="."/>
                                </xsl:apply-templates>
                            </span>
                        </li>
                    </xsl:for-each>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'teachingLocation']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
         
        <xsl:if test="$value">
            <div class="ametys-sidebar-el no-bg">
                <h2 class="ametys-sidebar-title"><xsl:value-of select="label"/></h2>
                
                <ul class="link-list">
                    <xsl:variable name="definition" select="."/>
                    <xsl:for-each select="$value">
                        <li>
                            <span class="location">
                                <xsl:apply-templates select="$definition" mode="value">
                                    <xsl:with-param name="value" select="."/>
                                </xsl:apply-templates>
                            </span>
                        </li>
                    </xsl:for-each>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'webLinkUrl']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
         
        <xsl:if test="$value">
            <div class="ametys-sidebar-el no-bg">
                <h2 class="ametys-sidebar-title"><i18n:text i18n:key="PROGRAM_WEB_SITES" i18n:catalogue="skin.{$skin}"/></h2>
                
                <ul class="link-list">
                    <xsl:apply-templates select="." mode="value">
                        <xsl:with-param name="value" select="$value"/>
                    </xsl:apply-templates>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'webLinkLabel']" mode="display"/>
    
    <xsl:template match="metadata[@name = 'webLinkUrl']" mode="value">
        <xsl:param name="value"/>
        <xsl:param name="labelValue" select="/view/content/metadata/*[local-name() = 'webLinkLabel']"/>
        
        <li>
            <a class="external">
                <xsl:choose>
                   <xsl:when test="normalize-space($labelValue) != ''"><xsl:value-of select="$labelValue"/></xsl:when>
                   <xsl:otherwise><xsl:value-of select="$value"/></xsl:otherwise>
                </xsl:choose>
            </a>
        </li>
    </xsl:template>
    
</xsl:stylesheet>