<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
        xmlns:cms="http://ametys.org/cms/3.0"
        xmlns:docbook="http://docbook.org/ns/docbook" 
        xmlns:exslt="http://exslt.org/common"
        exclude-result-prefixes="sitemap ametys resolver odf docbook cms exslt">
    
    <!-- Compétences -->
    
    <xsl:template match="fieldset[@name = 'skills']" mode="display">
        <xsl:variable name="self" select="."/>
        
        <xsl:variable name="hiddenSkills" select="odf:areSkillsUnavailable(/view/content/@id, ametys:pageId())"/> 
        
        <xsl:if test="cms:isNotFieldsetEmpty($self) and not($hiddenSkills)">
            <section id="tab-{generate-id()}" class="ametys-formation-section ametys-formation-section--skills" role="contentinfo" aria-label="{label}">
                <div class="container">
                    <div class="ametys-formation-section__col">
                        <h2 class="ametys-formation-title"><xsl:value-of select="label"/></h2>
                        
                        <xsl:apply-templates select="fieldset|metadata" mode="display">
                            <xsl:with-param name="hiddenSkills" select="$hiddenSkills"/>
                        </xsl:apply-templates> 
                    </div>
                </div>
            </section>
        </xsl:if>
    </xsl:template>
    
    <!-- Compétences requises -->
    <xsl:template match="metadata[@name = 'acquiredMicroSkills']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        <xsl:param name="hiddenSkills" select="@hiddenSkills"/>
        
        <xsl:if test="$value/@entryCount != '0' and not($hiddenSkills)">
            <div class="ametys-cours-section">
                <h3 class="ametys-formation-title-2"><xsl:value-of select="label"/></h3>
                
                <div class="scrollable-table">
                    <table class="ametys-cours-modality-table">
                        <thead>
                            <tr>
                                <th>Formation</th>
                                <th>Micro-compétences</th>
                            </tr>
                        </thead>
                        <xsl:variable name="definition" select="."/>
                        
                        <tbody>
                            <xsl:for-each select="$value">
                                <xsl:apply-templates select="$definition" mode="value">
                                    <xsl:with-param name="value" select="."/>
                                </xsl:apply-templates>
                            </xsl:for-each>
                        </tbody>
                    </table>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'acquiredMicroSkills']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="repeaterDef" select="."/>
        
        <xsl:for-each select="$value/entry">
            <xsl:sort select="program/@title" data-type="text"/>
            <tr>
                <td rowspan="{count(microSkills) + 1}"><xsl:value-of select="program/@title"/></td>
            </tr>
            
            <xsl:if test="count(microSkills) > 0">
                <xsl:for-each select="microSkills">
                    <xsl:sort select="@title" data-type="text"/>
                    <tr>
                        <td><xsl:value-of select="@title"/></td>
                    </tr>
                </xsl:for-each>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
</xsl:stylesheet>