<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:cms="http://ametys.org/cms/3.0"
        xmlns:docbook="http://docbook.org/ns/docbook" 
        xmlns:math="java.lang.Math"
        xmlns:exslt="http://exslt.org/common"
        exclude-result-prefixes="sitemap ametys resolver odf docbook math cms exslt">

    <xsl:import href="skin://stylesheets/content/common/zones/aside.xsl"/>
    
    <xsl:template match="fieldset[@name = 'key-figures']" mode="display">
        <xsl:variable name="self" select="."/>
       
        <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <div class="ametys-sidebar-el">
                <h3 class="ametys-sidebar-title"><xsl:value-of select="label"/></h3>
                
                <dl class="numbers">
                    <xsl:apply-templates select="metadata" mode="key-figure" />
                </dl>
             </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata" mode="key-figure">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <div class="number-item">
                <dt>
                    <xsl:apply-templates select="." mode="value">
                        <xsl:with-param name="value" select="$value"/>
                    </xsl:apply-templates>
                </dt>       
                <dd><xsl:value-of select="label"/></dd>         
            </div>
        </xsl:if>
    </xsl:template>
    
    <!-- +
         | Default template to display other links
         + -->
    <xsl:template match="metadata[@name = 'programWebSite']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
         
        <xsl:if test="$value/@entryCount != '0' and ($value/entry/programWebSiteUrl or $value/entry/programWebSiteLabel)">
            <div class="ametys-sidebar-el no-bg">
                <h3 class="ametys-sidebar-title"><i18n:text i18n:key="PROGRAM_WEB_SITES" i18n:catalogue="skin.{$skin}"/></h3>
                
                <ul class="link-list">
                    <xsl:apply-templates select="." mode="value">
                        <xsl:with-param name="value" select="$value"/>
                    </xsl:apply-templates>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'programWebSite']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="definition" select="."/>
        
        <xsl:for-each select="$value/entry">
            <li>
                <xsl:choose>
                    <xsl:when test="normalize-space(programWebSiteUrl) != ''">
                        <a href="{programWebSiteUrl}">
                            <xsl:apply-templates select="$definition" mode="link-attr-class"/>
                            <xsl:choose>
                               <xsl:when test="normalize-space(programWebSiteLabel) != ''"><xsl:value-of select="programWebSiteLabel"/></xsl:when>
                               <xsl:otherwise><xsl:value-of select="programWebSiteUrl"/></xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <span>
                            <xsl:apply-templates select="$definition" mode="link-attr-class"/>
                            <xsl:value-of select="programWebSiteLabel"/>
                        </span>
                    </xsl:otherwise>
                </xsl:choose>
            </li>
        </xsl:for-each>
    </xsl:template>
    
    <!-- +
         | Default template to display partner schools and partners laboratories
         + -->
    <xsl:template match="metadata[@name = 'partnerSchools']|metadata[@name = 'partnerLaboratories']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
         
        <xsl:if test="$value/@entryCount != '0' and ($value/entry/linkUrl or $value/entry/linkLabel)">
            <div class="ametys-sidebar-el no-bg">
                <h3 class="ametys-sidebar-title">
                    <xsl:apply-templates select="." mode="title">
                        <xsl:with-param name="value" select="$value"/>
                    </xsl:apply-templates>
                </h3>
                
                <ul class="link-list">
                    <xsl:apply-templates select="." mode="value">
                        <xsl:with-param name="value" select="$value"/>
                    </xsl:apply-templates>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'partnerSchools']" mode="title">
        <xsl:param name="value"/>
        
        <xsl:choose>
            <xsl:when test="count($value/entry) = 1"><i18n:text i18n:key="PROGRAM_PARTNER_SCHOOL" i18n:catalogue="skin.{$skin}"/></xsl:when>
            <xsl:otherwise><i18n:text i18n:key="PROGRAM_PARTNER_SCHOOLS" i18n:catalogue="skin.{$skin}"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'partnerLaboratories']" mode="title">
        <xsl:param name="value"/>
        
        <xsl:choose>
            <xsl:when test="count($value/entry) = 1"><i18n:text i18n:key="PROGRAM_PARTNER_LABORATORY" i18n:catalogue="skin.{$skin}"/></xsl:when>
            <xsl:otherwise><i18n:text i18n:key="PROGRAM_PARTNER_LABORATORIES" i18n:catalogue="skin.{$skin}"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'partnerSchools']|metadata[@name = 'partnerLaboratories']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="definition" select="."/>
        
        <xsl:for-each select="$value/entry">
            <li>
                <xsl:choose>
                    <xsl:when test="normalize-space(linkUrl) != ''">
                        <a href="{linkUrl}">
                            <xsl:apply-templates select="$definition" mode="link-attr-class"/>
                            <xsl:choose>
                               <xsl:when test="normalize-space(linkLabel) != ''"><xsl:value-of select="linkLabel"/></xsl:when>
                               <xsl:otherwise><xsl:value-of select="linkUrl"/></xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <span>
                            <xsl:apply-templates select="$definition" mode="link-attr-class"/>
                            <xsl:value-of select="linkLabel"/>
                        </span>
                    </xsl:otherwise>
                </xsl:choose>
            </li>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'partnerSchools']" mode="link-attr-class">
        <xsl:attribute name="class">university</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'partnerLaboratories']" mode="link-attr-class">
        <xsl:attribute name="class">fiole</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata" mode="link-attr-class">
        <xsl:attribute name="class">external</xsl:attribute>
    </xsl:template>
    
    <!-- +
         | Default template to display joined orgunit
         + -->
    <xsl:template match="metadata[@name = 'jointOrgUnit']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <section class="g-mb-55">
                <h2 class="ametys-section-title"><xsl:value-of select="label"/></h2>
                
                <xsl:variable name="definition" select="."/>
                
                <ul class="ametys-list-with-icon ametys-list-with-icon--blue">
                    <xsl:for-each select="$value">
                        <li class="ametys-list-with-icon__item">
                            <xsl:apply-templates select="$definition" mode="value">
                                <xsl:with-param name="value" select="."/>
                            </xsl:apply-templates>
                        </li>
                    </xsl:for-each>
                </ul>
            </section>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'jointOrgUnit']" mode="value">
        <xsl:param name="value"/>
        
        <span class="ametys-list-with-icon__item-icon ametys-icon-building"></span>
        <xsl:value-of select="$value/@title"/>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'rncpCode']" mode="value">
        <xsl:param name="value"/>
                                
        <a href="https://www.francecompetences.fr/recherche/rncp/{$value}" target="_blank">
            <xsl:variable name="i18nparams"><value><xsl:value-of select="$value"/></value></xsl:variable> 
            <xsl:attribute name="title">
                <xsl:value-of select="ametys:translate(concat('skin.', $skin, ':PROGRAM_RNCP_CODE_LINK_TITLE'), $lang, $i18nparams)"/>
            </xsl:attribute>
        
            <xsl:value-of select="$value"/>
        </a>
    </xsl:template>
</xsl:stylesheet>