<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        exclude-result-prefixes="sitemap ametys resolver odf escaper">
        
        
   <!-- +
        | BEGIN Parcoursup Data
        + -->
   <xsl:template match="metadata[@name = 'parcoursupData' and @type = 'composite']" mode="display">
       <xsl:param name="name" select="@name"/>
       <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
       
       <xsl:if test="$value/*">
           <div class="ametys-formation-numbers">
               <h2 class="ametys-formation-title-2"><i18n:text i18n:key="PROGRAM_PARCOURSSUP_DATA" i18n:catalogue="skin.{$skin}"/></h2>
               
               <div class="ametys-formation-numbers__list">
                   <xsl:variable name="definition" select="."/>
                    
                    <xsl:for-each select="$value/*">
                        <xsl:variable name="name" select="local-name()"/>
                        <xsl:apply-templates select="$definition/metadata[@name = $name]" mode="parcoursup-data">
                            <xsl:with-param name="value" select="."/>
                        </xsl:apply-templates>
                    </xsl:for-each>
               </div>
           </div>
       </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'year']" mode="parcoursup-data"/>
    
    <xsl:template match="metadata" mode="parcoursup-data">
        <xsl:param name="value"/>
        
        <xsl:if test="$value">
            <xsl:variable name="definition" select="."/>
            
            <div class="ametys-formation-numbers__item">
                <div class="ametys-formation-numbers__item-number">
                    <xsl:apply-templates select="$definition" mode="value">
                        <xsl:with-param name="value" select="$value"/>
                    </xsl:apply-templates>
                </div>
                <p class="ametys-formation-numbers__item-description">
                    <xsl:apply-templates select="$definition" mode="parcoursup-data-label">
                        <xsl:with-param name="value" select="$value"/>
                    </xsl:apply-templates>
                </p>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'numberOfAplications']" mode="parcoursup-data-label">
        <xsl:param name="value"/>
        
        <xsl:variable name="year" select="/view/content/metadata/parcoursupData/year"/>
        
        <i18n:translate>
            <i18n:text i18n:key="PROGRAM_PARCOURSSUP_DATA_APPLICATIONS" i18n:catalogue="skin.{$skin}"/>
            <i18n:param><xsl:value-of select="$year"/></i18n:param>
        </i18n:translate>
    </xsl:template>
    
    <xsl:template match="metadata" mode="parcoursup-data-label">
        <xsl:param name="value"/>
        
        <xsl:value-of select="label"/>
    </xsl:template>
    <!-- END ParcoursSup data -->
    
    <!-- +
         | BEGIN Statistiques admission bac général
         + -->
    <xsl:template match="metadata[@name = 'statistiquesBacGeneral' and @type = 'composite']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value/hidden != 'true' and $value/distribution/@entryCount != '0'">
            <div class="ametys-formation-stats">
               <h2 class="ametys-formation-title-2"><xsl:value-of select="label"/></h2>
               
               <div class="container">
                    <div class="chart-container" style="position: relative;">
                        <canvas id="stats-bacgeneral-chart" aria-label="skin.{$skin}:PROGRAM_STATS_BACGENERAL_ADMISSION_LEGEND" i18n:attr="aria-label" role="img">
                            <!-- Here the accessible alternative -->
                            <ul>
                                <xsl:for-each select="$value/distribution/entry">
                                    <li><xsl:value-of select="speciality1/@title"/> / <xsl:value-of select="speciality2/@title"/>: <xsl:value-of select="admitted"/></li>
                                </xsl:for-each>
                            </ul>
                        </canvas>
                    </div>
                    <xsl:call-template name="stats-bacgeneral-admission-legend">
                        <xsl:with-param name="year" select="$value/year"/>
                    </xsl:call-template>
               </div>
            </div>
            
            <script type="text/javascript">
                $j(document).ready(function() {
                    let admissionData = [];
                    <xsl:for-each select="$value/distribution/entry">
                        <xsl:variable name="shortLabel1">
                            <xsl:choose>
                                <xsl:when test="speciality1/shortLabel != ''"><xsl:value-of select="speciality1/shortLabel"/></xsl:when>
                                <xsl:otherwise><xsl:value-of select="speciality1/@title"/></xsl:otherwise>
                            </xsl:choose>
                        </xsl:variable>
                        <xsl:variable name="shortLabel2">
                            <xsl:choose>
                                <xsl:when test="speciality2/shortLabel != ''"><xsl:value-of select="speciality2/shortLabel"/></xsl:when>
                                <xsl:otherwise><xsl:value-of select="speciality2/@title"/></xsl:otherwise>
                            </xsl:choose>
                        </xsl:variable>
                        
                        admissionData.push({
                            "label" : ["<xsl:value-of select="speciality1/@title"/>", "<xsl:value-of select="speciality2/@title"/>"],
                            "shortLabel" : ["<xsl:value-of select="$shortLabel1"/>", "<xsl:value-of select="$shortLabel2"/>"],
                            "value" : <xsl:value-of select="admission"/>
                        });
                    </xsl:for-each>
                    
                    let admissionDataset = {
                        label: "Pourcentage d\'admission",
                        data: admissionData,
                        backgroundColor: <xsl:call-template name="stats-bacgeneral-chart-admissions-colors"/>,
                    }
                    
                    setTimeout(function() {Dataviz.createChart('stats-bacgeneral-chart', 
                        '<xsl:call-template name="stats-bacgeneral-chart-type"/>', // chart type (pie, doughnut)
                        [admissionDataset], 
                        <xsl:value-of select="$value/percentage"/>, // weight is percentage ?
                        <xsl:call-template name="stats-bacgeneral-max-slices"/>, // max of slices to show
                        <xsl:call-template name="stats-bacgeneral-chart-options"/> // custom options for chart
                    )}, 1);
                });
            </script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="stats-bacgeneral-admission-legend">
        <xsl:param name="year"/>
        
        <p class="legend">
            <xsl:choose>
                <xsl:when test="$year != ''">
                    <i18n:translate>
                        <i18n:text i18n:key="PROGRAM_STATS_BACGENERAL_ADMISSION_LEGEND_WITH_YEAR" i18n:catalogue="skin.{$skin}"/>
                        <i18n:param><xsl:value-of select="$year"/></i18n:param>
                    </i18n:translate>
                </xsl:when>
                <xsl:otherwise>
                    <i18n:text i18n:key="PROGRAM_STATS_BACGENERAL_ADMISSION_LEGEND" i18n:catalogue="skin.{$skin}"/>
                </xsl:otherwise>
            </xsl:choose>
        </p>
    </xsl:template>
    
    <xsl:template name="stats-bacgeneral-max-slices">-1</xsl:template>
    <!-- Chart type : pie, doughnut, or bar -->
    <xsl:template name="stats-bacgeneral-chart-type">bar</xsl:template>
    
    <!-- Chart formatting (See Dataviz.defaultOpts to see more options) -->
    <xsl:template name="stats-bacgeneral-chart-options">
        <xsl:call-template name="bar-chart-options"/>
    </xsl:template>
    
    <xsl:template name="stats-bacgeneral-chart-admissions-colors">
        <xsl:call-template name="chart-gradient-colors"/>
    </xsl:template>
    <!-- END Statistiques admission bac général -->
    
    <!-- +
         | Débouchés professionels (%)
         + -->
    <xsl:template match="metadata[@name = 'careerOutcomes' and @type = 'composite']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value/hidden != 'true' and $value/distribution/@entryCount != '0'">
            <div class="ametys-formation-stats">
               <h2 class="ametys-formation-title-2"><xsl:value-of select="label"/></h2>
               
               <div class="container">
                    <div class="chart-container" style="position: relative;">
                        <canvas id="outcomes-chart" aria-label="skin.{$skin}:PROGRAM_CAREER_OUTCOMES_LEGEND" i18n:attr="aria-label" role="img" style="max-height: 400px;">
                            <!-- Here the accessible alternative -->
                            <ul>
                                <xsl:for-each select="$value/distribution/entry">
                                    <li><xsl:value-of select="careerOutcome/@title"/>: <xsl:value-of select="weight"/></li>
                                </xsl:for-each>
                            </ul>
                        </canvas>
                    </div>
                    <xsl:call-template name="career-outcomes-canvas-legend"/>
               </div>
            </div>
            
            <script type="text/javascript">
                $j(document).ready(function() {
                    let data = [];
                    <xsl:for-each select="$value/distribution/entry">
                        data.push({
                            "label" : "<xsl:value-of select="careerOutcome/@title"/>",
                            "value" : <xsl:value-of select="weight"/>
                        });
                    </xsl:for-each>
                    
                    let dataset = {
                        data: data,
                    }
                    
                    setTimeout(function() {Dataviz.createChart('outcomes-chart', 
                        '<xsl:call-template name="career-outcomes-chart-type"/>', // chart type (pie, doughnut)
                        dataset, 
                        <xsl:value-of select="$value/percentage"/>, // weight is percentage ?
                        <xsl:call-template name="career-outcomes-max-slices"/>, // max of slices to show
                        <xsl:call-template name="career-outcomes-chart-options"/> // custom options for chart
                    )}, 1);
                });
            </script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="career-outcomes-canvas-legend">
        <p class="legend">
            <i18n:text i18n:key="PROGRAM_CAREER_OUTCOMES_LEGEND" i18n:catalogue="skin.{$skin}"/>
        </p>
    </xsl:template>
    
    <xsl:template name="career-outcomes-max-slices">5</xsl:template>
    
    <!-- Chart type : pie, doughnut, or bar -->
    <xsl:template name="career-outcomes-chart-type">doughnut</xsl:template>
    
    <!-- Chart personalization -->
    <xsl:template name="career-outcomes-chart-options">
        <xsl:call-template name="pie-chart-options"/>
    </xsl:template>
    <!-- END Débouchés professionels -->
    
    <!-- +
         | Statistiques post-diplôme (%)
         + -->
    <xsl:template match="metadata[@name = 'postGraduationStatistics' and @type = 'composite']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value/hidden != 'true' and $value/distribution/@entryCount != '0'">
            <div class="ametys-formation-stats">
               <xsl:apply-templates select="." mode="title"/>
               
               <div class="container">
                    <div class="chart-container" style="position: relative;">
                        <canvas id="postgraduation-outcomes-chart" aria-label="skin.{$skin}:PROGRAM_POST_GRADUATIOON_OUTCOMES_LEGEND" i18n:attr="aria-label" role="img" style="max-height: 400px;">
                            <!-- Here the accessible alternative -->
                            <ul>
                                <xsl:for-each select="$value/distribution/entry">
                                    <li><xsl:value-of select="postGraduationOutcome/@title"/>: <xsl:value-of select="weight"/></li>
                                </xsl:for-each>
                            </ul>
                        </canvas>
                    </div>
                    <xsl:call-template name="postgraduation-outcomes-canvas-legend">
                        <xsl:with-param name="monthsAfterGraduation" select="$value/monthsAfterGraduation"/>
                    </xsl:call-template>
               </div>
            </div>
            
            <script type="text/javascript">
                $j(document).ready(function() {
                    let data = [];
                    <xsl:for-each select="$value/distribution/entry">
                        data.push({
                            "label" : "<xsl:value-of select="postGraduationOutcome/@title"/>",
                            "value" : <xsl:value-of select="weight"/>
                        });
                    </xsl:for-each>
                    
                    let dataset = {
                        data: data,
                    }
                    
                    setTimeout(function() {Dataviz.createChart('postgraduation-outcomes-chart', 
                        '<xsl:call-template name="postgraduation-outcomes-chart-type"/>', // chart type (pie, doughnut)
                        dataset, 
                        <xsl:value-of select="$value/percentage"/>, // weight is percentage ?
                        <xsl:call-template name="postgraduation-outcomes-max-slices"/>, // max of slices to show
                        <xsl:call-template name="postgraduation-outcomes-chart-options"/> // custom options for chart
                    )}, 1);
                });
            </script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'postGraduationStatistics' and @type = 'composite']" mode="title">
        <!-- No title by default -->
        <!-- <h2 class="ametys-formation-title-2"><i18n:text i18n:key="PROGRAM_POST_GRADUATION_OUTCOMES" i18n:catalogue="skin.{$skin}"/></h2> -->
    </xsl:template>
    
    <xsl:template name="postgraduation-outcomes-canvas-legend">
        <xsl:param name="monthsAfterGraduation"/>
        
        <p class="legend">
            <xsl:choose>
                <xsl:when test="$monthsAfterGraduation != ''">
                    <i18n:translate>
                        <i18n:text i18n:key="PROGRAM_POST_GRADUATIOON_OUTCOMES_LEGEND_WITH_MONTHS" i18n:catalogue="skin.{$skin}"/>
                        <i18n:param><xsl:value-of select="$monthsAfterGraduation"/></i18n:param>
                    </i18n:translate>
                </xsl:when>
                <xsl:otherwise>
                    <i18n:text i18n:key="PROGRAM_POST_GRADUATIOON_OUTCOMES_LEGEND" i18n:catalogue="skin.{$skin}"/>
                </xsl:otherwise>
            </xsl:choose>
        </p>
    </xsl:template>
    
    <xsl:template name="postgraduation-outcomes-max-slices">5</xsl:template>
    
    <!-- Chart type : pie, doughnut, or bar -->
    <xsl:template name="postgraduation-outcomes-chart-type">doughnut</xsl:template>
    
    <!-- Chart personalization -->
    <xsl:template name="postgraduation-outcomes-chart-options">
        <xsl:call-template name="pie-chart-options"/>
    </xsl:template>
    <!-- END Statistiques post-diplôme -->
    
    
    <!-- *************  DEFAULTS OPTIONS FOR CHARTS ************** -->
    
    <!-- Default options for pie or doughnut chart -->
    <xsl:template name="pie-chart-options">
    {
        legend: {
            position: window.innerWidth > 900 ? 'right' : 'bottom',
            labels: {
                color: '<xsl:call-template name="chart-text-color"/>',
                font: {
                    size: window.innerWidth > 600 ? 14 : 12,
                    family: "<xsl:call-template name="chart-font-family"/>"
                }
            }
        },
        datalabels: {
            color: '#fff',
            backgroundColor: 'transparent',
            font: {
                size: 12,
                family: "<xsl:call-template name="chart-font-family"/>",
                weight: 'bold'
            }
        },
        backgroundColor : <xsl:call-template name="chart-default-colors"/>
    }
    </xsl:template>
    
    <!-- Default options for bar chart -->
    <xsl:template name="bar-chart-options">
    {
        // Customize axes
        scales: {
            ticks: {
                color: '<xsl:call-template name="chart-text-color"/>',
                font : {
                    size: 12,
                    family: "<xsl:call-template name="chart-font-family"/>"
                }
            }
        },
        // Customize slice text
        datalabels: {
            color: '#fff',
            backgroundColor: 'transparent',
            font: {
                size: 12,
                family: "<xsl:call-template name="chart-font-family"/>",
                weight: 'bold',
            }
        },
        // Legend position and formatting
        legend: {
            position: 'top',
            align: 'center',
            display: false, // set to true to show legend (requires if multiple datasets)
            labels: {
                color: '<xsl:call-template name="chart-text-color"/>',
                font: {
                    size: window.innerWidth > 600 ? 14 : 12,
                    family: "<xsl:call-template name="chart-font-family"/>"
                }
            }
        }
    }
    </xsl:template>
    
    <!-- Chart default colors, ordered by data index -->
    <xsl:template name="chart-default-colors">
        [
            'rgb(33, 114, 38)', // green
            'rgb(82, 28, 126)', // purple
            'rgb(44, 72, 133)', // blue
            'rgb(218, 105, 105)', // red
            'rgb(227, 132, 0)', // orange
            'rgb(218, 105, 105)', // pink
            '#ffcc00', // yellow
            '#48ccdc', // cyan
            '#c69bf1', // lavender
            '#dac669', // gold
            '#da69b2', // magenta
            '#b4b4b4' // gray
        ]
    </xsl:template>
    
    <!-- Charts colors with additional patterns for RGAA purpose -->
    <xsl:template name="chart-colors-with-patterns">
        [
            pattern.draw('line', 'rgb(33, 114, 38)'), // green
            pattern.draw('line-vertical', 'rgb(82, 28, 126)'), // purple
            pattern.draw('zigzag', 'rgb(44, 72, 133)'), // blue
            pattern.draw('dot', 'rgb(218, 105, 105)'), // red
            pattern.draw('diagonal', 'rgb(227, 132, 0)'), // orange
            pattern.draw('plus', 'rgb(218, 105, 105)'), // pink
            pattern.draw('dash', '#ffcc00'), // yellow
            pattern.draw('line-vertical', '#48ccdc'), // cyan
            pattern.draw('box', '#c69bf1'), // lavender
            pattern.draw('weave', '#dac669'), // gold
            pattern.draw('ring', '#da69b2'), // magenta
            pattern.draw('square', #b4b4b4') // gray
        ]
    </xsl:template>
    
    <!-- Chart gradient colors for single dataset charts -->
    <xsl:template name="chart-gradient-colors">
        [
            'rgb(82, 28, 126)', 
            'rgba(82, 28, 126, 0.9)', 
            'rgba(82, 28, 126, 0.85)',
            'rgba(82, 28, 126, 0.8)', 
            'rgba(82, 28, 126, 0.75)', 
            'rgba(82, 28, 126, 0.7)', 
            'rgba(82, 28, 126, 0.65)', 
            'rgba(82, 28, 126, 0.6)', 
            'rgba(82, 28, 126, 0.55)', 
            'rgba(82, 28, 126, 0.5)', 
            'rgba(82, 28, 126, 0.45)', 
            'rgba(82, 28, 126, 0.4)'
        ]
    </xsl:template>
    
    <xsl:template name="chart-font-family">'Montserrat', sans-serif</xsl:template>
    <xsl:template name="chart-text-color">#2E1E3D</xsl:template>
    
</xsl:stylesheet>