<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:cms="http://ametys.org/cms/3.0" 
        xmlns:exslt="http://exslt.org/common"
        exclude-result-prefixes="sitemap ametys resolver odf escaper cms  exslt">
        
   <!-- +
         | Template for "Program" lime
         | This lime contains the semesters table and/or the courses 
         + -->
    <xsl:template match="fieldset[@role='tab' and @name='orientation']" mode="display">
        <xsl:variable name="self" select="."/>
        
        <xsl:variable name="paths" select="/view/orientation-paths/path"/>
        
        <xsl:if test="cms:isNotFieldsetEmpty($self) or count($paths) &gt; 0">
            <section id="tab-{generate-id()}" class="ametys-formation-section" role="contentinfo" aria-label="{label}">
                <div class="container">
                    <div class="ametys-formation-section__col">
                        <h2 class="ametys-formation-title"><xsl:value-of select="label"/></h2>
                        
                        <div class="ametys-parcours-container">
                            <div class="ametys-parcours-scrollable">
                                <xsl:variable name="nbMaxYears" select="/view/orientation-paths/@nbMaxYears"/>
                                
                                <!-- Years line -->
                                <xsl:call-template name="years-line">
                                    <xsl:with-param name="nbMaxYears" select="$nbMaxYears"/>
                                </xsl:call-template>
                                
                                <!-- Graph with all paths -->
                                <div class="ametys-parcours-graph">
                                    <xsl:apply-templates select="/view/orientation-paths/path" mode="program-path">
                                        <xsl:with-param name="nbMaxYears" select="'3'"/>
                                    </xsl:apply-templates>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="years-line">
        <xsl:param name="nbMaxYears"/>
    
        <div class="ametys-parcours-nav" style="--nbColumns: {$nbMaxYears}">
            <!-- Insert year section util $nbMaxYears is reached -->
            <xsl:call-template name="years-line-section">
                <xsl:with-param name="level" select="'1'"/>
                <xsl:with-param name="nbMaxYears" select="$nbMaxYears"/>
            </xsl:call-template>
        </div>
   </xsl:template>
   
   <xsl:template name="years-line-section">
        <xsl:param name="level"/>
        <xsl:param name="nbMaxYears"/>
        
        <div class="ametys-parcours-year">
            <span class="ametys-parcours-year-text">Année <xsl:value-of select="$level"/></span>
        </div>
        
        <xsl:if test="$level &lt; $nbMaxYears">
            <xsl:call-template name="years-line-section">
                <xsl:with-param name="level" select="$level + 1"/>
                <xsl:with-param name="nbMaxYears" select="$nbMaxYears"/>
            </xsl:call-template>
        </xsl:if>
            
   </xsl:template>
      
    <xsl:template match="path" mode="program-path">
        <xsl:param name="nbMaxYears"/>
        
        <xsl:variable name="self" select="."/>
        
        <div class="ametys-parcours-line" style="--nbColumns: {$nbMaxYears}">
        
            <xsl:variable name="firstYear" select="year[@number = '1']"/>
            
            <!-- Année 1 -->
            <xsl:call-template name="year">
                <xsl:with-param name="year" select="$firstYear"/>
                <xsl:with-param name="self" select="$self"/>
                <xsl:with-param name="colspan" select="'1'"/>
                <xsl:with-param name="level" select="'1'"/>
                <xsl:with-param name="nbMaxYears" select="$nbMaxYears"/>
            </xsl:call-template>
        </div>
    </xsl:template>          
          
    <xsl:template name="year">
        <xsl:param name="level"/><!-- The year level -->
        <xsl:param name="year"/><!-- The year -->
        <xsl:param name="self"/>
        <xsl:param name="colspan"/>
        <xsl:param name="nbMaxYears"/><!-- The number of max years -->
        
        <div class="ametys-parcours-graph__bar" style="--column: {$colspan}">
            <a href="#">
                <span class="ametys-parcours-graph__bar-title">
                    <xsl:value-of select="$year/title"/>
                </span>
                <span class="ametys-parcours-graph__bar-text">
                    <xsl:value-of select="$year/description"/>
                </span>
            </a>
        </div>
        
        <!-- Next year(s) -->
        <xsl:choose>
            <xsl:when test="count($year/next-paths/path) = 1">
                <xsl:variable name="nextYearId" select="$year/next-paths/path/@ref"/>
                <xsl:variable name="nextYear" select="$self/year[@id = $nextYearId]"/>
                
                <xsl:call-template name="year">
                    <xsl:with-param name="year" select="$nextYear"/>
                    <xsl:with-param name="colspan" select="'1'"/>
                    <xsl:with-param name="self" select="$self"/>
                    <xsl:with-param name="level" select="$level + 1"/>
                    <xsl:with-param name="nbMaxYears" select="$nbMaxYears"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="count($year/next-paths/path) &gt; 1">
                <div class="ametys-parcours-graph-group" style="--column: {($nbMaxYears - $level)}">
                    <div>
                        <xsl:for-each select="$year/next-paths/path">
                            <xsl:variable name="nextYearId" select="@ref"/>
                            <xsl:variable name="nextYear" select="$self/year[@id = $nextYearId]"/>
                            
                            <div class="ametys-parcours-subline" style="--nbColumns: {($nbMaxYears - $level)}">
                                <xsl:call-template name="year">
                                    <xsl:with-param name="year" select="$nextYear"/>
                                    <xsl:with-param name="colspan" select="'1'"/>
                                    <xsl:with-param name="self" select="$self"/>
                                    <xsl:with-param name="level" select="$level + 1"/>
                                    <xsl:with-param name="nbMaxYears" select="$nbMaxYears"/>
                                </xsl:call-template>
                            </div>
                        </xsl:for-each>
                    </div>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <!-- No more year -->
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
        
</xsl:stylesheet>