<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:cms="http://ametys.org/cms/3.0"
        exclude-result-prefixes="sitemap ametys resolver odf cms">
        
    <xsl:template match="metadata[@name = 'otherPrograms']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <section class="ametys-formation-section others-formations" role="contentinfo" aria-label="skin.{$skin}:PROGRAM_OTHER_PROGRAMS_ARIA_LABEL" i18n:attr="aria-label">
                <div class="container">
                    <h2 class="service-title"><i18n:text i18n:key="PROGRAM_OTHER_PROGRAMS_TITLE" i18n:catalogue="skin.{$skin}"/></h2>

                    <xsl:variable name="definition" select="."/>
                    <div class="others-formations__list"  data-carousel="true">
                        <xsl:for-each select="$value">
                            <xsl:apply-templates select="$definition" mode="value">
                                <xsl:with-param name="value" select="."/>
                            </xsl:apply-templates>
                        </xsl:for-each>
                    </div>
                    
                    <div class="others-formations-nav-wrapper" data-carousel-nav="true"></div>
                </div>
            </section>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'otherPrograms' and @type='content']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="contentId" select="$value/@id" />
        <xsl:if test="$contentId != ''">
            <a href="{resolver:resolve('odf', $contentId)}" class="others-formations__item">
                
                <xsl:apply-templates select="." mode="image">
                    <xsl:with-param name="value" select="$value"/>
                </xsl:apply-templates>

                <div class="others-formations__item__content">

                    <h3 class="others-formations__item__content__title">
                        <xsl:value-of select="$value/title"/>
                    </h3>
                    <p>
                        <xsl:call-template name="common-utils-simpletext">
                            <xsl:with-param name="defaultText" select="$value/presentation"/>                
                            <xsl:with-param name="maxDefaultTextSize" select="150"/>                
                        </xsl:call-template>
                    </p>
                </div>
            </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'otherPrograms' and @type='content']" mode="image">
        <xsl:param name="value"/>
        
        <xsl:variable name="imgSrc">
            <xsl:call-template name="program-image-url">
                <xsl:with-param name="contentId" select="$value/@id"/>
                <xsl:with-param name="maxWidth" select="'600'"/>
                <xsl:with-param name="maxHeight" select="'400'"/>
            </xsl:call-template>
        </xsl:variable>
        
        <div class="others-formations__item__picture">
            <picture>
                <source
                    srcset="{$imgSrc}"
                    type="image/png"/>
                <img
                    src="{$imgSrc}"
                    alt=""/>
            </picture>
        </div>
        
    </xsl:template>
    
</xsl:stylesheet>