<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:docbook="http://docbook.org/ns/docbook" 
        xmlns:exslt="http://exslt.org/common"
        exclude-result-prefixes="sitemap ametys resolver odf escaper docbook exslt">
    
    <xsl:import href="plugin:odf://pages/helper/skills.xsl"/>
    
    <xsl:template match="skills" mode="display">
        <xsl:variable name="hiddenSkills" select="odf:areSkillsUnavailable(/view/content/@id, ametys:pageId())"/>
        <xsl:if test="skillSet and not($hiddenSkills)">
            <div class="ametys-formation-skills ametys-richtext">
                <h3 class="ametys-richtext-title-2"><i18n:text i18n:key="PROGRAM_SKILLS" i18n:catalogue="skin.{$skin}"/></h3>
                                                    
                <xsl:apply-templates select="skillSet" mode="display"/>
                
                <!-- Skills table -->
                <xsl:call-template name="program-skills">
                    <xsl:with-param name="currentProgramItem" select="/view/structure/*[@id = /view/content/@id]"/>
                </xsl:call-template>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="skillSet" mode="display">
        <h4 class="ametys-richtext-title-4"><xsl:value-of select="@title"/></h4>
        
        <xsl:call-template name="skill-badges">
            <xsl:with-param name="skills" select="skill"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="program-skills">
        <xsl:param name="currentProgramItem"/>
        
        <xsl:if test="/view/skills/skillSet">
            <button id="popup-skills-invoker" role="button" class="btn btn-primary" aria-haspopup="dialog"><i18n:text i18n:key="PROGRAM_SEE_SKILLS_TABLE" i18n:catalogue="skin.{$skin}"/></button>
            
            <div id="popup-skills" class="ametys-modal ylightbox" aria-hidden="true" role="dialog" aria-modal="true" aria-labelledby="popup-skills-title">
                <div class="ylightbox__backdrop" data-close-skills=""></div>
                    <div class="ylightbox__dialog" role="document">
                      <button class="ametys-modal-close" type="button" aria-label="Fermer la modal" data-close-skills="">
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" focusable="false" aria-hidden="true">
                            <path d="M8 6.54545L14.5455 0L16 1.45455L9.45455 8L16 14.5455L14.5455 16L8 9.45455L1.45455 16L0 14.5455L6.54545 8L0 1.45455L1.45455 0L8 6.54545Z" fill="#521C7E"></path>
                        </svg>
                      </button>
                      
                      <h2 id="popup-skills-title" class="ametys-modal-title"><i18n:text i18n:key="PROGRAM_SKILLS_TABLE" i18n:catalogue="skin.{$skin}"/></h2>
                      
                      <xsl:variable name="years" select="$currentProgramItem//container[attributes/nature/@code='annee'and not(@excludedFromSkills) and not(ancestor::*/@excludedFromSkills = 'true')]"/>
                      
                      <div class="ametys-modal-content" data-skills-content="">
                        <div class="ametys-skills-table__wrapper" style="overflow: auto">
                            <xsl:choose>
                                <xsl:when test="$years">
                                    <xsl:call-template name="skills-table">
                                        <xsl:with-param name="skills" select="/view/skills"/>
                                        <xsl:with-param name="years" select="$years"/>
                                        <xsl:with-param name="additionalCls">table</xsl:with-param>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                     <xsl:call-template name="skills-table">
                                        <xsl:with-param name="skills" select="/view/skills"/>
                                        <xsl:with-param name="semesters" select="$currentProgramItem//container[attributes/nature/@code='semestre' and not(@excludedFromSkills)]"/>
                                        <xsl:with-param name="additionalCls">table</xsl:with-param>
                                    </xsl:call-template>
                                </xsl:otherwise>
                            </xsl:choose>
                        </div>
                    </div>
                </div>
            </div>
            <script type="text/javascript">
                // Gestion des passerelles
                  (function () {
                    const skillsModal = document.getElementById('popup-skills');
                    if (!skillsModal) return;
                
                    const closeEls = skillsModal.querySelectorAll('[data-close-skills]');
                    let lastFocused = null;
                
                    function openSkillsModal() {
                      lastFocused = document.activeElement;
                      skillsModal.setAttribute('aria-hidden', 'false');
                      document.body.classList.add('ylightbox-open');
                      skillsModal.querySelector('.skills-modal-close')?.focus();
                      document.addEventListener('keydown', onKeydown);
                      
                      AmetysFront.Accessibility.trapFocus(skillsModal);
                    }
                
                    function closeSkillsModal() {
                      skillsModal.setAttribute('aria-hidden', 'true');
                      document.body.classList.remove('ylightbox-open');
                      document.removeEventListener('keydown', onKeydown);
                      AmetysFront.Accessibility.untrapFocus(skillsModal);
                      if (lastFocused &amp;&amp; typeof lastFocused.focus === 'function') lastFocused.focus();
                    }
                
                    function onKeydown(e) {
                      if (e.key === 'Escape' || e.key === 'Esc') closeSkillsModal();
                    }
                
                    closeEls.forEach(el => el.addEventListener('click', closeSkillsModal));
                    skillsModal.addEventListener('click', (e) => {
                      const withinDialog = e.target.closest('.ylightbox__dialog');
                      if (!withinDialog) closeSkillsModal();
                    });
                    
                     __popupSkillsInitialized = false;
                
                   $j('#popup-skills-invoker').on('click', function() {
                   
                       openSkillsModal();
                        
                       var tableWrap = $j('.ametys-skills-table__wrapper'),
                            popupContent = tableWrap.parent(),
                            popup = popupContent.parent(),
                            popupHeight = popup.height(),
                            titleHeight = popup.find('.ametys-modal-title').outerHeight(true);
                            
                       // popupContent.outerHeight(popupHeight);     
                       tableWrap.outerHeight(popupHeight - titleHeight);  
                       
                       if (!__popupSkillsInitialized)
                       {
                           var table = tableWrap.find('table');
                           var head01Top = table.find("thead > tr:nth-child(1) > th:nth-child(1)").position().top;
                           table.find("thead > tr:nth-child(1) > th").css('top', head01Top);
                           table.find("thead > tr:nth-child(1) > th").css('position', 'sticky');
                           
                           var head02Top = table.find("thead > tr:nth-child(2) > th:nth-child(1)").position().top;
                           table.find("thead > tr:nth-child(2) > th").css('top', head02Top);
                           table.find("thead > tr:nth-child(2) > th").css('position', 'sticky');
                           
                           var head03Top = table.find("thead > tr:nth-child(3) > th:nth-child(1)").position().top;
                           table.find("thead > tr:nth-child(3) > th").css('top', head03Top);
                           table.find("thead > tr:nth-child(3) > th").css('position', 'sticky');
                           
                           table.find("thead > tr > th:nth-child(1)").css('left', 0);
                           table.find("thead > tr > th:nth-child(1)").css('z-index', 10);
                           
                           
                           var head01Left = table.find("tbody > tr:nth-child(1) > th:nth-child(1)").position().left;
                           var head02Left = table.find("tbody > tr:nth-child(1) > th:nth-child(2)").position().left;
                           
                           table.find("tbody > tr > th").css('left', head02Left);
                           table.find("tbody > tr > th[rowspan]").css('left', head01Left);
                           table.find("tbody > tr > th").css('position', 'sticky');
                           table.find("tbody > tr > th").css('z-index', 5);
                           
                           __popupSkillsInitialized = true;
                        }
                   });
                  })();
            </script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="skill-badges">
        <xsl:param name="skills"/>
        <xsl:param name="searchPage" select="ametys:findPagesIdsByTag('SEARCH_ODF')"/>
        <xsl:param name="withSearch" select="true()"/>
        
        <xsl:if test="count($skills) > 0">
            <ul class="skills-list">
                <xsl:for-each select="$skills">
                    <li class="skills-list__item">
                        <xsl:choose>
                            <xsl:when test="$withSearch">
                                <form action="{resolver:resolve('page', $searchPage/@id)}" method="post">
                                    <div>
                                        <input type="hidden" name="submit-form"/>
                                        <input type="hidden" name="skillId" value="{@id}"/>
                                        <button class="skills-list__item__label"><xsl:value-of select="@title" /></button>
                                    </div>    
                                </form>
                            </xsl:when>
                            <xsl:otherwise>
                                <span cclass="skills-list__item__label"><xsl:value-of select="@title" /></span>
                            </xsl:otherwise>
                        </xsl:choose>
                    </li>
                </xsl:for-each>
            </ul>
        </xsl:if>
            
        <xsl:if test="$withSearch">
            <script type="text/javascript">
                $j('form .skills-list__item_label').on('click', (e) => {
                     e.preventDefault();
                     $j(this).closest('form').submit();
                });
            </script>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>