<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
	            xmlns:datetime="http://ametys.org/datetime/4.2"
                xmlns:dateutils="org.ametys.core.util.DateUtils"
	            extension-element-prefixes="datetime dateutils ametys">
   
   <xsl:import href="plugin:core://stylesheets/helper/datetime.xsl"/>
   
   <xsl:variable name="date-time-format" select="ametys:translate(concat('skin.', $skin, ':SKIN_DATE_TIME_FORMAT'))"></xsl:variable>
   <xsl:variable name="date-format" select="ametys:translate(concat('skin.', $skin, ':SKIN_DATE_FORMAT'))"></xsl:variable>
   
   <xsl:template name="dates">
        <xsl:param name="startDate"/>
        <xsl:param name="endDate"/>
        <xsl:param name="showTime">true</xsl:param>
        <xsl:param name="withIcon">true</xsl:param>
        <xsl:param name="className">date</xsl:param>
        
        <xsl:if test="$startDate or $endDate">
            <span class="{$className}'">
                <xsl:if test="$withIcon != 'false'">
                    <xsl:call-template name="dates-icon"/>
                </xsl:if>
                
                <span>
    	            <xsl:call-template name="dates-inner">
                        <xsl:with-param name="startDate" select="$startDate"/>
                        <xsl:with-param name="endDate" select="$endDate"/>
                        <xsl:with-param name="showTime" select="$showTime"/>
                    </xsl:call-template>
                </span>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="dates-inner">
        <xsl:param name="startDate"/>
        <xsl:param name="endDate"/>
        <xsl:param name="showTime">true</xsl:param>
        
        <xsl:choose>
            <xsl:when test="$startDate and not($endDate)">
                <xsl:call-template name="date-pattern">
                    <xsl:with-param name="date" select="$startDate"/>
                    <xsl:with-param name="role" select="'dtstart'"/>
                    <xsl:with-param name="showTime" select="$showTime"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$endDate and not($startDate)">
                <xsl:call-template name="date-pattern">
                    <xsl:with-param name="date" select="$endDate"/>
                    <xsl:with-param name="role" select="'dtend'"/>
                    <xsl:with-param name="showTime" select="$showTime"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$startDate and $endDate and $showTime = 'false' and datetime:sameDate($startDate, $endDate)">
                <xsl:call-template name="date-pattern">
                    <xsl:with-param name="date" select="$startDate"/>
                    <xsl:with-param name="role" select="'dtstart'"/>
                    <xsl:with-param name="showTime" select="$showTime"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$startDate and $endDate and datetime:sameDateTime($startDate, $endDate)">
                <xsl:call-template name="date-pattern">
                    <xsl:with-param name="date" select="$startDate"/>
                    <xsl:with-param name="role" select="'dtstart'"/>
                    <xsl:with-param name="showTime" select="$showTime"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$startDate and $endDate">
                <xsl:call-template name="date-pattern">
                    <xsl:with-param name="date" select="$startDate"/>
                    <xsl:with-param name="role" select="'dtstart'"/>
                    <xsl:with-param name="showTime" select="$showTime"/>
                </xsl:call-template>
                <xsl:call-template name="date-separator"/>
                <xsl:call-template name="date-pattern">
                    <xsl:with-param name="date" select="$endDate"/>
                    <xsl:with-param name="role" select="'dtend'"/>
                    <xsl:with-param name="showTime" select="$showTime"/>
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="dates-icon">
        <svg width="24" height="20" viewBox="0 0 24 20" fill="none" xmlns="http://www.w3.org/2000/svg" focusable="false" aria-hidden="true">
            <path
                d="M7.88285 3.33366H7.09475C5.99104 3.33366 5.43878 3.33366 5.01722 3.51531C4.6464 3.6751 4.34514 3.92989 4.1562 4.24349C3.94141 4.60001 3.94141 5.06707 3.94141 6.00049V6.66699M7.88285 3.33366H15.7657M7.88285 3.33366V1.66699M15.7657 3.33366H16.5542C17.6579 3.33366 18.209 3.33366 18.6306 3.51531C19.0014 3.6751 19.3036 3.92989 19.4926 4.24349C19.7072 4.59966 19.7072 5.06615 19.7072 5.99775V6.66699M15.7657 3.33366V1.66699M3.94141 6.66699V14.0005C3.94141 14.9339 3.94141 15.4004 4.1562 15.7569C4.34514 16.0705 4.6464 16.3257 5.01722 16.4855C5.43837 16.667 5.98996 16.667 7.09151 16.667H16.5571C17.6586 16.667 18.2094 16.667 18.6306 16.4855C19.0014 16.3257 19.3036 16.0705 19.4926 15.7569C19.7072 15.4007 19.7072 14.9349 19.7072 14.0033V6.66699M3.94141 6.66699H19.7072M15.7657 13.3337H15.7677L15.7677 13.3353L15.7657 13.3353V13.3337ZM11.8243 13.3337H11.8263L11.8262 13.3353L11.8243 13.3353V13.3337ZM7.88285 13.3337H7.88482L7.88477 13.3353L7.88285 13.3353V13.3337ZM15.7677 10.0003V10.002L15.7657 10.002V10.0003H15.7677ZM11.8243 10.0003H11.8263L11.8262 10.002L11.8243 10.002V10.0003ZM7.88285 10.0003H7.88482L7.88477 10.002L7.88285 10.002V10.0003Z"
                stroke="#2E1E3D" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
            <path
                d="M7.88285 3.33366H7.09475C5.99104 3.33366 5.43878 3.33366 5.01722 3.51531C4.6464 3.6751 4.34514 3.92989 4.1562 4.24349C3.94141 4.60001 3.94141 5.06707 3.94141 6.00049V6.66699M7.88285 3.33366H15.7657M7.88285 3.33366V1.66699M15.7657 3.33366H16.5542C17.6579 3.33366 18.209 3.33366 18.6306 3.51531C19.0014 3.6751 19.3036 3.92989 19.4926 4.24349C19.7072 4.59966 19.7072 5.06615 19.7072 5.99775V6.66699M15.7657 3.33366V1.66699M3.94141 6.66699V14.0005C3.94141 14.9339 3.94141 15.4004 4.1562 15.7569C4.34514 16.0705 4.6464 16.3257 5.01722 16.4855C5.43837 16.667 5.98996 16.667 7.09151 16.667H16.5571C17.6586 16.667 18.2094 16.667 18.6306 16.4855C19.0014 16.3257 19.3036 16.0705 19.4926 15.7569C19.7072 15.4007 19.7072 14.9349 19.7072 14.0033V6.66699M3.94141 6.66699H19.7072M15.7657 13.3337H15.7677L15.7677 13.3353L15.7657 13.3353V13.3337ZM11.8243 13.3337H11.8263L11.8262 13.3353L11.8243 13.3353V13.3337ZM7.88285 13.3337H7.88482L7.88477 13.3353L7.88285 13.3353V13.3337ZM15.7677 10.0003V10.002L15.7657 10.002V10.0003H15.7677ZM11.8243 10.0003H11.8263L11.8262 10.002L11.8243 10.002V10.0003ZM7.88285 10.0003H7.88482L7.88477 10.002L7.88285 10.002V10.0003Z"
                stroke="url(#paint0_linear_4633_7395)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
            <defs>
                <linearGradient id="paint0_linear_4633_7395" x1="11.8243" y1="1.66699" x2="11.8243" y2="16.667" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#A2A2A2" stop-opacity="0.6"></stop>
                    <stop offset="1" stop-color="#A2A2A2" stop-opacity="0.6"></stop>
                </linearGradient>
            </defs>
        </svg>
    </xsl:template>
    
    <xsl:template name="date-pattern">
        <xsl:param name="date"/>
        <xsl:param name="role"/>
        <xsl:param name="showTime">true</xsl:param>
        
        <xsl:choose>
            <xsl:when test="$showTime = 'false' or dateutils:isAtMidnight($date, '')">
                <!-- If hour is 00:00 do not display hours -->
                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-format}" value="{$date}"/>
            </xsl:when>
            <xsl:otherwise>
                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-time-format}" value="{$date}"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="date-separator">
        <xsl:text>&#160; - &#160;</xsl:text>
    </xsl:template>             
</xsl:stylesheet>