<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

    <xsl:template name="footer">
        <footer role="contentinfo" class="footer">
            <xsl:call-template name="footer-top"/>
            <xsl:call-template name="footer-bottom"/>
        </footer>
    </xsl:template>
    
    <xsl:template name="footer-top">
        <div class="top__footer">
            <div class="container">
                <div class="footer__columns">
                    <xsl:call-template name="footer-column-1"/>
                    <xsl:call-template name="footer-column-2"/>
                    <xsl:call-template name="footer-column-3"/>
                    <xsl:call-template name="footer-column-4"/>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="footer-column-1">
        <div class="footer__column">
            <xsl:call-template name="footer-logo"/>
            <xsl:call-template name="footer-address"/>
            <xsl:call-template name="footer-social-networks"/>
        </div>
    </xsl:template>
    
    <!-- Catalogue -->
    <xsl:template name="footer-column-2">
        <div class="footer__column">
            <xsl:call-template name="footer-links">
                <xsl:with-param name="pages" select="/cms/inputData/sitemap//page[@PLUGIN_TAGS_CATALOG]"/>
                <xsl:with-param name="title"><i18n:text i18n:key="SKIN_FOOTER_LINKS_CATALOG" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <!-- Direct access -->
    <xsl:template name="footer-column-3">
        <div class="footer__column">
            <xsl:call-template name="footer-links">
                <xsl:with-param name="pages" select="/cms/inputData/sitemap//page[@PLUGIN_TAGS_DIRECTACCESS]"/>
                <xsl:with-param name="title"><i18n:text i18n:key="SKIN_FOOTER_LINKS_DIRECTACCESS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <!-- Other links -->
    <xsl:template name="footer-column-4">
        <div class="footer__column">
            <xsl:call-template name="footer-links">
                <xsl:with-param name="pages" select="/cms/inputData/sitemap//page[@PLUGIN_TAGS_FOOTER_LINKS]"/>
                <xsl:with-param name="title"><i18n:text i18n:key="SKIN_FOOTER_LINKS_OTHERS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="footer-logo">
        <xsl:variable name="i18nparams"><title><xsl:value-of select="ametys:siteParameter('title')"/></title></xsl:variable> 
        <xsl:variable name="i18nkey" select="concat('skin.', $skin, ':SKIN_LOGO_ALT')"/>
        <xsl:variable name="logo-title">
            <xsl:value-of select="ametys:translate($i18nkey, $lang, $i18nparams)"/>
        </xsl:variable>
        
        <div class="footer__logo">
            <a href="{$site-uri-prefix}/{$lang}/index.html" title="{$logo-title}">
                <xsl:call-template name="footer-logo-img"/>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template name="footer-logo-img">
        <svg width="239" height="116" viewBox="0 0 239 116" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" focusable="false" aria-hidden="true">
            <rect y="0.000244141" width="238.554" height="115.092" fill="url(#pattern0_5518_16167)"></rect>
            <defs>
                <pattern id="pattern0_5518_16167" patternContentUnits="objectBoundingBox" width="1" height="1">
                    <use xlink:href="#image0_5518_16167" transform="scale(0.00279005 0.00578302)"></use>
                </pattern>
                <image id="image0_5518_16167" width="655" height="173" preserveAspectRatio="none"
                    xlink:href="data:image/png;base64,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"></image>
            </defs>
        </svg>
    </xsl:template>
    
    <xsl:template name="footer-address">
        <p class="footer__address">
            Ametys Campus<br/>
            40 rue du Village d'Entreprises<br/>
            31670 Labège
        </p>
    </xsl:template>
    
    <xsl:template name="footer-social-networks">
        <xsl:if test="/cms/inputData/linkDirectory[@id='socialNetworks']/links/link[not(@disabled)]">
            <div class="footer__socials">
                <ul class="footer__socials__list">
                    <xsl:apply-templates select="/cms/inputData/linkDirectory[@id='socialNetworks']/links/link[not(@disabled)]" mode="social-link"/>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="link" mode="social-link">
        <li>
            <xsl:choose>
                <xsl:when test="@urlType = 'PAGE'">
                    <a href="{resolver:resolve('page', @url)}">
                        <xsl:apply-templates select="." mode="social-link-icon"/>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                   <a href="{@url}" target="_blank">
                        <xsl:apply-templates select="." mode="social-link-icon"/>
                   </a> 
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>
    
    <xsl:template match="link" mode="social-link-icon">
        <xsl:choose>
            <xsl:when test="@pictureType = ''">
                <!-- No picture -->
                <span class="link-text"><xsl:value-of select="@title"/></span>
            </xsl:when>
            <xsl:when test="@pictureType = 'glyph'">
                <span class="picture link-glyph {@pictureGlyph}" role="img">
                    <xsl:attribute name="aria-label">
                        <xsl:choose>
                            <xsl:when test="@pictureAlternative != ''"><xsl:value-of select="@pictureAlternative"/></xsl:when>
                            <xsl:otherwise><xsl:value-of select="@title"/></xsl:otherwise>
                        </xsl:choose>        
                    </xsl:attribute>
                </span>
            </xsl:when>
            <xsl:otherwise>
                 <xsl:variable name="imgId">
                    <xsl:choose>
                        <xsl:when test="@pictureType = 'resource'">
                            <xsl:value-of select="@pictureId" />
                        </xsl:when>
                        <xsl:when test="@pictureType = 'external'">
                            <xsl:value-of select="concat(@picturePath, '?objectId=', @id)" />
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <img data-svg="true" src="{resolver:resolveBoundedImage(@imageType, $imgId, 0, 0)}">
                    <xsl:attribute name="alt">
                        <xsl:choose>
                            <xsl:when test="@pictureAlternative != ''"><xsl:value-of select="@pictureAlternative"/></xsl:when>
                            <xsl:otherwise><xsl:value-of select="@title"/></xsl:otherwise>
                        </xsl:choose>        
                    </xsl:attribute>
                </img>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="footer-links">
        <xsl:param name="title"/>
        <xsl:param name="pages"/>
        
        <xsl:if test="$pages">
            <h3 class="footer__title"><xsl:copy-of select="$title"/></h3>
            <div class="footer__links">
                <ul class="footer__links__list">
                    <xsl:apply-templates select="$pages" mode="footer-link-item"/>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="page" mode="footer-link-item">
        <li>
            <a href="{resolver:resolve('page', @sitemap:id)}"><xsl:value-of select="@sitemap:title"/></a>
        </li>
    </xsl:template>
    
    <xsl:template name="footer-bottom">
        <div class="sub__footer">
            <div class="container">
                <xsl:call-template name="footer-partners"/>
                <xsl:call-template name="footer-copyright"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="footer-copyright">
        <div class="sub__footer__copyright">
            <i18n:text i18n:key="SKIN_FOOTER_COPYRIGHT" i18n:catalogue="skin.{$skin}"/>
        </div>
    </xsl:template>
    
    <xsl:template name="footer-partners">
        <xsl:if test="/cms/inputData/linkDirectory[@id='partners']/links/link[not(@disabled)]">
             <div class="sub__footer__partners">
                <ul>
                    <xsl:apply-templates select="/cms/inputData/linkDirectory[@id='partners']/links/link[not(@disabled)]" mode="partner"/>
                </ul>
             </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="link" mode="partner">
        <li>
            <xsl:choose>
                <xsl:when test="@urlType = 'PAGE'">
                    <a href="{resolver:resolve('page', @url)}">
                        <xsl:apply-templates select="." mode="partner-logo"/>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                   <a href="{@url}" target="_blank">
                        <xsl:apply-templates select="." mode="partner-logo"/>
                   </a> 
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>
    
    <xsl:template match="link" mode="partner-logo">
        <xsl:choose>
            <xsl:when test="@pictureType = ''">
                <!-- No picture -->
                <span class="sub__footer__partners__title"><xsl:value-of select="@title"/></span>
            </xsl:when>
            <xsl:when test="@pictureType = 'glyph'">
                <span class="picture link-glyph {@pictureGlyph}" role="img">
                    <xsl:attribute name="aria-label">
                        <xsl:choose>
                            <xsl:when test="@pictureAlternative != ''"><xsl:value-of select="@pictureAlternative"/></xsl:when>
                            <xsl:otherwise><xsl:value-of select="@title"/></xsl:otherwise>
                        </xsl:choose>        
                    </xsl:attribute>
                </span>
            </xsl:when>
            <xsl:otherwise>
                 <xsl:variable name="imgId">
                    <xsl:choose>
                        <xsl:when test="@pictureType = 'resource'">
                            <xsl:value-of select="@pictureId" />
                        </xsl:when>
                        <xsl:when test="@pictureType = 'external'">
                            <xsl:value-of select="concat(@picturePath, '?objectId=', @id)" />
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <img src="{resolver:resolveBoundedImage(@imageType, $imgId, 0, 0)}">
                    <xsl:attribute name="alt">
                        <xsl:choose>
                            <xsl:when test="@pictureAlternative != ''"><xsl:value-of select="@pictureAlternative"/></xsl:when>
                            <xsl:otherwise><xsl:value-of select="@title"/></xsl:otherwise>
                        </xsl:choose>        
                    </xsl:attribute>
                </img>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>