<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            exclude-result-prefixes="sitemap resolver ametys i18n">

    <xsl:import href="skin://stylesheets/menus.xsl" />
    
    <!-- +
         | Name of global search text field :
         | * use "user.input.criterion.common$wording$textfield$1" if global search service if configured with "Full text" criteria (in first place)
         | * use "user.input.criterion.common$titleorwording$textfield$1" if global search service if configured with "Title or full text" criteria (in first place)
         + -->
    <xsl:variable name="searchInputName">user.input.criterion.common$titleorwording$textfield$1</xsl:variable>
    
    <xsl:variable name="mainSearchPage" select="ametys:findPagesIdsByTag('SEARCH_ODF')"/>
    <xsl:variable name="mainSearchPageUri">
        <xsl:if test="$mainSearchPage"><xsl:value-of select="resolver:resolve('page', mainSearchPage/@id)"/></xsl:if>
    </xsl:variable> 
    <xsl:variable name="odfSearchPage" select="ametys:findPagesIdsByTag('SEARCH_ODF')"/>
    <xsl:variable name="odfSearchPageUri">
        <xsl:if test="$odfSearchPage"><xsl:value-of select="resolver:resolve('page', odfSearchPage/@id)"/></xsl:if>
    </xsl:variable> 
    
    <xsl:template name="header">
        <header class="header" role="banner">
            <xsl:call-template name="top-bar"/>
            <xsl:call-template name="main-menu"/>
            <xsl:call-template name="mobile-menu"/>
        </header>
    </xsl:template>
    
    <xsl:template name="top-bar">
        <div class="top-bar">
            <div class="container">
                <xsl:call-template name="top-links" />
                <xsl:call-template name="top-search-form" />
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="top-links">
        <xsl:if test="/cms/inputData/linkDirectory[@id='topLinks']/links/link[not(@disabled)]">
            <nav class="top-links" aria-label="skin.{$skin}:SKIN_TOP_LINKS_ARIA_LABEL" i18n:attr="aria-label">
                <details class="top-links__dropdown">
                    <summary class="top-links__go">
                        <i18n:text i18n:key="SKIN_TOP_LINKS_MOBILE_MENU" i18n:catalogue="skin.{$skin}"/>
                        <svg width="12" height="7" viewBox="0 0 12 7" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
                            <path d="M6 6.5L12 1.7L10.5 0.5L6 4.1L1.5 0.5L0 1.7L5.25 5.9L6 6.5Z" fill="#2E1E3D"></path>
                        </svg>
                    </summary>
        
                    <ul class="top-links__list">
                        <xsl:apply-templates select="/cms/inputData/linkDirectory[@id='topLinks']/links/link[not(@disabled)]" mode="top-link" />
                    </ul>
                </details>
            </nav>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="top-search-form">
        <xsl:if test="$mainSearchPageUri">
            <div class="search">
                <form class="search__form" role="search" action="{$mainSearchPageUri}" aria-label="skin.{$skin}:SKIN_SEARCH_FORM_LABEL" i18n:attr="aria-label" method="POST">
                    <label class="sr-only" for="site-search"><i18n:text i18n:key="SKIN_SEARCH_INPUT_LABEL" i18n:catalogue="skin.{$skin}"/></label>
                    
                    <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
                        <path d="M5.0603 0C7.85491 0.000134 10.1199 2.2659 10.1199 5.06055C10.1198 6.19707 9.74565 7.24613 9.11304 8.09082L10.1326 9.11035C10.6138 8.98063 11.1484 9.10372 11.5291 9.48438L13.5759 11.5312C14.1397 12.0954 14.1434 13.0068 13.575 13.5752C13.0104 14.1397 12.0991 14.1439 11.531 13.5762L9.48413 11.5293C9.10536 11.1505 8.97989 10.6148 9.11011 10.1318L8.09058 9.11328C7.24588 9.7459 6.19682 10.1201 5.0603 10.1201C2.26566 10.1201 -0.000110138 7.85516 -0.000244141 5.06055C-0.000244141 2.26582 2.26558 0 5.0603 0ZM5.0603 1.44531C3.06415 1.44531 1.44618 3.06345 1.44604 5.05957C1.44604 7.0558 3.06407 8.67383 5.0603 8.67383C7.05642 8.67369 8.67456 7.05572 8.67456 5.05957C8.67443 3.06353 7.05634 1.44545 5.0603 1.44531Z" fill="white"></path>
                    </svg>
    
                    <input class="search__input" id="site-search" name="{$searchInputName}" type="search" placeholder="skin.{$skin}:SKIN_SEARCH_INPUT_PLACEHOLDER" i18n:attr="placeholder" enterkeyhint="search" autocomplete="search" spellcheck="false"/>
                    <button class="search__btn" type="submit"><i18n:text i18n:key="SKIN_SEARCH_SUBMIT" i18n:catalogue="skin.{$skin}"/></button>
                </form>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="link" mode="top-link">
        <li>
            <xsl:choose>
                <xsl:when test="@urlType = 'PAGE'">
                    <a href="{resolver:resolve('page', @url)}">
                        <xsl:apply-templates select="." mode="top-link-icon"/>
                        <xsl:value-of select="@title"/>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                   <a href="{@url}" target="_blank">
                        <xsl:apply-templates select="." mode="top-link-icon"/>
                        <xsl:value-of select="@title"/>
                   </a> 
                </xsl:otherwise>
            </xsl:choose>
        </li>
   </xsl:template>
   
   <xsl:template match="link" mode="top-link-icon">
        <xsl:choose>
            <xsl:when test="@pictureType = 'glyph'">
                <span class="picture link-glyph {@pictureGlyph}"></span>
            </xsl:when>
            <xsl:otherwise>
                 <xsl:variable name="imgId">
                    <xsl:choose>
                        <xsl:when test="@pictureType = 'resource'">
                            <xsl:value-of select="@pictureId" />
                        </xsl:when>
                        <xsl:when test="@pictureType = 'external'">
                            <xsl:value-of select="concat(@picturePath, '?objectId=', @id)" />
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <img data-svg="true" src="{resolver:resolveBoundedImage(@imageType, $imgId, 0, 0)}" alt=""/>
            </xsl:otherwise>
        </xsl:choose>
   </xsl:template>
    
</xsl:stylesheet>