<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            exclude-result-prefixes="sitemap resolver ametys i18n">

    <xsl:template name="main-menu">
        <div class="main-bar" id="main-menu">
            <div class="container">
                <div class="main-bar__sub-container">
                    <xsl:call-template name="main-menu-logo"/>   
                    <xsl:call-template name="main-menu-nav"></xsl:call-template>     
                </div>
                
                <xsl:call-template name="mobile-menu-burger"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="main-menu-logo">
        <xsl:variable name="i18nparams"><title><xsl:value-of select="ametys:siteParameter('title')"/></title></xsl:variable> 
        <xsl:variable name="i18nkey" select="concat('skin.', $skin, ':SKIN_LOGO_ALT')"/>
        <xsl:variable name="logo-title">
            <xsl:value-of select="ametys:translate($i18nkey, $lang, $i18nparams)"/>
        </xsl:variable>
        
        <div class="main-bar__logo">
            <a href="{$site-uri-prefix}/{$lang}/index.html" title="{$logo-title}">
                <xsl:call-template name="main-menu-logo-img"/>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template name="main-menu-logo-img">
        <img src="{ametys:skinURL('templates/common/img/image/logo-colorful.svg')}" alt="" width="160" height="40"/>
    </xsl:template>
    
    <xsl:template name="main-menu-nav">
        <nav class="main-bar__nav" role="navigation" aria-label="skin.{$skin}:SKIN_NAV_MAIN_NAVIGATION" i18n:attr="aria-label">
            <div class="main-bar__nav-links">
                <ul class="main-bar__nav-links__list">
                    <xsl:apply-templates select="$sitemap/page[@PLUGIN_TAGS_SECTION and @sitemap:name != 'index' and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]" mode="menu-item-level1"/>
                </ul>
            </div>
        </nav>
    </xsl:template>
    
    <xsl:template match="page" mode="menu-item-level1">
        <li class="main-bar__nav-links__list__item">
            <xsl:choose>
                <xsl:when test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
                    <xsl:attribute name="class">has-submenu main-bar__nav-links__list__item</xsl:attribute>
                    <!-- Main section with submenu -->
                    <button type="button" class="menubtn" aria-expanded="false" aria-label="{@sitemap:title}" aria-controls="sm-formations-{generate-id()}">
                        <xsl:value-of select="@sitemap:title" />
                        <svg width="12" height="7" viewBox="0 0 12 7" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
                            <path d="M6 6.5L12 1.7L10.5 0.5L6 4.1L1.5 0.5L0 1.7L5.25 5.9L6 6.5Z" fill="#2E1E3D"></path>
                        </svg>
                    </button>
                    
                    <div id="sm-formations-{generate-id()}" class="submenu" hidden="true">
                        <div class="container">
                             <xsl:call-template name="mobile-menu-return"/>
                             <xsl:call-template name="mobile-menu-close" />
                             <xsl:apply-templates select="." mode="menu-item-level1-title"/>
                             
                             <div class="submenu__nav">
                                <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="menu-item-level2"/>
                             </div>
                        </div>
                    </div>
                </xsl:when>
                <xsl:otherwise>
                    <!-- Main section with no submenu -->
                    <a href="{resolver:resolve('page', @sitemap:id)}" class="menubtn">
                        <xsl:if test="@sitemap:in-path = 'true'">
                            <xsl:attribute name="class">menubtn active</xsl:attribute>
                            <xsl:attribute name="title">skin.<xsl:value-of select="$skin"/>:SKIN_MENU_ACTIVE</xsl:attribute>
                            <xsl:attribute name="i18n:attr">title</xsl:attribute>
                        </xsl:if>
                        <xsl:value-of select="@sitemap:title" />
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>
    
    <xsl:template match="page" mode="menu-item-level1-title">
        <a href="{resolver:resolve('page', @sitemap:id)}" class="submenu__title">
            <xsl:value-of select="@sitemap:title"/>
        </a>
    </xsl:template>
    
    <xsl:template match="page" mode="menu-item-level2">
        <ul class="submenu__list">
            <li class="submenu__list__subtitle">
                <div>
                    <a href="{resolver:resolve('page', @sitemap:id)}">
                        <xsl:call-template name="menu-item-level2-icon"/>
                        <xsl:value-of select="@sitemap:title" />
                    </a>
                    <xsl:if test="page[(not(@sitemap:invisible) or @sitemap:invisible = 'false')]">
                        <button aria-label="{@sitemap:title}" aria-expanded="false" class="open-submenu-mobile" aria-controls="sm-submenu-{generate-id()}">
                        </button>
                    </xsl:if>
                </div>
                
                <xsl:if test="page[(not(@sitemap:invisible) or @sitemap:invisible = 'false')]">
                    <div id="sm-submenu-{generate-id()}" class="subsubmenu">
                        <xsl:call-template name="mobile-menu-return"/>
                        <xsl:call-template name="mobile-menu-close"/>
                        <xsl:call-template name="mobile-menu-title"/>
                        <ul>
                            <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="menu-item-level3"/>
                        </ul>
                    </div>
                </xsl:if>
            </li>
        </ul>
    </xsl:template>
    
    <xsl:template name="menu-item-level2-icon">
        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
            <path d="M20 7.52632C15.8421 7.52632 12.4737 4.15789 12.4737 0H10H7.52632C7.52632 4.15789 4.15789 7.52632 0 7.52632V10V12.4737C4.15789 12.4737 7.52632 15.8421 7.52632 20H10H12.4737C12.4737 15.8421 15.8421 12.4737 20 12.4737V10V7.52632Z" fill="#521C7E"></path>
        </svg>
    </xsl:template>
    
    <xsl:template match="page" mode="menu-item-level3">
        <li class="submenu__list__item">
            <a href="{resolver:resolve('page', @sitemap:id)}">
                <xsl:value-of select="@sitemap:title" />
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="mobile-menu-burger">
        <nav class="main-bar__hamburger" id="main-menu" aria-label="skin.{$skin}:SKIN_NAV_MAIN_NAVIGATION" i18n:attr="aria-label" role="navigation">
            <button class="hamburger" type="button" aria-label="skin.{$skin}:SKIN_OPEN_MENU" i18n:attr="aria-label" aria-expanded="false" aria-haspopup="dialog">
                <svg width="30" height="20" viewBox="0 0 30 20" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
                    <rect width="30" height="2" fill="#521C7E"></rect>
                    <rect y="9" width="30" height="2" fill="#521C7E"></rect>
                    <rect y="18" width="30" height="2" fill="#521C7E"></rect>
                </svg>
            </button>
      </nav>
    </xsl:template>
    
    <xsl:template name="mobile-menu">
        <div class="mobile-menu" data-enhanced="false" aria-modal="true" role="dialog" aria-label="skin.{$skin}:SKIN_MAIN_MENU_MOBILE_LABEL" i18n:attr="aria-label">
            <div class="container">
                <div class="mobile-menu__top">
                    <xsl:call-template name="mobile-menu-logo" />
                    <xsl:call-template name="mobile-menu-close" />
                </div>
                <div class="mobile-menu__content">
                    <!-- Main menu will be copied here -->
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="mobile-menu-title">
        <a class="mobile-menu__title" href="{resolver:resolve('page', @sitemap:id)}">
            <xsl:call-template name="menu-item-level2-icon"/>
            <xsl:value-of select="@sitemap:title" />
        </a>
    </xsl:template>
    <xsl:template name="mobile-menu-return">
        <button class="mobile-menu__return" type="button" aria-label="skin.{$skin}:SKIN_MENU_MOBILE_BACK" i18n:attr="aria-label" data-bound="true">
            <svg width="19" height="16" viewBox="0 0 19 16" fill="none" xmlns="http://www.w3.org/2000/svg" focusable="false" aria-hidden="true">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M5.05541 9.28884L10.0639 14.1773L8.19644 16L0 7.99999L8.19644 -1.90735e-06L10.0639 1.8227L5.05541 6.71115L19 6.71115V9.28884L5.05541 9.28884Z" fill="#521C7E"></path>
            </svg>
        </button>
    </xsl:template>
    
    <xsl:template name="mobile-menu-logo">
        <xsl:variable name="i18nparams"><title><xsl:value-of select="ametys:siteParameter('title')"/></title></xsl:variable> 
        <xsl:variable name="i18nkey" select="concat('skin.', $skin, ':SKIN_LOGO_ALT')"/>
        <xsl:variable name="logo-title">
            <xsl:value-of select="ametys:translate($i18nkey, $lang, $i18nparams)"/>
        </xsl:variable>
        
        <a href="{$site-uri-prefix}/{$lang}/index.html" class="mobile-menu__logo" title="{$logo-title}">
            <xsl:call-template name="mobile-menu-logo-img"/>
        </a>
    </xsl:template>
    
    <xsl:template name="mobile-menu-logo-img">
        <xsl:call-template name="main-menu-logo-img"/>
    </xsl:template>
    
    <xsl:template name="mobile-menu-close">
        <button class="mobile-menu__close" type="button" aria-label="skin.{$skin}:SKIN_CLOSE_MENU" i18n:attr="aria-label" >
            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" focusable="false" aria-hidden="true">
                <path d="M8 6.54545L14.5455 0L16 1.45455L9.45455 8L16 14.5455L14.5455 16L8 9.45455L1.45455 16L0 14.5455L6.54545 8L0 1.45455L1.45455 0L8 6.54545Z" fill="#521C7E"></path>
            </svg>
         </button>
    </xsl:template>
    
</xsl:stylesheet>