<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys resolver odf">

	<xsl:import href="skin://stylesheets/main.xsl" />
    
    <xsl:template name="additionnal-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/page_home.css')}" />
    </xsl:template>
    
    <xsl:template name="additionnal-script">
    </xsl:template>
    
    <xsl:template name="main-content">
        <zone name="search" level="1"/>
        
        <zone name="top" level="2"/>
        
        <div class="with-bg">
            <zone name="default" level="1"/>
        </div>
        
        <zone name="middle" level="2"/>
        
        <div class="with-bg">
            <zone name="middle-with-bg" level="2"/>
        </div>
        
        <zone name="bottom" level="2"/>
        
        <xsl:call-template name="bottom-links"/>
    </xsl:template>
    
    <xsl:template name="bottom-links">
        <xsl:param name="column1-pages" select="/cms/inputData/sitemap//page[@PLUGIN_TAGS_HOME_BOTTOM_LINKS_STUDY]"/>
        <xsl:param name="column1-title"><i18n:text i18n:key="SKIN_HOME_BOTTOM_LINK_STUDY" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <xsl:param name="column2-pages" select="/cms/inputData/sitemap//page[@PLUGIN_TAGS_HOME_BOTTOM_LINKS_GO_FURTHER]"/>
        <xsl:param name="column2-title"><i18n:text i18n:key="SKIN_HOME_BOTTOM_LINK_GO_FURTHER" i18n:catalogue="skin.{$skin}"/></xsl:param>
        
        <xsl:if test="count($column1-pages) !=  0 or count($column2-pages) != 0">
            <div class="lame-two-columns with-bg">
                <div class="container">
                    <xsl:call-template name="bottom-links-column">
                        <xsl:with-param name="pages" select="$column1-pages"/>
                        <xsl:with-param name="title" select="$column1-title"/>
                    </xsl:call-template>
                    <xsl:call-template name="bottom-links-column">
                        <xsl:with-param name="pages" select="$column2-pages"/>
                        <xsl:with-param name="title" select="$column2-title"/>
                    </xsl:call-template>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="bottom-links-column">
        <xsl:param name="pages"/>
        <xsl:param name="title"/>
        
        <xsl:if test="count($pages) &gt; 0">
            <div class="link-list__nav">
                <h2 class="service-title"><xsl:copy-of select="$title"/></h2>
                <ul class="link-list__list">
                    <xsl:apply-templates select="$pages" mode="bottom-links-item"/>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="page" mode="bottom-links-item">
        <li>
            <a href="{resolver:resolve('page', @sitemap:id)}"><xsl:value-of select="@sitemap:title"/></a>
        </li>
    </xsl:template>
</xsl:stylesheet>