<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys resolver">

	<xsl:import href="skin://stylesheets/main.xsl" />
    <xsl:import href="skin://stylesheets/dates.xsl" />
    
    <xsl:variable name="firstZoneItem" select="/cms/page/pageContents/zone[@name='default']/zoneItem[1]"/>
    <xsl:variable name="mainContent" select="$firstZoneItem[information/type = 'CONTENT']"/>
    <xsl:variable name="mainImgPath" select="$mainContent/html/head/meta[@name = 'illustration/image;path']/@content"/>
    <xsl:variable name="mainImgType" select="$mainContent/html/head/meta[@name = 'illustration/image;type']/@content"/>
    
    <xsl:template name="additionnal-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/page_interieur.css')}" />
    </xsl:template>
    
    <xsl:template name="main-content">
        <xsl:call-template name="breadcrumb"/>
        
        <xsl:call-template name="hero"/>
        
        <div class="container">
            <zone name="default" level="1"/>
        </div>
    </xsl:template>
    
    <xsl:template name="hero">
        <div class="hero-interieur">
            <div class="container">
                <div class="hero-interieur__content">
                    <xsl:call-template name="main-content-date"/>
                    <xsl:call-template name="main-content-title"/>
                    <xsl:call-template name="main-content-subtitle"/>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="main-content-date">
        <xsl:variable name="startDate" select="$mainContent/html/head/meta[@name = 'start-date']/@content"/>
        <xsl:variable name="endDate" select="$mainContent/html/head/meta[@name = 'end-date']/@content"/>
        <xsl:if test="$startDate != '' or $endDate != ''">
            <div class="hero-interieur__date">
                <xsl:call-template name="dates">
                    <xsl:with-param name="startDate" select="$startDate"/>
                    <xsl:with-param name="endDate" select="$endDate"/>
                </xsl:call-template>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="main-content-title">
        <h1 class="hero-interieur__title">
            <xsl:value-of select="$firstZoneItem/html/head/title"/>
        </h1>
    </xsl:template>
    
    <xsl:template name="main-content-subtitle">
        <xsl:variable name="subtitle" select="$mainContent/html/head/meta[@name = 'document-subtitle']/@content"/>

        <xsl:if test="$subtitle != ''">
            <p class="hero-interieur__description">
                <xsl:value-of select="$subtitle"/>
            </p>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>