/**
 * Scroll to wrapper.
 *
 * @author Htmlstream
 * @version 1.0
 *
 */
;(function ($) {
	'use strict';
	
	$.HSCore.components.HSScrollTo = {
		/**
		 *
		 *
		 * @var Object _baseConfig
		 */
		_baseConfig: {
			eventName: 'click',
			header: 'header',
			target: null,
			mobileOnly: false,
			speed: 400
		},
		
		/**
		 *
		 *
		 * @var jQuery pageCollection
		 */
		pageCollection: $(),
		
		/**
		 * Initialization of Scroll to wrapper.
		 *
		 * @param String selector (optional)
		 * @param Object config (optional)
		 *
		 * @return jQuery pageCollection - collection of initialized items.
		 */
		
		init: function (selector, config) {
			
			this.collection = selector && $(selector).length ? $(selector) : $();
			if (!$(selector).length) return;
			
			this.config = config && $.isPlainObject(config) ?
				$.extend({}, this._baseConfig, config) : this._baseConfig;
			
			this.config.itemSelector = selector;
			
			this.initScrollTo();
			
			return this.pageCollection;
			
		},
		
		initScrollTo: function () {
			//Variables
			var $self = this,
				config = $self.config,
				collection = $self.pageCollection;
			
			//Actions
			this.collection.each(function (i, el) {
				//Variables
				var $this = $(el);
				
				function __scroll() {
					$self._scroll(config);
				}
				
				if (config.target) {
					if (config.mobileOnly) {
						$(window).on('resize', function () {
							if (window.innerWidth < 768) {
								$this[0].addEventListener(config.eventName, __scroll);
							} else {
								$this[0].removeEventListener(config.eventName, __scroll);
							}
						}).trigger('resize');
					} else {
						$this[0].addEventListener(config.eventName, __scroll);
					}
				}
				
				//Actions
				collection = collection.add($this);
			});
		},
		
		_scroll: function (config) {
			$('html, body').animate({
				scrollTop: $(config.target).offset().top - $(config.header).outerHeight() - 10
			}, config.speed);
		}
	};
})(jQuery);
