<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:math="http://exslt.org/math"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                extension-element-prefixes="exslt">
    
    <xsl:import href="plugin:odf-web://pages/services/program-list/program-list_1.3.xsl"/>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/courses-list/scss/main.css')}"/>
        <link rel="stylesheet" href="{ametys:skinURL('zones/courses-list/scss/print.css')}"/>
    </xsl:template>
    
    <xsl:template name="programs-list-one-level">
        <xsl:variable name="program-refs-rtf">
            <xsl:for-each select="/xml/programs/program[metadata[@path = $firstLevel]/value != '']">
                <xsl:variable name="refid" select="generate-id()" />
                
                <xsl:for-each select="metadata[@path = $firstLevel]/value">
                    <xsl:if test=". != ''">
                        <first value="{.}">
                            <program-ref refid="{$refid}" />
                        </first>
                    </xsl:if>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="program-refs" select="exslt:node-set($program-refs-rtf)" />
        
        <xsl:variable name="firstLevelItems" select="/xml/items[@metadataPath = $firstLevel]/item" />
        
        <xsl:variable name="accordionId" select="concat('accordion-', $firstLevel)"/>
        <xsl:if test="$firstLevelItems[1]">
            <div id="{$accordionId}" class="u-accordion u-accordion-color-primary u-accordion-brd-primary ametys-accordion-first" role="tablist" aria-multiselectable="true">
                <xsl:apply-templates select="$firstLevelItems" mode="first-level">
                    <xsl:with-param name="levelName" select="$firstLevel"/>
                    <xsl:with-param name="parentId" select="$accordionId"/>
                    <xsl:with-param name="program-refs" select="$program-refs"/>
                </xsl:apply-templates>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="programs-list-two-levels">
        <!-- Program refs node set-->
        <xsl:variable name="program-refs-rtf">
            <xsl:for-each select="/xml/programs/program[metadata[@path = $firstLevel]/value != '' and metadata[@path = $secondLevel]/value != '']">
                <xsl:variable name="refid" select="generate-id()" />
                
                <xsl:for-each select="metadata[@path = $firstLevel]/value">
                    <xsl:if test=". != ''">
                        <first value="{.}">
                            <xsl:for-each select="../../metadata[@path = $secondLevel]/value">
                                <second value="{.}">
                                    <program-ref refid="{$refid}" />
                                </second>
                            </xsl:for-each>
                        </first>
                    </xsl:if>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="program-refs" select="exslt:node-set($program-refs-rtf)" />
        
        <xsl:variable name="firstLevelItems" select="/xml/items[@metadataPath = $firstLevel]/item" />
        <xsl:variable name="secondLevelItems" select="/xml/items[@metadataPath = $secondLevel]/item" />
    
        <xsl:variable name="accordionId" select="concat('accordion-', $firstLevel)"/>
        
        <xsl:if test="$firstLevelItems[1] and $secondLevelItems[1]">
            <div id="{$accordionId}" class="u-accordion u-accordion-color-primary u-accordion-brd-primary ametys-accordion-first" role="tablist" aria-multiselectable="true">
                <xsl:apply-templates select="$firstLevelItems" mode="first-level">
                    <xsl:with-param name="levelName" select="$firstLevel"/>
                    <xsl:with-param name="parentId" select="$accordionId"/>
                    <xsl:with-param name="program-refs" select="$program-refs"/>
                    <xsl:with-param name="secondLevelItems" select="$secondLevelItems"/>
                </xsl:apply-templates>
            </div>
        </xsl:if>
    </xsl:template> 
         
    <xsl:template match="item" mode="first-level">
        <xsl:param name="program-refs" select="/.." /> <!-- default value is empty node set -->
        <xsl:param name="secondLevelItems" select="/.." /> <!-- default value is empty node set -->
        <xsl:param name="levelName"/>
        <xsl:param name="parentId"/>
        
        <xsl:variable name="first" select="$program-refs/first[@value = current()/@id]"/>
        <xsl:variable name="itemId" select="concat($levelName, '-', position())"/>
        
        <xsl:choose>
            <xsl:when test="$secondLevelItems">
                <xsl:if test="$first/second/@value = $secondLevelItems/@id">
                    <!-- Card -->
                    <div class="card rounded-0 g-brd-none">
                        <xsl:call-template name="first-level-item-header">
                            <xsl:with-param name="title" select="."/>
                            <xsl:with-param name="itemId" select="$itemId"/>
                            <xsl:with-param name="parentId" select="$parentId"/>
                        </xsl:call-template>
                        
                        <xsl:call-template name="first-level-item-body">
                            <xsl:with-param name="itemId" select="$itemId"/>
                            <xsl:with-param name="program-refs" select="$program-refs"/>
                            <xsl:with-param name="secondLevelItems" select="$secondLevelItems"/>
                        </xsl:call-template>
                    </div>
                </xsl:if>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="refs" select="$first/program-ref" />
                <xsl:if test="$refs[1]">
                    <!-- Card -->
                    <div class="card rounded-0 g-brd-none">
                        <xsl:call-template name="first-level-item-header">
                            <xsl:with-param name="title" select="."/>
                            <xsl:with-param name="itemId" select="$itemId"/>
                            <xsl:with-param name="parentId" select="$parentId"/>
                        </xsl:call-template>
                        <div id="{$itemId}-body" class="collapse show" role="tabpanel" aria-labelledby="{$itemId}-heading" style="">
                            <ul class="ametys-courses-list">
                                <xsl:apply-templates select="/xml/programs/program[$refs/@refid = generate-id()]" /> 
                            </ul>
                        </div>
                    </div>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    <xsl:template name="first-level-item-header">
        <xsl:param name="itemId"/>
        <xsl:param name="parentId"/>
        <xsl:param name="title"/>
        
        <a name="{$itemId}-anchor"/>
        <div id="{$itemId}-heading" class="u-accordion__header g-pa-0" role="tab">
            <h5 class="mb-0">
                <a
                    class="d-block g-color-main g-text-underline--none--hover g-brd-bottom g-brd-gray-light-v4 g-pa-15-0"
                    href="#{$itemId}-body" data-toggle="collapse" data-parent="#{$parentId}"
                    aria-expanded="true" aria-controls="{$itemId}-body">
                    <span class="float-right u-accordion__control-icon g-ml-10">
                        <i class="fas fa-angle-right"></i>
                        <i class="fas fa-angle-down"></i>
                    </span>
                    <span class="g-valign-middle"><xsl:value-of select="$title"/></span>
                </a>
            </h5>
        </div>
    </xsl:template>
    
    <xsl:template name="first-level-item-body">
        <xsl:param name="itemId"/>
        <xsl:param name="secondLevelItems" select="/.." />
        <xsl:param name="program-refs" select="/.." />
        
        <div id="{$itemId}-body" class="collapse show" role="tabpanel"
                aria-labelledby="{$itemId}-heading" style="">
                
            <div class="u-accordion__body g-color-gray-dark-v5 g-pa-15-0">

                <xsl:variable name="first" select="$program-refs/first[@value = current()/@id]"/>
                
                <xsl:for-each select="$secondLevelItems">
                    <xsl:variable name="refs" select="$first/second[@value = current()/@id]/program-ref" />
                    
                    <xsl:if test="$refs[1]">
                        <xsl:call-template name="second-level-item">
                            <xsl:with-param name="itemId" select="concat($itemId, '-', $secondLevel, '-', position())"/>
                            <xsl:with-param name="title" select="."/>
                            <xsl:with-param name="refs" select="$refs"/>
                        </xsl:call-template>
                    </xsl:if>
                </xsl:for-each>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="second-level-item">
        <xsl:param name="itemId"/>
        <xsl:param name="title"/>
        <xsl:param name="refs"/>
        
        <div id="{$itemId}" class="u-accordion u-accordion-color-primary u-accordion-brd-primary ametys-accordion-second" role="tablist" aria-multiselectable="true">
            <xsl:call-template name="second-level-item-header">
                <xsl:with-param name="itemId" select="$itemId"></xsl:with-param>
                <xsl:with-param name="title" select="$title"/>
            </xsl:call-template>
            <xsl:call-template name="second-level-item-body">
                <xsl:with-param name="itemId" select="$itemId"></xsl:with-param>
                <xsl:with-param name="refs" select="$refs"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="second-level-item-header">
        <xsl:param name="itemId"/>
        <xsl:param name="title"/>
        
        <a name="{$itemId}-anchor"/>
        <div id="{$itemId}-heading" class="u-accordion__header g-pa-0" role="tab">
            <a class="d-block g-color-main collapsed" href="#{$itemId}-body" data-toggle="collapse" data-parent="#{$itemId}" aria-expanded="false" aria-controls="{$itemId}-body">
                <span class="float-left u-accordion__control-icon g-mr-10">
                  <i class="fa fa-angle-right"></i>
                  <i class="fa fa-angle-down"></i>
                </span>
                 <span class="g-valign-middle"><xsl:value-of select="$title"/></span>
             </a>
        </div>
    </xsl:template>
    
    <xsl:template name="second-level-item-body">
        <xsl:param name="itemId"/>
        <xsl:param name="refs"/>
        
        <div id="{$itemId}-body" class="collapse" role="tabpanel" aria-labelledby="{$itemId}-heading" style="">
            <ul class="ametys-courses-list">
                <xsl:apply-templates select="/xml/programs/program[$refs/@refid = generate-id()]" /> 
            </ul>
        </div>
    </xsl:template>
    
    <xsl:template match="program">
        <li class="ametys-courses-list__item">
            <a href="{resolver:resolve('odf', @id)}"><xsl:value-of select="@title"/></a>
            
            <xsl:if test="$displaySubProgram = 'true' and subprogram">
                <ul id="programlist-{generate-id()}" class="ametys-courses-list">
                    <xsl:apply-templates select="subprogram" /> 
                </ul>
            </xsl:if>
        </li>
    </xsl:template>
    
    <xsl:template match="subprogram">
        <li class="ametys-courses-list__item">
            <a href="{resolver:resolve('odf', @id)}">
                <xsl:value-of select="@title"/>
            </a>
        </li>
    </xsl:template>

</xsl:stylesheet>
