<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:math="http://exslt.org/math"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                xmlns:odf="org.ametys.odf.OdfXSLTHelper"
                extension-element-prefixes="resolver exslt">
    
    <xsl:import href="plugin:odf-web://pages/services/schema/schema-health_1.3.xsl"/>
    <xsl:import href="service:odf-web://pages/services/schema/schema_1.3.xsl"/>
    
    <xsl:variable name="KG" select="odf:getEntryId('odf-enumeration.Degree', 'KG')"/><!-- Capacité en Médecine  -->
    <xsl:variable name="PF" select="odf:getEntryId('odf-enumeration.Degree', 'PF')"/><!-- Masso-kinésithérapie -->
    <xsl:variable name="JF" select="odf:getEntryId('odf-enumeration.Degree', 'JF')"/><!-- Odontologie -->
    
    <!-- Note : Only 1 health studies format : health-studies displayed on desktop as well as mobile -->
    
    <xsl:template name="canvas">
    	<div class="d-none d-md-block">
			<svg version="1.1" id="Calque_3" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
				 viewBox="0 0 1134 513" style="enable-background:new 0 0 1134 513;" xml:space="preserve">
				<xsl:call-template name="background"/>
				<g transform="translate(464, 41)">
					<xsl:call-template name="general-studies"/>
				</g>
				<xsl:call-template name="health-studies"/>
				<xsl:call-template name="base"/>
			</svg>
		</div>
		<div class="d-md-none">
			<svg version="1.1" id="Calque_3" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
				 viewBox="0 0 480 513" style="enable-background:new 0 0 480 513;" xml:space="preserve">
				<xsl:call-template name="background-mobile"/>
				<xsl:call-template name="general-studies-mobile"/>
				<xsl:call-template name="base-mobile"/>
			</svg>
		</div>
		<div class="d-md-none g-mt-50">
			<svg version="1.1" id="Calque_3" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
				 viewBox="0 0 480 513" style="enable-background:new 0 0 480 513;" xml:space="preserve">
				<xsl:call-template name="background-mobile"/>
				<xsl:call-template name="health-studies"/>
				<xsl:call-template name="base-mobile"/>
			</svg>
		</div>
		<xsl:call-template name="search-forms"/>
    </xsl:template>
    
    <xsl:template name="general-studies">
    	<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_LICENCE" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-licence').submit(); return false;">
	    	<g>
				<path id="Licence_1_" class="st5" d="M0,206h338c8.3,0,15,6.7,15,15v108H0V206z"/>
				<path id="Licence_2_" class="st6" d="M0,206h338c8.3,0,15,6.7,15,15v108H0V206z"/>
				<text transform="matrix(1 0 0 1 148.8203 293)" class="st7 st1 st8">Licence</text>
			</g>
		</a>
		<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_NA" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-na').submit(); return false;">
			<g>
				<rect id="Rectangle-Copy-5" x="509" y="247" class="st5" width="161" height="82"/>
				<rect id="Rectangle-Copy-6" x="509.4" y="247" class="st9" width="161" height="82"/>
				<g>
					<text transform="matrix(1 0 0 1 541.1458 287.8898)" class="st7 st11 st12">Diplôme d’études </text>
					<text transform="matrix(1 0 0 1 516.0458 303.8898)" class="st7 st11 st12">universitaires scientifiques </text>
					<text transform="matrix(1 0 0 1 551.4458 319.8898)" class="st7 st11 st12">et techniques</text>
				</g>
				<text transform="matrix(1 0 0 1 560.4192 269.7734)" class="st7 st11 st8">DEUST</text>
			</g>
		</a>
		<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DUT" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-dut').submit(); return false;">
			<g>
				<rect id="Rectangle-Copy-5_1_" x="353" y="247" class="st5" width="157" height="82"/>
				<rect id="Rectangle-Copy-6_1_" x="353.2" y="247" class="st13" width="157" height="82"/>
				<rect x="366.2" y="285.9" class="st14" width="126" height="43"/>
				<text transform="matrix(1 0 0 1 372.9954 294.8898)" class="st7 st11 st12">Diplôme universitaire </text>
				<text transform="matrix(1 0 0 1 389.8954 310.8898)" class="st7 st11 st12">de technologie</text>
				<text transform="matrix(1 0 0 1 412.8841 274.7734)" class="st7 st11 st8">DUT</text>
			</g>
		</a>
		<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_MASTER" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-master').submit(); return false;">
			<g>
				<rect id="Rectangle-Copy" x="150" y="122" class="st5" width="152" height="84"/>
				<rect id="Rectangle-Copy-3" x="150" y="122" class="st15" width="152" height="84"/>
				<text transform="matrix(1 0 0 1 200.8203 169)" class="st7 st11 st8">Master</text>
			</g>
		</a>
		<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DI" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-di').submit(); return false;">
			<g>
				<path id="Rectangle-Copy-6_2_" class="st5" d="M0,122h135.1c8.2,0,14.9,6.7,14.9,15v111H0V122z"/>
				<path id="Rectangle-Copy-6_14_" class="st16" d="M0,122h135.1c8.2,0,14.9,6.7,14.9,15v111H0V122z"/>
				<text transform="matrix(0.9934 0 0 1 55.8545 181)" class="st7 st1 st8">Ecole </text>
				<text transform="matrix(0.9934 0 0 1 35.1992 200)" class="st7 st1 st8">d’ingénieur</text>
			</g>
		</a>
		<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DOCTORAT" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-doctorat').submit(); return false;">
			<g>
				<rect id="Rectangle-Copy-2" x="150" class="st5" width="152" height="122"/>
				<path id="Rectangle-Copy-4" class="st17" d="M150,0h136.9c8.4,0,15.1,6.7,15.1,15v107H150V0z"/>
				<text transform="matrix(1 0 0 1 194.2383 66)" class="st7 st1 st8">Doctorat</text>
			</g>
		</a>
		<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_LICENCEP" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-licencepro').submit(); return false;">
			<g>
				<path id="Rectangle-Copy-6_3_" class="st5" d="M302,206h353c8.3,0,15,6.7,15,15v26H302V206z"/>
				<path id="Rectangle-Copy-6_16_" class="st18" d="M302,206h353c8.3,0,15,6.7,15,15v26H302V206z"/>
				<text transform="matrix(1 0 0 1 395.8711 231)" class="st7 st1 st8">Licence professionnelle</text>
			</g>
		</a>
    </xsl:template>
    
    <xsl:template name="health-studies">
    	<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_PACES" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-CY').submit(); return false;">
	    	<g>
				<rect id="Rectangle-Copy-6_4_" x="34.1" y="329" class="st19" width="430" height="41"/>
				<text transform="matrix(1 0 0 1 227.5664 354)" class="st7 st1 st8">PACES</text>
			</g>
		</a>
		<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DISM" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-YJ').submit(); return false;">
			<g>
				<path id="Rectangle-Copy-6_5_" class="st5" d="M356.4,0h92.8c8.1,0,14.7,6.7,14.7,15v315H356.4V0z"/>
				<path id="Rectangle-Copy-6_11_" class="st20" d="M356.4,0h92.8c8.1,0,14.7,6.7,14.7,15v315H356.4V0z"/>
				<text transform="matrix(0.9771 0 0 1 375.498 181.0001)" class="st7 st1 st8">Médecine</text>
			</g>
		</a>
		<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DISP" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-YL').submit(); return false;">
			<g>
				<path id="Rectangle-Copy-6_6_" class="st5" d="M249,124h92.8c8.1,0,14.7,6.7,14.7,15v191H249V124z"/>
				<path id="Rectangle-Copy-6_10_" class="st21" d="M249,124h92.8c8.1,0,14.7,6.7,14.7,15v191H249V124z"/>
				<text transform="matrix(0.9771 0 0 1 265.7783 202.0001)" class="st7 st1 st8">Pharmacie</text>
			</g>
		</a>
		<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DERSO" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-JF').submit(); return false;">
			<g>
				<path id="Rectangle-Copy-6_7_" class="st5" d="M141.5,124h92.8c8.1,0,14.7,6.7,14.7,15v191H141.5V124z"/>
				<path id="Rectangle-Copy-6_13_" class="st22" d="M141.5,124h92.8c8.1,0,14.7,6.7,14.7,15v191H141.5V124z"/>
				<text transform="matrix(0.9771 0 0 1 151.689 228.0001)" class="st7 st1 st8">Odontologie</text>
			</g>
		</a>
		<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DESF" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-PE').submit(); return false;">
			<g>
				<path id="Rectangle-Copy-6_8_" class="st5" d="M34,165h92.8c8.1,0,14.7,6.7,14.7,15v150H34V165z"/>
				<path id="Rectangle-Copy-6_12_" class="st23" d="M34,165h92.8c8.1,0,14.7,6.7,14.7,15v150H34V165z"/>
				<text transform="matrix(0.9771 0 0 1 69.8267 248.0001)" class="st7 st1 st8">Sage</text>
				<text transform="matrix(0.9771 0 0 1 63.1396 268.0001)" class="st7 st1 st8">femme</text>
			</g>
		</a>
	</xsl:template>
    
    <xsl:template name="search-forms">
        <xsl:call-template name="general-studies-search-forms"/>
        <xsl:call-template name="health-studies-search-forms"/>
    </xsl:template>
    
    <xsl:template name="health-studies-search-forms">
        <xsl:call-template name="search-form">
            <xsl:with-param name="domainName">KG</xsl:with-param>
            <xsl:with-param name="domainId" select="$KG"/>
        </xsl:call-template>
        
        <xsl:call-template name="search-form">
            <xsl:with-param name="domainName">CY</xsl:with-param>
            <xsl:with-param name="domainId" select="$CY"/>
        </xsl:call-template>
        
        <xsl:call-template name="search-form">
            <xsl:with-param name="domainName">PF</xsl:with-param>
            <xsl:with-param name="domainId" select="$PF"/>
        </xsl:call-template>
        
        <xsl:call-template name="search-form">
            <xsl:with-param name="domainName">PE</xsl:with-param>
            <xsl:with-param name="domainId" select="$PE"/>
        </xsl:call-template>
        
        <xsl:call-template name="search-form">
            <xsl:with-param name="domainName">JF</xsl:with-param>
            <xsl:with-param name="domainId" select="$JF"/>
        </xsl:call-template>
        
        <xsl:call-template name="search-form">
            <xsl:with-param name="domainName">YL</xsl:with-param>
            <xsl:with-param name="domainId" select="$YL"/>
        </xsl:call-template>
        
        <xsl:call-template name="search-form">
            <xsl:with-param name="domainName">YJ</xsl:with-param>
            <xsl:with-param name="domainId" select="$YJ"/>
        </xsl:call-template>
    </xsl:template>
    
</xsl:stylesheet>