<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:xalan="http://xml.apache.org/xalan"
				xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                extension-element-prefixes="math">
                
    <xsl:import href="skin://services/odf-web/pages/services/search/search_1.2.xsl"/>

    <xsl:template name="search-content">
        <xsl:call-template name="form-result"/>
    </xsl:template>
    
    <xsl:template name="search-map"/>
    
    <xsl:template name="results-count">
        <h2 class="ametys-heading__title">
            <xsl:choose>
                <xsl:when test="not(/search/hits) or /search/hits/@total = '0'">Aucun cours</xsl:when>
                <xsl:otherwise><xsl:value-of select="/search/hits/@total"/> cours</xsl:otherwise>
            </xsl:choose>
        </h2>
    </xsl:template>
    
    <xsl:template match="hit">
        <li class="ametys-search-results__item">
            <div class="ametys-search-results__item-content">
                
                <xsl:call-template name="hit-title"/>
                <xsl:call-template name="hit-header"/>
                <xsl:call-template name="hit-excerpt"/>
                <xsl:call-template name="hit-subprograms"/>
                <!-- <xsl:call-template name="hit-actions"/> -->
            </div>
            
            <xsl:call-template name="hit-calendar"/>
        </li>
    </xsl:template>
    
    <xsl:template name="hit-header">
        <xsl:if test="content/ects">
            <ul class="ametys-degree-list">
                
                <!-- TODO qu'est-ce qu'on affiche ici ? -->
                <!-- <li class="ametys-degree-list__item">
                    <a class="ametys-degree-list__link" href="#">
                        <span class="ametys-degree-list__item-icon ametys-icon-pen-fancy"></span>
                        Arts, lettres, langues
                    </a>
                </li> -->
                
                <!-- ECTS -->
                <xsl:if test="content/ects">
                    <li class="ametys-degree-list__item">
                        <a class="ametys-degree-list__link" href="#">
                            <span class="ametys-degree-list__item-icon fas fa-bullseye"></span>
                            <xsl:value-of select="round(content/ects)"/> ECTS
                        </a>
                    </li>
                </xsl:if>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="hit-calendar">
        <xsl:if test="content/teachingTerm">
            <xsl:variable name="value" select="content/teachingTerm/@id" />
            <xsl:variable name="code" select="ametys:contentAttribute($value, 'code')" />
    
            <xsl:if test="$code = 'printemps' or $code='automne'">
                <div class="ametys-search-results__item-period">
                    <table class="ametys-period-table">
                        <caption class="ametys-period-table__caption">Période</caption>
                        <tbody>
                            <tr>
                                <td><xsl:if test="$code = 'automne'"><xsl:attribute name="class">active</xsl:attribute></xsl:if>Sept</td>
                                <td><xsl:if test="$code = 'automne'"><xsl:attribute name="class">active</xsl:attribute></xsl:if>Oct</td>
                                <td><xsl:if test="$code = 'automne'"><xsl:attribute name="class">active</xsl:attribute></xsl:if>Nov</td>
                                <td><xsl:if test="$code = 'automne'"><xsl:attribute name="class">active</xsl:attribute></xsl:if>Déc</td>
                            </tr>
                            <tr>
                                <td><xsl:if test="$code = 'automne'"><xsl:attribute name="class">active</xsl:attribute></xsl:if>Jan</td>
                                <td><xsl:if test="$code = 'automne'"><xsl:attribute name="class">active</xsl:attribute></xsl:if>Fév</td>
                                <td><xsl:if test="$code = 'printemps'"><xsl:attribute name="class">active</xsl:attribute></xsl:if>Mars</td>
                                <td><xsl:if test="$code = 'printemps'"><xsl:attribute name="class">active</xsl:attribute></xsl:if>Avril</td>
                            </tr>
                            <tr>
                                <td><xsl:if test="$code = 'printemps'"><xsl:attribute name="class">active</xsl:attribute></xsl:if>Mai</td>
                                <td><xsl:if test="$code = 'printemps'"><xsl:attribute name="class">active</xsl:attribute></xsl:if>Juin</td>
                                <td>Juil</td>
                                <td>Août</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </xsl:if>
        </xsl:if>
    </xsl:template>
        
</xsl:stylesheet>
