<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                exclude-result-prefixes="ametys resolver">
    
    <xsl:import href="plugin:odf-web://pages/services/search/search_1.2.xsl"/>
    
    <xsl:variable name="facets" select="ametys:serviceParameter('facets') = 'true'"/>
    <xsl:variable name="header" select="ametys:serviceParameter('header')/text()"/>
    
    <xsl:template name="common-service-head-js">
         <script src="{ametys:skinURL('templates/common/js/search-autocomplete.js')}"></script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title-rendering">
        <xsl:param name="title"/>
   
        <h1 class="ametys-main-banner__title"><xsl:copy-of select="$title"/></h1>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="ametys-search-form">
            
            <form action="#" method="post">
                <xsl:if test="$search-page != ''">
                    <xsl:attribute name="action"><xsl:value-of select="resolver:resolve('page', $search-page)"/></xsl:attribute>
                </xsl:if>
                
                <input name="submit-form" type="hidden">
                    <xsl:if test="/search/group-id and normalize-space(/search/group-id) != ''">
                        <xsl:attribute name="value"><xsl:value-of select="/search/group-id"/></xsl:attribute>
                    </xsl:if>
                </input>
                
                <!-- Catalog -->
                <input type="hidden" name="catalog" value="{$catalog}"/>
                
                <div class="ametys-search-form-inner">
                    
                    <xsl:call-template name="top-search-input"/>
                    
                    <div class="ametys-search-form-dropdown-wrap">
                        
                        <xsl:for-each select="/search/form/fields/metadata[enumeration]">
                            <xsl:call-template name="top-search-dropdown">
                                <xsl:with-param name="fieldLabel" select="label"/>
                                <xsl:with-param name="fieldName" select="@name"/>
                            </xsl:call-template>
                        </xsl:for-each>
                    </div>
                    
                    <xsl:call-template name="top-search-submit"/>
                </div>
            </form>
        </div>
                        
       <script>
            // Autocompletion
            $.HSCore.components.HSScrollBar.init($('#autocomplete-<xsl:value-of select="$uniqueId"/> .ametys-search-form-dropdown-content-body'));
            
            $j('#search-autocomplete-<xsl:value-of select="$uniqueId"/>').HSAmetysSearchAutocomplete({
                autocompleteServerUrl: "<xsl:value-of select="$uri-prefix"/>/plugins/odf-web/search/autocompletion",
                autocompleteSiteName: "<xsl:value-of select="$site"/>",
                autocompleteLang: "<xsl:value-of select="$lang"/>",
                autocompleteZoneItemId: "<xsl:value-of select="/search/zone-item/@id"/>",
                searchUrl: "<xsl:value-of select="resolver:resolve('page', $search-page)"/>"
            });
                          
            <xsl:for-each select="/search/form/fields/metadata[enumeration]">
                 $.HSCore.components.HSScrollBar.init($('#<xsl:value-of select="@name"/>'));
            </xsl:for-each>
       </script>
    </xsl:template>
    
    <xsl:template name="top-search-input">
        <div class="ametys-search-form__control-wrap" id="search-autocomplete-{$uniqueId}">
            <input class="ametys-search-form__control" type="text" placeholder="skin.{$skin}:SKIN_SERVICE_ODF_SEARCH_HEADER_FORM_PLACEHOLDER" i18n:attr="placeholder" data-autocomplete-target="#autocomplete-{$uniqueId}" />
            <xsl:call-template name="top-search-input-autocomplete"/>
        </div>
    </xsl:template>
    
    <xsl:template name="top-search-input-autocomplete">
        <div id="autocomplete-{$uniqueId}" class="ametys-search-form-dropdown-content" style="display: none;">
            <header
                class="ametys-search-form-dropdown-content-header ametys-search-form-dropdown-content-header--two-columns"><!-- three-columns -->

                <!-- Formations -->                
                <xsl:call-template name="top-search-autocomplete-column-header">
                    <xsl:with-param name="label"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_PROGRAMS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                    <xsl:with-param name="iconCls">ametys-icon-graduation-cap-alt</xsl:with-param>
                </xsl:call-template>
                
                <!-- Compétences -->                
                <xsl:call-template name="top-search-autocomplete-column-header">
                    <xsl:with-param name="label"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_SKILLS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                    <xsl:with-param name="iconCls">ametys-icon-clock-alt</xsl:with-param>
                </xsl:call-template>

                <!-- Etiquettes -->                
                <!-- <xsl:call-template name="top-search-autocomplete-column-header">
                    <xsl:with-param name="label"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_TAGS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                    <xsl:with-param name="iconCls">fas fa-hashtag</xsl:with-param>
                </xsl:call-template> -->
            </header>
    
            <div class="ametys-search-form-dropdown-content-body ametys-search-form--limit-height">
                <div
                    class="ametys-search-form-dropdown-content-body-inner ametys-search-form-dropdown-content-body-inner--two-columns"><!-- three-columns -->
                    
                    <!-- Formations -->             
                    <xsl:call-template name="top-search-autocomplete-column-body">
                        <xsl:with-param name="label"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_PROGRAMS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                        <xsl:with-param name="iconCls">ametys-icon-graduation-cap-alt</xsl:with-param>
                        <xsl:with-param name="data">pages</xsl:with-param>
                    </xsl:call-template>
                    
                    <!-- Compétences -->
                    <xsl:call-template name="top-search-autocomplete-column-body">
                        <xsl:with-param name="label"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_SKILLS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                        <xsl:with-param name="iconCls">ametys-icon-clock-alt</xsl:with-param>
                        <xsl:with-param name="data">skills</xsl:with-param>
                    </xsl:call-template>
                    
                    <!-- Etiquettes -->
                    <!-- <xsl:call-template name="top-search-autocomplete-column-body">
                        <xsl:with-param name="label"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_TAGS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                        <xsl:with-param name="iconCls">fas fa-hashtag</xsl:with-param>
                        <xsl:with-param name="data">tags</xsl:with-param>
                    </xsl:call-template> -->
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="top-search-autocomplete-column-header">
        <xsl:param name="label"/>
        <xsl:param name="iconCls"/>
        
        <div class="ametys-search-form-dropdown-content-header__column">
            <h3 class="ametys-search-form-dropdown-content__title">
                <span class="ametys-search-form-dropdown-content__title-icon {$iconCls}"></span>
                <xsl:copy-of select="$label"/>
            </h3>
        </div>
    </xsl:template>
    
    <xsl:template name="top-search-autocomplete-column-body">
        <xsl:param name="label"/>
        <xsl:param name="iconCls"/>
        <xsl:param name="dropdownCls"/>
        <xsl:param name="data"/>
        
        <div class="ametys-search-form-dropdown-content-body__column">
            <h3 class="ametys-search-form-dropdown-content__title d-md-none mb-2">
                <span
                    class="ametys-search-form-dropdown-content__title-icon {$iconCls}"></span>
                <xsl:copy-of select="$label"/>
            </h3>

            <ul data-autocomplete-data="{$data}"
                class="ametys-search-form-dropdown-content-list {$dropdownCls}"></ul>
        </div>
    </xsl:template>
    
    <xsl:template name="top-search-submit">
       <button class="ametys-search-form__btn">
            <span class="ametys-search-form__btn-icon ametys-icon-magnifier"></span>
            <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_HEADER_FORM_SUBMIT" i18n:catalogue="skin.{$skin}"/>
        </button>
    </xsl:template>
    
    <xsl:template name="top-search-dropdown">
        <xsl:param name="fieldLabel"/>
        <xsl:param name="fieldName"/>
        
        <div class="ametys-search-form-dropdown">
            <button id="{$fieldName}Invoker" class="ametys-search-form-dropdown__invoker" type="button" aria-controls="{$fieldName}" aria-haspopup="true" aria-expanded="false"
                    data-dropdown-event="click"
                    data-dropdown-target="#{$fieldName}"
                    data-dropdown-type="css-animation"
                    data-dropdown-duration="200"
                    data-dropdown-hide-on-scroll="false"
                    data-dropdown-animation-in="fadeIn"
                    data-dropdown-animation-out="fadeOut">
                
                <xsl:call-template name="top-search-dropdown-label">
                    <xsl:with-param name="fieldLabel" select="$fieldLabel"/>
                    <xsl:with-param name="fieldName" select="$fieldName"/>
                </xsl:call-template>
                <span class="ametys-search-form-dropdown__invoker-icon ametys-icon-angle-down"></span>
            </button>
            
            <div id="{$fieldName}" class="ametys-search-form-dropdown-content ametys-search-form--limit-height u-dropdown--hidden" aria-labelledby="{$fieldName}Invoker">
                <ul class="ametys-search-form-filter">
                    
                    <xsl:choose>
                        <xsl:when test="$facets">
                            <xsl:apply-templates select="/search/form/facets/facet[@name = $fieldName]/item" mode="facet-item">
                                <xsl:sort select="@count" order="descending"/>
                            </xsl:apply-templates>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:apply-templates select="/search/form/fields/metadata[@name = $fieldName]/enumeration/item" mode="enum-item">
                                <xsl:sort select="."/>
                            </xsl:apply-templates>
                        </xsl:otherwise>
                    </xsl:choose>
                </ul>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="top-search-dropdown-label">
        <xsl:param name="fieldLabel"/>
        <xsl:param name="fieldName"/>
        
        <xsl:choose>
            <xsl:when test="$fieldName = 'domain'">Domaine</xsl:when><!-- FIXME shorter label -->
            <xsl:otherwise><xsl:value-of select="$fieldLabel"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="item" mode="facet-item">
        <xsl:variable name="name" select="../@name"/>
        
        <li class="ametys-search-form-filter__item">
            <div class="ametys-checkbox">
                <input id="metadata-{translate($name, '/', '.')}_{position()}" name="metadata-{translate($name, '/', '.')}" class="ametys-checkbox__control" type="checkbox" value="{@value}"/>
                <label class="ametys-checkbox__label" for="metadata-{translate($name, '/', '.')}_{position()}"><xsl:value-of select="."/> (<xsl:value-of select="@count"/>)</label>
            </div>
        </li>
    </xsl:template>
    
    <xsl:template match="item" mode="enum-item">
        <xsl:variable name="name" select="../../@name"/>
        
        <li class="ametys-search-form-filter__item">
            <div class="ametys-checkbox">
                <input id="metadata-{translate($name, '/', '.')}_{position()}" name="metadata-{translate($name, '/', '.')}" class="ametys-checkbox__control" type="checkbox" value="{@value}"/>
                <label class="ametys-checkbox__label" for="metadata-{translate($name, '/', '.')}_{position()}"><xsl:value-of select="label"/></label>
            </div>
        </li>
    </xsl:template>
    
</xsl:stylesheet>
