<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">

    <xsl:import href="plugin:web://pages/services/search/search-default/results/pagination.xsl"/>
    
    <!-- +
         | Template for page navigation
         + -->
    <xsl:template name="pagination">
        <form id="reload">
           	<nav class="ametys-pagination-wrap" aria-label="Page Navigation">
                <ul class="ametys-pagination">
                    <xsl:apply-templates select="ametys:pagination(/search/pagination/@total + 0, /search/pagination/@current + 0, 0, 9, 0)" mode="search-pagination">
                        <xsl:with-param name="original-context-node" select="/"/>
                    </xsl:apply-templates>
                </ul>
            
	            <xsl:call-template name="common-utils-pagination-results">
                    <xsl:with-param name="i18nkey" select="'plugin.web:PLUGINS_WEB_SERVICE_SEARCH_VIEW_RESULTS'" />
                    <xsl:with-param name="pagination-start" select="/search/pagination/@start + 1" />
                    <xsl:with-param name="pagination-end" select="/search/pagination/@end" />
                    <xsl:with-param name="hits-total" select="/search/hits/@total" />
                </xsl:call-template>
            </nav>
        </form>
    </xsl:template>
    
    <xsl:template match="gotofirstpage" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:if test="@enabled='true'">
            <li class="ametys-pagination__item">
                <xsl:call-template name="common-utils-pagination-link">
                    <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_FIRST'" />
                    <xsl:with-param name="i18ntitle" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_FIRST_TITLE'" />
                    <xsl:with-param name="onclick">
                        <xsl:call-template name="search-js-page">
                            <xsl:with-param name="original-context-node" select="$original-context-node"/>
		                    <xsl:with-param name="page" select="."/>
		                </xsl:call-template>
                    </xsl:with-param>
                    <xsl:with-param name="class" select="'ametys-pagination__arrow ametys-pagination__arrow_first'"/>
                </xsl:call-template>                        
            </li>
        </xsl:if>    
    </xsl:template>
    <xsl:template match="gotopreviouspage" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:if test="@enabled='true'">
            <li class="ametys-pagination__item">
                <xsl:call-template name="common-utils-pagination-link">
                    <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_PRECEDE'" />        
                    <xsl:with-param name="i18ntitle" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_PRECEDE_TITLE'" />                        
                    <xsl:with-param name="onclick">
                    <xsl:call-template name="search-js-page">
                        <xsl:with-param name="original-context-node" select="$original-context-node"/>
                        <xsl:with-param name="page" select="."/>
                        
                    </xsl:call-template>
                </xsl:with-param>
                <xsl:with-param name="class" select="'ametys-pagination__arrow ametys-pagination__arrow_previous'"/>
                </xsl:call-template>                        
            </li>
        </xsl:if>
    </xsl:template>
    <xsl:template match="space" mode="search-pagination"/>
    <xsl:template match="separator" mode="search-pagination"/>
    <xsl:template match="page" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <li>
            <xsl:attribute name="class">
                <xsl:text>ametys-pagination__item</xsl:text>
                <xsl:if test=". = ../gotofirstpage"><xsl:text> first</xsl:text></xsl:if>
                <xsl:if test=". = ../gotolastpage"><xsl:text> last</xsl:text></xsl:if>
            </xsl:attribute>
            
            <xsl:call-template name="common-utils-pagination-link">
                <xsl:with-param name="text"><xsl:value-of select="."/></xsl:with-param>
                <xsl:with-param name="onclick">
                    <xsl:call-template name="search-js-page">
                        <xsl:with-param name="original-context-node" select="$original-context-node"/>
		                <xsl:with-param name="page" select="."/>
		            </xsl:call-template>
                </xsl:with-param>
            </xsl:call-template>                            
        </li>
    </xsl:template>
    <xsl:template match="current" mode="search-pagination">
        <li class="ametys-pagination__item"><span class="ametys-pagination__link active"><xsl:value-of select="."/></span></li>
    </xsl:template>
    <xsl:template match="gotonextpage" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:if test="@enabled='true'">
            <li class="ametys-pagination__item">
                <xsl:call-template name="common-utils-pagination-link">
                    <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_NEXT'" />
                    <xsl:with-param name="i18ntitle" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_NEXT_TITLE'" />
                    <xsl:with-param name="onclick">
	                    <xsl:call-template name="search-js-page">
	                        <xsl:with-param name="original-context-node" select="$original-context-node"/>
	                        <xsl:with-param name="page" select="."/>
	                        
	                    </xsl:call-template>
	                </xsl:with-param>
	                <xsl:with-param name="class" select="'ametys-pagination__arrow ametys-pagination__arrow_next'"/>
                </xsl:call-template>                                            
            </li>
        </xsl:if>
    </xsl:template>
    <xsl:template match="gotolastpage" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:if test="@enabled='true'">
            <li class="ametys-pagination__item">
                <xsl:call-template name="common-utils-pagination-link">
                    <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_LAST'" />
                    <xsl:with-param name="i18ntitle" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_LAST_TITLE'" />
                    <xsl:with-param name="onclick">
	                    <xsl:call-template name="search-js-page">
	                        <xsl:with-param name="original-context-node" select="$original-context-node"/>
	                        <xsl:with-param name="page" select="."/>
	                    </xsl:call-template>
	                </xsl:with-param>
	                <xsl:with-param name="class" select="'ametys-pagination__arrow ametys-pagination__arrow_last'"/>
                </xsl:call-template>
            </li>
        </xsl:if>    
    </xsl:template>
    
    <xsl:template name="common-utils-pagination-link">
    	<xsl:param name="class"/>
        <xsl:param name="text"/>
        <xsl:param name="i18nkey"/>
        <xsl:param name="name"/>   
        <xsl:param name="i18ntitle"/>  
        <xsl:param name="title"/>             
        <xsl:param name="id"/>        
        <xsl:param name="onclick"/>        
        <xsl:param name="disabled" select="false()"/>        
        
        <a href="javascript:void(0)" class="ametys-pagination__link" onclick="$onclick">
        	<xsl:if test="$class != ''">
        		<xsl:attribute name="class">
	            	<xsl:value-of select="$class"/>
	            </xsl:attribute>
	        </xsl:if>
            <xsl:choose>
                <!-- i18n key -->
                <xsl:when test="$i18nkey != ''">
                    <xsl:attribute name="value"><xsl:value-of select="$i18nkey"/></xsl:attribute>
                    <xsl:attribute name="i18n:attr">value</xsl:attribute>
                </xsl:when>
                <!-- text value -->
                <xsl:otherwise><xsl:attribute name="value"><xsl:value-of select="$text"/></xsl:attribute></xsl:otherwise>                
            </xsl:choose>
            <xsl:if test="$name != ''">
                <xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
            </xsl:if>
            <xsl:if test="$id != ''">
                <xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
            </xsl:if>
            <xsl:if test="$onclick">
                <xsl:attribute name="onclick"><xsl:value-of select="$onclick"/></xsl:attribute>
            </xsl:if>
            <xsl:if test="$disabled">
                <xsl:attribute name="disabled">disabled</xsl:attribute>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="$i18ntitle != ''">
                    <xsl:attribute name="title"><xsl:value-of select="$i18ntitle"/></xsl:attribute>
                    <xsl:attribute name="i18n:attr">title<xsl:if test="$i18nkey != ''"> value</xsl:if></xsl:attribute>
                </xsl:when>
                <xsl:otherwise><xsl:attribute name="title"><xsl:value-of select="$title"/></xsl:attribute></xsl:otherwise>                
            </xsl:choose>
            <xsl:choose>
            	<xsl:when test="contains($class, 'first') or contains($class, 'previous') or contains($class, 'last') or contains($class, 'next')">
            		<span class="ametys-pagination__icon" aria-hidden="true">
            			<xsl:choose>
            				<xsl:when test="contains($class, 'first')">
            					<span class="fa fa-angle-double-left"></span>
            				</xsl:when>
            				<xsl:when test="contains($class, 'previous')">
            					<span class="fa fa-angle-left"></span>
            				</xsl:when>
            				<xsl:when test="contains($class, 'last')">
            					<span class="fa fa-angle-double-right"></span>
            				</xsl:when>
            				<xsl:when test="contains($class, 'next')">
            					<span class="fa fa-angle-right"></span>
            				</xsl:when>
            			</xsl:choose>
              		</span>
            	</xsl:when>
            	<xsl:otherwise></xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="$text"/>
        </a>
    </xsl:template>
    
    <xsl:template name="common-utils-pagination-results"> 
        <xsl:param name="i18nkey" />
        <xsl:param name="pagination-start" />
        <xsl:param name="pagination-end" />
        <xsl:param name="hits-total" />
        
        <div class="ametys-pagination-counter">
            <i18n:translate>
                <i18n:text>
                    <xsl:attribute name="i18n:catalogue"><xsl:value-of select="substring-before($i18nkey,':')" /></xsl:attribute>
                    <xsl:attribute name="i18n:key"><xsl:value-of select="substring-after($i18nkey,':')" /></xsl:attribute>                    
                </i18n:text>             
                <i18n:param><xsl:value-of select="$pagination-start"/></i18n:param>
                <i18n:param><xsl:value-of select="$pagination-end"/></i18n:param>
                <i18n:param><xsl:value-of select="$hits-total"/></i18n:param>
            </i18n:translate>        
        </div>
    </xsl:template>
    
</xsl:stylesheet>
