<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        exclude-result-prefixes="ametys resolver">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    <xsl:import href="plugin:odf-web://pages/services/search-v2/hit-program.xsl"/>
    <xsl:import href="plugin:odf-web://pages/services/search-v2/hit-course.xsl"/>
    <xsl:import href="service:web://pages/services/search/search-default/criteria/criteria.xsl"/>
    
    <xsl:template name="common-service-head-css">
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/search/scss/main.css')}"/>    
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/search/scss/print.css')}"/>    
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
    	<xsl:call-template name="search-service-head-js"/>
    	<script src="{ametys:skinURL('templates/common/js/search-autocomplete.js')}"></script>
         <script src="{ametys:skinURL('templates/common/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.js')}"></script>
         <script src="{ametys:skinURL('zones/search/js/ametys-tags.js')}"></script>
         <script src="{ametys:skinURL('zones/search/js/ametys-invoker-change-text.js')}"></script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
    	<h1 class="ametys-main-banner__title"><xsl:value-of select="$header"/></h1>
        <xsl:call-template name="form-criteria"/>
        
    </xsl:template>
    
</xsl:stylesheet>