<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        exclude-result-prefixes="ametys resolver">
    
    <xsl:import href="skin://services/web/pages/services/search/search-default.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    
    <xsl:template name="autocomplete-server-url"><xsl:value-of select="$uri-prefix"/>/plugins/odf-web/search/autocompletion</xsl:template>
    
    <xsl:template match="criterion[contains(@name, 'user.input.criterion.common$wording$textfield')]|criterion[contains(@name, 'user.input.criterion.common$titleorwording$textfield')]" mode="placeholder">
        <xsl:attribute name="placeholder">skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_ODF_SEARCH_HEADER_FORM_UE_PLACEHOLDER</xsl:attribute>
        <xsl:attribute name="i18n:attr">placeholder</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="results-count">
        <h2 class="ametys-heading__title">
            <xsl:choose>
                <xsl:when test="not(hits) or hits/@total = '0'"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_COURSES_NO_RESULT" i18n:catalogue="skin.{$skin}"/></xsl:when>
                <xsl:when test="hits/@total = '1'"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_COURSES_ONE_RESULT" i18n:catalogue="skin.{$skin}"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="hits/@total"/> <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_COURSES_RESULTS" i18n:catalogue="skin.{$skin}"/></xsl:otherwise>
            </xsl:choose>
        </h2>
    </xsl:template>  
    
    <xsl:template name="textfield">
        <div class="ametys-search-form__control-wrap" id="search-autocomplete-{$uniqueId}">
            <input id="search-autocomplete-{$uniqueId}" name="{@name}" value="{/search/form/values/criterion[@name = current()/@name]}" class="ametys-search-form__control" type="text" placeholder="skin.{$skin}:SKIN_SERVICE_ODF_SEARCH_HEADER_FORM_UE_PLACEHOLDER" i18n:attr="placeholder"/>
        </div>
    </xsl:template>  
    
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.CourseSaxer']">
        <li class="ametys-search-results__item">
            <div class="ametys-search-results__item-content">
                <div class="ametys-search-results__item-body">
                    <div class="ametys-search-results__item-body-content">
                        <xsl:call-template name="hit-title"/>
                        
                        <xsl:apply-templates select="." mode="header"/>
                        
                        <xsl:apply-templates select="." mode="abstract"/>
                        
                        <xsl:call-template name="hit-actions"/>
                    </div>
                    
                    <xsl:apply-templates select="." mode="image"/>
                </div>
            </div>
        </li>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.CourseSaxer']" mode="header">
        <xsl:if test="content/ects or content/nbHours">
            <ul class="ametys-degree-list">
                <xsl:if test="content/nbHours">
                    <li class="ametys-degree-list__item">
                        <a class="ametys-degree-list__link" href="#">
                            <span class="ametys-degree-list__item-icon ametys-icon-clock"></span>
                            <xsl:variable name="nbHours"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="content/nbHours"/></xsl:call-template></xsl:variable>
                            <xsl:value-of select="$nbHours"/>h
                        </a>
                    </li>
                </xsl:if>
                <xsl:if test="content/ects">
                    <li class="ametys-degree-list__item">
                        <a class="ametys-degree-list__link" href="#">
                            <span class="ametys-degree-list__item-icon fas fa-bullseye"></span>
                            <xsl:variable name="ects"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="content/ects"/></xsl:call-template></xsl:variable>
                            <xsl:value-of select="$ects"/> <i18n:text i18n:key="PROGRAM_ECTS_UNITS" i18n:catalogue="skin.{$skin}"/>
                        </a>
                    </li>
                </xsl:if>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.CourseSaxer']" mode="abstract">
        <xsl:if test="excerpt">
            <p class="ametys-search-results__item-text">
                <xsl:value-of select="excerpt"/>
            </p>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.CourseSaxer']" mode="image">
        <xsl:if test="content/teachingTerm">
            <xsl:variable name="value" select="content/teachingTerm/@id" />
            <xsl:variable name="code" select="ametys:contentAttribute($value, 'code')" />
    
            <xsl:if test="$code = 'printemps' or $code='automne'">
                <div class="ametys-search-results__item-body-period">
                    <xsl:call-template name="period-calendar">
                        <xsl:with-param name="period" select="$code"/>
                        <xsl:with-param name="caption"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_COURSES_PERIOD" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                    </xsl:call-template>
                </div>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="search-top-mobile-map"/>
    <xsl:template name="search-map"/>
    
    <xsl:template name="top-search-autocomplete-column-header-1">
        <!-- Courses -->
        <xsl:call-template name="top-search-autocomplete-column-header">
            <xsl:with-param name="label"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_COURSES" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="iconCls">ametys-icon-graduation-cap-alt</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
     <xsl:template name="top-search-autocomplete-column-body-1">
        <!-- Courses -->             
        <xsl:call-template name="top-search-autocomplete-column-body">
            <xsl:with-param name="label"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_COURSES" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="iconCls">ametys-icon-graduation-cap-alt</xsl:with-param>
            <xsl:with-param name="data">pages</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
</xsl:stylesheet>