<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:cms="http://ametys.org/cms/3.0"
                            xmlns:docbook="http://docbook.org/ns/docbook" 
                            exclude-result-prefixes="ametys resolver cms docbook">

    <xsl:import href="plugin:web://stylesheets/content/common.xsl"/>
    
    <xsl:template name="common-content-head-css">
         <link rel="stylesheet" href="{ametys:skinURL('richtext/scss/richtext.css')}"/>
    </xsl:template>  
    
    <xsl:template name="common-content-head-js">
         <script src="{ametys:skinURL('richtext/js/ametys-richtext.js')}"></script>
    </xsl:template>     
    
    <xsl:template name="common-content-body-title-content">
        <xsl:param name="title" select="metadata/title"/>
        <xsl:param name="subtitle" select="metadata/document-subtitle"/>
        
        <!-- Image -->
        <xsl:call-template name="common-content-body-image-bigsize">
            <xsl:with-param name="maxWidth" select="'480'"/>
            <xsl:with-param name="maxHeight" select="'290'"/>
        </xsl:call-template>
        
        <h1>
            <span class="ametys-page-title"><xsl:value-of select="$title"/></span>
        </h1>
        
        <xsl:if test="$subtitle != ''">
            <h2 class="ametys-page-sub-title"><xsl:value-of select="$subtitle"/></h2>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="common-content-body-image">
        <xsl:param name="image"/>
        <xsl:param name="alternative"/>
        <xsl:param name="maxWidth"/>
        <xsl:param name="maxHeight"/>
        <xsl:param name="class"/>
        <xsl:param name="type"/>
        
        <xsl:if test="$image">
            <span class="frame floatright">
                <img alt="{$alternative}">
                    <xsl:attribute name="src">
                        <xsl:call-template name="get-image-uri">
                            <xsl:with-param name="img" select="$image"/>
                            <xsl:with-param name="height" select="$maxHeight"/>
                            <xsl:with-param name="width" select="$maxWidth"/>
                            <xsl:with-param name="isCropped" select="$type = 'cropped'"/>
                        </xsl:call-template>
                    </xsl:attribute>
                </img>
            </span>
        </xsl:if>        
    </xsl:template>  
    
    <xsl:template name="common-content-body-content-rich">
        <xsl:param name="level" select="0"/>
        <xsl:param name="content" select="metadata/content"/>

        <xsl:if test="cms:isNotRichTextEmpty($content)">
            <xsl:variable name="raw-is-title-visible">
                <xsl:call-template name="common-content-body-title-content"/>
            </xsl:variable>
            
            <xsl:variable name="truelevel">
                <xsl:choose>
                    <xsl:when test="string-length($raw-is-title-visible) &gt; 0"><xsl:value-of select="2 + number($level)"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="1 + number($level)"/></xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
                    
            <div class="ametys-richtext">
	            <xsl:apply-templates select="$content/docbook:article">
	                <xsl:with-param name="level" select="$truelevel"/>
	            </xsl:apply-templates>
            </div>
        </xsl:if>    
    </xsl:template>

                            
</xsl:stylesheet>
