<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:cms="http://ametys.org/cms/3.0"
        xmlns:docbook="http://docbook.org/ns/docbook" 
        xmlns:math="java.lang.Math"
        exclude-result-prefixes="sitemap ametys resolver odf docbook math cms">

    <xsl:import href="skin://stylesheets/content/common/zone/key-info.xsl"/>
    
    <!-- +  
         | Template for aside information
         | Display information depends on "aside" fieldset. By default display in order :
         | * testimonies
         | * key information
         | * geocode
         | * contacts
         | * partners
         + -->
    <xsl:template match="fieldset[@name='aside']" mode="display">
        <xsl:variable name="self" select="."/>
   
        <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <aside class="ametys-courses-single-two-columns-content__sidebar">
                <xsl:apply-templates select="fieldset|metadata" mode="display"/>
            </aside>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name='contacts']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value/@entryCount != '0' and $value/entry/persons">
            <section class="g-mb-55">
                <h2 class="ametys-section-title"><xsl:value-of select="label"/></h2>
                
                <ul class="ametys-persons-list">
                    <xsl:for-each select="$value/entry">
                        <xsl:variable name="role" select="role"/>
                        
                        <xsl:for-each select="persons">
                            <li class="ametys-persons-list__item">
                                <xsl:call-template name="contact">
                                    <xsl:with-param name="contact" select="."/>
                                    <xsl:with-param name="role" select="$role"/>
                                </xsl:call-template>
                            </li>
                        </xsl:for-each>
                    </xsl:for-each>
                </ul>
            </section>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="contact">
        <xsl:param name="contact"/>
        <xsl:param name="role"/>
        
        <div class="ametys-person-info ametys-person-info--horizontal">
            <xsl:call-template name="contact-avatar">
                <xsl:with-param name="contact" select="$contact"/>
            </xsl:call-template>
            
            <div class="ametys-person-info__body">
                <xsl:call-template name="contact-title">
                    <xsl:with-param name="contact" select="$contact"/>
                </xsl:call-template>
                
                <xsl:call-template name="contact-role">
                    <xsl:with-param name="role" select="$role"/>
                </xsl:call-template>
                
                <ul class="ametys-person-info-contacts">
                    
                    <xsl:call-template name="contact-info-item">
                        <xsl:with-param name="contentId" select="$contact/@id"/>
                        <xsl:with-param name="dataPath" select="'phone'"/>
                        <xsl:with-param name="iconCls" select="'ametys-icon-phone'"/>
                        <xsl:with-param name="infoType" select="'tel'"/>
                    </xsl:call-template>
                    
                    <xsl:call-template name="contact-info-item">
                        <xsl:with-param name="contentId" select="$contact/@id"/>
                        <xsl:with-param name="dataPath" select="'mail'"/>
                        <xsl:with-param name="iconCls" select="'ametys-icon-envelope'"/>
                        <xsl:with-param name="infoType" select="'mail'"/>
                    </xsl:call-template>
                </ul>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="contact-avatar">
        <xsl:param name="contact"/>
        
        <xsl:variable name="imgUri">
            <xsl:call-template name="get-image-uri-from-attribute">
                <xsl:with-param name="id" select="$contact/@id"/>
                <xsl:with-param name="attributePath" select="'avatar'"/>
                <xsl:with-param name="height" select="150"/>
                <xsl:with-param name="width" select="150"/>
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:if test="$imgUri != ''">
            <div class="ametys-person-info__avatar">
                <img src="{$imgUri}" alt="" />
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="contact-title">
        <xsl:param name="contact"/>
        
        <xsl:variable name="firstname" select="ametys:contentAttribute($contact/@id, 'givenName')"/>
        <xsl:variable name="lastname" select="ametys:contentAttribute($contact/@id, 'lastName')"/>
        
        <h2 class="ametys-person-info__title">
            <xsl:choose>
                <xsl:when test="$firstname != '' and $lastname != ''">
                    <xsl:value-of select="concat($firstname, ' ', $lastname)"/>
                </xsl:when>
                <xsl:when test="$lastname != ''">
                    <xsl:value-of select="$lastname"/>
                </xsl:when>
                <xsl:when test="$firstname != ''">
                    <xsl:value-of select="$firstname"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$contact/title"/>
                </xsl:otherwise>
            </xsl:choose>
        </h2>
    </xsl:template>
    
    <xsl:template name="contact-role">
        <xsl:param name="role"/>
        
        <xsl:if test="$role">
            <span class="ametys-person-info__role"><xsl:value-of select="$role/@title"/></span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="contact-info-item">
        <xsl:param name="contentId"/>
        <xsl:param name="dataPath"/>
        <xsl:param name="iconCls"/>
        <xsl:param name="infoType"/>
        
        <xsl:variable name="value" select="ametys:contentAttribute($contentId, $dataPath)"/>
        
        <xsl:if test="$value != ''">
            <li class="ametys-person-info-contacts__item">
                <span class="ametys-person-info-contacts__item-icon {$iconCls}"></span>
                <xsl:choose>
                    <!-- Format for mail with antispam -->
                    <xsl:when test="$infoType = 'mail'">
                        <xsl:call-template name="mail-antispam">
                            <xsl:with-param name="mail" select="$value"/>
                        </xsl:call-template>
                    </xsl:when>
                    <!-- Format to click and call -->
                    <xsl:when test="$infoType = 'tel'">
                        <a href="tel:{$value}">
                            <xsl:value-of select="$value"/>
                        </a>
                    </xsl:when>
                    <!-- Other cases -->
                    <xsl:otherwise>
                        <xsl:value-of select="$value"/>
                    </xsl:otherwise>
                </xsl:choose>
                
            </li>
        </xsl:if>
    </xsl:template>
    
    <!-- +
         | Template to display markers on a Leaflet map.
         | 'markers' parameter is mandatory, it contains the marker with latitude (@lat), longitude (@lng) and optionally a title to display in popup (@title)
         + -->
    <xsl:template name="leaflet-map">
        <xsl:param name="markers"/>
        <xsl:param name="title"><i18n:text i18n:key="PROGRAM_LOCATION" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <xsl:param name="mapId" select="concat('map-', substring-after(math:random(), '.'))"/>
        <xsl:param name="zoom">13</xsl:param>
        <xsl:param name="height">290</xsl:param>
        
        <xsl:if test="$markers/markers/marker">
            <section class="g-mb-55">
                <h2 class="ametys-section-title"><xsl:copy-of select="$title"/></h2>
                
                <div class="ametys-map" id="{$mapId}" style="height: {$height}px"></div>
                
                <script type="text/javascript">
                    var latitude = <xsl:value-of select="$markers/markers/marker/@lat"/>;
                    var longitude = <xsl:value-of select="$markers/markers/marker/@lng"/>;
                    
                    var mymap = L.map('<xsl:value-of select="$mapId"/>').setView([latitude, longitude], <xsl:value-of select="$zoom"/>);
                    
                    // Use OpenStreetMap as tile provider
                    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                        maxZoom: 19,
                        attribution: '&amp;copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
                    }).addTo(mymap);;
    
                     var latLngs = [];
                    <xsl:for-each select="$markers/markers/marker">
                        var marker = L.marker([<xsl:value-of select="@lat"/>, <xsl:value-of select="@lng"/>], {icon: new AmetysMarkers.Icon({})});
                        marker.addTo(mymap);
                        
                        <xsl:if test="@title != ''">
                            marker.bindPopup("<xsl:value-of select="@title"/>");
                        </xsl:if>
                        latLngs.push(marker.getLatLng());
                    </xsl:for-each>
                    
                      if (latLngs.length > 1)
                      {
                            // Center and zoom the map on all markers
                            var markerBounds = L.latLngBounds(latLngs);
                            mymap.fitBounds(markerBounds);
                      }
                </script>
            </section>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>