<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:docbook="http://docbook.org/ns/docbook"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:cms="http://ametys.org/cms/3.0" 
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:odf="org.ametys.odf.OdfXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:exsl="http://exslt.org/common"
    xmlns:stringutils="org.apache.commons.lang.StringUtils"
    exclude-result-prefixes="docbook"
    extension-element-prefixes="resolver cms ametys stringutils">
    
    <xsl:import href="plugin:odf://stylesheets/content/course/course2pdf-main.xsl" />
    
    <xsl:import href="skin://stylesheets/utils.xsl" />
    <xsl:import href="skin://stylesheets/fo-styling.xsl" />
    
    <xsl:import href="skin://stylesheets/content/default-content2pdf.xsl"/>
    <xsl:import href="skin://stylesheets/content/common2pdf.xsl"/>
    
    <xsl:import href="skin://stylesheets/content/course/zone/mcc2pdf.xsl"/>
    <xsl:import href="skin://stylesheets/content/course/zone/skills2pdf.xsl"/>
    
    <xsl:variable name="skin" select="ametys:skin()"/>
    
    <!-- +
         | Get the mode of structure table
         | * simple: table with UE title / Credits / Total hours
         | * full: table with UE title / Nature / CM / TD / TP / Credits
         | Note that if full mode is used, it is recommended to use 1 column layout -->
    <xsl:template name="table-structure-mode">full</xsl:template>
    
    <!-- +
         | Determines the page layout
         | * page =>  1 column layout
         | * page-2-columns => 2 columns layout
         | The 'page' layout is recommended when MCC are exported or table structure full mode is used
         + -->
    <xsl:template name="page-layout">page</xsl:template>
    
    <xsl:template match="content">
        <xsl:variable name="truelevel" select="1"/>
        
        <fo:page-sequence>
            <xsl:call-template name="master-reference-attribute"/>
            <xsl:call-template name="xsl-region-before"/>
            
            <xsl:call-template name="xsl-region-after"/>
            
            <!-- Body region -->    
            <fo:flow flow-name="xsl-region-body">
                <!-- Header -->
                <fo:block space-before="1cm" margin-top="0cm" margin-bottom="1cm" margin-left="0cm" margin-right="0cm" span="all">
                      <xsl:call-template name="header"/>
                </fo:block>
                
                <fo:block space-before="1cm"  margin-top="0cm" margin-bottom="1cm" margin-left="0cm" margin-right="0cm" span="all">
                    <!-- Benefits -->
                    <xsl:apply-templates select="/view/contentType/fieldset[@name='benefits']" mode="display"/>
                </fo:block>
                
                <fo:block>
                      <xsl:call-template name="main-body-block"/>
                      <xsl:call-template name="body">
                          <xsl:with-param name="truelevel" select="$truelevel"/>
                      </xsl:call-template>
                </fo:block>
                
                <fo:block id="theEnd" />
            </fo:flow>
        </fo:page-sequence>
    </xsl:template>
    
    <!-- 
        | Determine the page layout:
        | * page-2-columns : 2 columns layout. Recommended if MCC table and skills table are not exported
        | * page: 1 column layout. Recommended if MCC table and/or skills table are exported
        +-->
    <xsl:template name="master-reference-attribute">
        <xsl:attribute name="master-reference"><xsl:call-template name="page-layout"/></xsl:attribute>
    </xsl:template>
    
    
    <!-- // Header -->
    <xsl:template name="header">
        <fo:block xsl:use-attribute-sets="header" margin-top="-0.35cm">
            <xsl:call-template name="header-title"/>
        </fo:block>
    </xsl:template>
    <xsl:template name="header-title">
        <fo:block xsl:use-attribute-sets="header-title">
            <xsl:value-of select="metadata/title"/>
        </fo:block>
    </xsl:template>
    <xsl:attribute-set name="header"/>
    <xsl:attribute-set name="header-title"/>
    <!-- // End Header -->
    
    <!-- // Body -->
    <xsl:template name="body">
        <xsl:call-template name="body-top"/>
        
        <xsl:call-template name="body-content">
            <xsl:with-param name="truelevel" select="2"/>
        </xsl:call-template>
        
        <xsl:call-template name="body-bottom"/>
    </xsl:template>
    
    <xsl:template name="body-content">
        <xsl:param name="truelevel"/>
        
        <!-- // Key infos -->
        <xsl:apply-templates select="/view/contentType//fieldset[@name = 'key-info']" mode="display"/>
        
        <!-- // Tab fieldsets except program -->        
        <xsl:apply-templates select="/view/contentType/fieldset[@role = 'tab']" mode="display"/>
        
        <!-- // Child courses -->
        <xsl:call-template name="child-courses"/>
        
        <!-- Contacts -->
        <xsl:call-template name="contacts"/>
    </xsl:template>
    <!-- // End body -->
    
    <!-- // Key infos -->
    <xsl:template match="fieldset[@name = 'key-info']" mode="display">
        <xsl:variable name="self" select="."/>
        
        <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <fo:block xsl:use-attribute-sets="key-info-block">
                <fo:block xsl:use-attribute-sets="key-info-block-body">
                    <fo:block xsl:use-attribute-sets="key-info-block-title"><xsl:value-of select="label"/></fo:block>
                    
                    <xsl:apply-templates select="metadata" mode="key-info" />
                </fo:block>
            </fo:block>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata" mode="key-info">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        <xsl:param name="definition" select="."/>
        
        <xsl:if test="$value and ($value != '' or $value/@id)">
            <fo:block xsl:use-attribute-sets="key-info-block-content">
                <xsl:variable name="definition" select="."/>
                
                <xsl:apply-templates select="$definition" mode="icon">
                    <xsl:with-param name="value" select="$value"/>
                </xsl:apply-templates>
                <fo:inline font-weight="bold"><xsl:text> </xsl:text><xsl:value-of select="label"/>: </fo:inline>
                
                <xsl:for-each select="$value">
                    <xsl:if test="position() != 1">, </xsl:if>
                    <xsl:apply-templates select="$definition" mode="value">
                        <xsl:with-param name="value" select="."/>
                    </xsl:apply-templates>
                </xsl:for-each>
            </fo:block>
        </xsl:if>
    </xsl:template>
    
    <xsl:attribute-set name="key-info-block"/>
    <xsl:attribute-set name="key-info-block-body"/>
    <xsl:attribute-set name="key-info-block-title"/>
    <xsl:attribute-set name="key-info-block-content"/>
    
    <!-- // End Key infos -->
    
    <xsl:template match="metadata" mode="icon">
        <fo:inline xsl:use-attribute-sets="glyph-icon" font-family="FontAwesome" font-weight="bold">&#xf054;</fo:inline>
    </xsl:template>
    
    <!-- // Child courses -->
    <xsl:template name="child-courses">
        <xsl:variable name="currentProgramItem" select="/view/structure/*[@id = /view/content/@id]"/>
        <xsl:variable name="hasChildCourses" select="count($currentProgramItem/courselist) &gt; 0"/>
        
        <xsl:if test="$hasChildCourses">
            <fo:block page-break-inside="avoid">
                <fo:block xsl:use-attribute-sets="section-title">
                    <i18n:text i18n:key="COURSE_STRUCTURE_TITLE" i18n:catalogue="skin.{$skin}"/>
                </fo:block>
                
                <xsl:call-template name="child-courses-table">
                    <xsl:with-param name="currentProgramItem" select="$currentProgramItem"></xsl:with-param>
                </xsl:call-template>
            </fo:block>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="child-courses-table">
        <xsl:param name="currentProgramItem"/>
        
        <xsl:variable name="mode"><xsl:call-template name="table-structure-mode"/></xsl:variable>
    
        <xsl:choose>
            <xsl:when test="$mode = 'full'">
                <!-- Mode full (title / type / CM / TD / TP / credits)-->
                <xsl:apply-templates select="$currentProgramItem/courselist" mode="program-full"/>
            </xsl:when>
            <xsl:otherwise>
                <!-- Mode simple (title / credits / total hours) -->
                <xsl:apply-templates select="$currentProgramItem/courselist" mode="program"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- // End child courses -->
    
    <!-- // Contacts -->
    <xsl:template name="contacts">
        <xsl:if test="/view/content/metadata/contacts/@entryCount != '0'  
                or /view/content/metadata/teachingLocation
                or /view/content/metadata/campus
                or /view/content/metadata/webLinkUrl">
                
            <fo:block xsl:use-attribute-sets="fieldset-title">
                <fo:block xsl:use-attribute-sets="fieldset-title-body">
                    <i18n:text i18n:key="PDF_CONTACT_INFOS" i18n:catalogue="skin.{$skin}"/>
                </fo:block>
            </fo:block>
        
            <xsl:apply-templates select="/view/contentType//metadata[@name = 'contacts']" mode="display"/>
            <xsl:apply-templates select="/view/contentType//metadata[@name = 'teachingLocation']" mode="display"/>
            <xsl:apply-templates select="/view/contentType//metadata[@name = 'campus']" mode="display"/>
            <xsl:apply-templates select="/view/contentType//metadata[@name = 'webLinkUrl']" mode="display"/>
        </xsl:if>
    </xsl:template>
    
    <!-- // Custom display for course's web sites -->
    <xsl:template match="metadata[@name='webLinkUrl']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <fo:block page-break-inside="avoid" xsl:use-attribute-sets="websites">
                <fo:block xsl:use-attribute-sets="section-title">
                    <i18n:text i18n:key="PROGRAM_WEB_SITES" i18n:catalogue="skin.{$skin}"/>
                </fo:block>
                
                <xsl:apply-templates select="." mode="value">
                    <xsl:with-param name="value" select="$value"/>
                </xsl:apply-templates>
            </fo:block>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'webLinkUrl']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="definition" select="."/>
        
        <xsl:if test="normalize-space(/view/content/metadata/webLinkLabel) != ''">
            <fo:block xsl:use-attribute-sets="website-label">
                <xsl:value-of select="/view/content/metadata/webLinkLabel"/>
            </fo:block>
        </xsl:if>
                
        <fo:block xsl:use-attribute-sets="website-link">
            <xsl:call-template name="link-style"/>
            <fo:basic-link external-destination="{$value}">
                <xsl:apply-templates select="$definition" mode="icon"/>
                <xsl:text> </xsl:text><xsl:value-of select="$value"/>
            </fo:basic-link>
        </fo:block>
    </xsl:template>
    
    <xsl:attribute-set name="websites"/>
    <xsl:attribute-set name="website"/>
    <xsl:attribute-set name="website-label"/>
    <xsl:attribute-set name="website-link"/>
    
    <xsl:template match="metadata[@name = 'webLinkUrl']" mode="icon">
        <fo:inline xsl:use-attribute-sets="glyph-icon" font-family="FontAwesome" font-weight="bold">&#xf35d;</fo:inline>
    </xsl:template>
    <!-- // End web site -->
    
    <!-- // Course parts -->
    <xsl:template match="metadata[@name = 'courseParts']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <fo:block page-break-inside="avoid">
                <fo:block xsl:use-attribute-sets="section-title">
                    <xsl:value-of select="label"/>
                </fo:block>
                
                <fo:table table-layout="fixed" margin-top="0pt" padding="0pt">
                    <fo:table-column />
                    <fo:table-column/>
                    <fo:table-column column-width="1cm"/>
                    
                    <fo:table-body>
                        <xsl:variable name="definition" select="."/>
                        <xsl:for-each select="$value">
                            <xsl:apply-templates select="$definition" mode="value">
                                <xsl:with-param name="value" select="."/>
                            </xsl:apply-templates>
                        </xsl:for-each>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'courseParts']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="coursepart" select="/view/structure//courseparts/coursepart[@id = $value/@id]"/>
        
        <fo:table-row>
            <fo:table-cell vertical-align="middle" text-align="left" padding-bottom="2mm">
                <fo:block>
                    <xsl:value-of select="$coursepart/@title"/>
                </fo:block>
            </fo:table-cell>
             <fo:table-cell text-align="center" vertical-align="middle">
                <fo:block>
                    <xsl:value-of select="$coursepart/attributes/nature"/> 
                </fo:block>
            </fo:table-cell>
            <fo:table-cell vertical-align="middle" text-align="right">
                <fo:block>
                <xsl:if test="$coursepart/attributes/nbHours != 0">
                    <xsl:variable name="nbHours"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="$coursepart/attributes/nbHours"/></xsl:call-template></xsl:variable>
                    <xsl:value-of select="$nbHours"/>h
                </xsl:if>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    <!-- // End course part -->
    
</xsl:stylesheet>
