<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
        xmlns:cms="http://ametys.org/cms/3.0"
        xmlns:docbook="http://docbook.org/ns/docbook" 
        xmlns:exslt="http://exslt.org/common"
        exclude-result-prefixes="sitemap ametys resolver odf docbook cms exslt">
    
    <!-- Modalité de controle des connaissances-->
    
    <xsl:template match="fieldset[@name = 'mcc']" mode="display">
        <xsl:variable name="self" select="."/>
        
        <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <div class="container">
                <div class="ametys-richtext">
                    <h2 class="ametys-section-sub-title ametys-section-sub-title--has-line g-mb-30"><xsl:value-of select="label"/></h2>
                    <xsl:apply-templates select="fieldset|metadata" mode="display"/> 
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'mccSession1' or @name = 'mccSession2']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
         
        <xsl:if test="$value/@entryCount != '0'">
            
            <!-- Filter MCC entries : ignore entries that is not part of current path -->
            <xsl:variable name="filteredEntries">
                <entries>
                    <xsl:for-each select="$value/entry">
                        <xsl:choose>
                            <xsl:when test="not(common) or common = 'true'">
                                <entry>
                                    <xsl:copy-of select="*[local-name() != 'path']" />
                                </entry>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="isPartOfCurrentPaths" select="odf:isPartOfCurrentEducationalPaths(path)"/>
                                <xsl:choose>
                                    <xsl:when test="$isPartOfCurrentPaths = 'TRUE_EXACTLY'">
                                        <!-- Ignore path -->
                                        <entry>
                                            <xsl:copy-of select="*[local-name() != 'path']" />
                                        </entry>
                                    </xsl:when>
                                    <xsl:when test="$isPartOfCurrentPaths = 'TRUE'">
                                        <!-- Copy all with path -->
                                        <entry>
                                            <xsl:copy-of select="*" />
                                        </entry>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <!-- Ignore MCC entries that is not part of current paths  -->
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:for-each>
                </entries>
            </xsl:variable>
            
            <xsl:if test="exslt:node-set($filteredEntries)/entries/entry">
                <div class="g-mb-35">
                    <h3 class="ametys-richtext-title-4"><xsl:value-of select="label"/></h3>
                
                    <xsl:variable name="definition" select="."/>
                
                    <table class="data ametys-mcc">
                        <tr>
                            <xsl:apply-templates select="metadata" mode="mcc-header"/>
                        </tr>
                        <xsl:for-each select="exslt:node-set($filteredEntries)">
                            <xsl:if test="position() != 1"><br/></xsl:if>
                            <xsl:apply-templates select="$definition" mode="value">
                                <xsl:with-param name="value" select="."/>
                            </xsl:apply-templates>
                        </xsl:for-each>
                    </table>
                </div>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'common' or @name = 'path']" mode="mcc-header">
        <!-- Do not display it -->
    </xsl:template>

    <xsl:template match="metadata" mode="mcc-header">
        <th><xsl:value-of select="label"/></th>
    </xsl:template>
    
    
    <xsl:template match="metadata[@name = 'mccSession1' or @name = 'mccSession2']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="repeaterDef" select="."/>
        
        <xsl:for-each select="$value/entries/entry">
            <xsl:sort select="common" order="descending"/> <!-- First common -->
            <xsl:sort select="path"/> <!-- Order by educational path -->
            
            <xsl:apply-templates select="." mode="mcc-row">
                <xsl:with-param name="repeaterDef" select="$repeaterDef" />
                <xsl:with-param name="showPath" select="not(preceding-sibling::entry[path = current()/path])" />
            </xsl:apply-templates>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="entry" mode="mcc-row">
        <xsl:param name="repeaterDef" />
        <xsl:param name="showPath">false</xsl:param>
        
        <xsl:if test="$showPath = 'true' and path">
            <xsl:apply-templates select="." mode="mcc-row-path">
                <xsl:with-param name="repeaterDef" select="$repeaterDef" />
            </xsl:apply-templates>
        </xsl:if>
        <tr>
            <xsl:apply-templates select="$repeaterDef/metadata" mode="mcc-value">
                <xsl:with-param name="entry" select="."/>
            </xsl:apply-templates>
        </tr>
    </xsl:template>
    
    <xsl:template match="entry" mode="mcc-row-path">
        <xsl:param name="repeaterDef" />
        
        <tr>
            <td colspan="{count($repeaterDef/metadata)}" class="educational-path">
                <xsl:value-of select="odf:getMainStructureEducationalPathAsString(path)" />
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'common' or @name = 'path']" mode="mcc-value">
        <!-- Do not display it -->
    </xsl:template>
    
    <xsl:template match="metadata" mode="mcc-value">
        <xsl:param name="entry"/>
        
        <td>
            <xsl:variable name="name" select="@name"/>
            <xsl:apply-templates select="." mode="value">
                <xsl:with-param name="value" select="$entry/*[local-name()=$name]"/>
            </xsl:apply-templates>
        </td>
    </xsl:template>
    
</xsl:stylesheet>