<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:docbook="http://docbook.org/ns/docbook" 
        xmlns:exslt="http://exslt.org/common"
        exclude-result-prefixes="sitemap ametys resolver odf escaper docbook exslt">

    <xsl:import href="skin://stylesheets/content/program/zone/structure.xsl"/>
    
    <!-- + 
         | Main template to expose the course structure. Parameters are:
         | - title: the title of this section (optional)
         | - currentProgramItem: the current program item that contains subprograms and/or years 
         + -->
    <xsl:template name="course-structure">
        <xsl:param name="title"/>
        <xsl:param name="currentProgramItem"/>
        
        <xsl:if test="$currentProgramItem/courselist[course]">
            <section>
                <h2 class="ametys-section-sub-title ametys-section-sub-title--has-line"><xsl:copy-of select="$title"/></h2>
                
                <ul id="accordion-{$currentProgramItem/@code}" class="ametys-accordion accordion mb-0">
                    <xsl:apply-templates select="$currentProgramItem/courselist" mode="course-row"/>
                </ul>
                
                <!-- Popup for courses -->
                <xsl:if test="$usePopupForCourses">
                    <xsl:call-template name="course-popups">
                        <xsl:with-param name="courses" select="$currentProgramItem//course"/>
                    </xsl:call-template>
                </xsl:if>
        
            </section>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="course" mode="course-row-header">
        <xsl:param name="parentCourseId"/>
        
        <header class="ametys-accordion__item-header">
            <xsl:if test="../../@id = /view/content/@id">
                <!-- For courses of first level only -->
                <xsl:attribute name="class">ametys-accordion__item-header ametys-accordion__item-header--top</xsl:attribute>
            </xsl:if>
            
            <xsl:if test="courselist/course">
                <a class="ametys-accordion__item-invoker collapsed" href="#" aria-expanded="false"
                   data-toggle="collapse"
                   data-target="#course-{@code}">
                    <span class="fas fa-angle-down"></span>
                </a>
            </xsl:if>
            
            <!-- Course's title -->
            <xsl:apply-templates select="." mode="course-row-title">
                <xsl:with-param name="parentCourseId" select="$parentCourseId"/>
            </xsl:apply-templates>
            <xsl:apply-templates select="." mode="course-row-ects"/><!-- Credits --> 
            <xsl:apply-templates select="." mode="course-row-hours"/><!-- Hours -->
        </header>
    </xsl:template>
    
</xsl:stylesheet>