<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
        exclude-result-prefixes="sitemap ametys">
    
    <xsl:template name="main-banner-check-admission-item">
        <li class="ametys-main-banner-alt-action-list__item">
            <a id="checkAdmissionInvoker" class="ametys-popup-invoker ametys-main-banner-alt-action-list__link" href="javascript:;"
               data-src="#checkAdmissionChances"
               data-speed="350">
                <span class="ametys-main-banner-alt-action-list__item-icon ametys-icon-check"></span>
                <span class="ametys-main-banner-alt-action-list__item-text">Êtes-vous fait pour ce programme ?</span>
            </a>
            
            <span id="checkAdmissionSuccess" class="ametys-tag ametys-tag--green" style="display: none;">Ce programme est fait pour vous !</span>
            
            <div id="checkAdmissionChances" class="ametys-popup" style="display: none; width: 500px; max-width: 95%;">
                <div class="ametys-popup-content">
                    
                    <div class="ametys-step-form">
                        
                        <div id="stepInit" class="text-center p-4" style="display: block;">
                            <h2 class="ametys-popup-content__h1">Etes vous fait(e) pour ce programme ?</h2>
                            <img class="mb-4" src="{ametys:skinURL('templates/common/img/popup/img1.png')}" alt="Image description"/>
                            <button class="ametys-popup-content__btn ametys-popup-content__btn--lg ametys-popup-content__btn--wide" type="button"
                                    data-hide-section="#stepInit"
                                    data-show-section="#steps">Démarrer
                            </button>
                        </div>
                        
                        <div id="steps" style="display: none;">
                            
                            <form action="/" type="POST">
                                
                                <ul class="ametys-step-progress">
                                    <li class="ametys-step-progress__item active"
                                        data-progress-item-for='["#steps", "#step1"]'>
                                        <span class="ametys-step-progress__item-text">1</span>
                                    </li>
                                    <li class="ametys-step-progress__item"
                                        data-progress-item-for='["#step2"]'>
                                        <span class="ametys-step-progress__item-text">2</span>
                                    </li>
                                    <li class="ametys-step-progress__item"
                                        data-progress-item-for='["#step3"]'>
                                        <span class="ametys-step-progress__item-text">3</span>
                                    </li>
                                    <li class="ametys-step-progress__item"
                                        data-progress-item-for='["#step4"]'>
                                        <span class="ametys-step-progress__item-text">4</span>
                                    </li>
                                </ul>
                                
                                <div id="stepFormSteps">
                                    
                                    <div id="step1">
                                        <h3 class="ametys-popup-content__h2 text-center">Quel est votre dernier diplôme ou diplôme en cours d’obtention ?</h3>
                                        
                                        <div class="ametys-error-container mb-5">
                                            <div class="ametys-popup-checkboxes">
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg">
                                                    <input id="baccalaureat" class="ametys-checkbox-badge__control" name="step1RadioGroup" type="radio" value="Baccalauréat" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="baccalaureat">Baccalauréat</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg">
                                                    <input id="bac_pro" class="ametys-checkbox-badge__control" name="step1RadioGroup" type="radio" value="Bac Pro" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="bac_pro">Bac Pro</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg">
                                                    <input id="bep" class="ametys-checkbox-badge__control" name="step1RadioGroup" type="radio" value="BEP" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="bep">BEP</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg">
                                                    <input id="bts" class="ametys-checkbox-badge__control" name="step1RadioGroup" type="radio" value="BTS" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="bts">BTS</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg">
                                                    <input id="cap" class="ametys-checkbox-badge__control" name="step1RadioGroup" type="radio" value="CAP" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="cap">CAP</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg">
                                                    <input id="classe_preparatoire" class="ametys-checkbox-badge__control" name="step1RadioGroup" type="radio" value="Classe préparatoire" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="classe_preparatoire">Classe préparatoire</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg">
                                                    <input id="diplome_ecole_dingenieur" class="ametys-checkbox-badge__control" name="step1RadioGroup" type="radio" value="Diplôme école d'ingénieur" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="diplome_ecole_dingenieur">Diplôme école d'ingénieur</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg">
                                                    <input id="diplome_superieur_de_comptabilite_et_gestion" class="ametys-checkbox-badge__control" name="step1RadioGroup" type="radio" value="Diplôme Supérieur de Comptabilité et Gestion" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="diplome_superieur_de_comptabilite_et_gestion">Diplôme Supérieur de Comptabilité et Gestion</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg">
                                                    <input id="diplome_superieur_du_notariat" class="ametys-checkbox-badge__control" name="step1RadioGroup" type="radio" value="Diplôme supérieur du notariat" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="diplome_superieur_du_notariat">Diplôme supérieur du notariat</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg">
                                                    <input id="dut" class="ametys-checkbox-badge__control" name="step1RadioGroup" type="radio" value="DUT" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="dut">DUT</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg">
                                                    <input id="licence" class="ametys-checkbox-badge__control" name="step1RadioGroup" type="radio" value="Licence" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="licence">Licence</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg">
                                                    <input id="licence_professionnelle" class="ametys-checkbox-badge__control" name="step1RadioGroup" type="radio" value="Licence professionnelle" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="licence_professionnelle">Licence professionnelle</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg">
                                                    <input id="magistere" class="ametys-checkbox-badge__control" name="step1RadioGroup" type="radio" value="Magistère" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="magistere">Magistère</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg">
                                                    <input id="master_of_business" class="ametys-checkbox-badge__control" name="step1RadioGroup" type="radio" value="Master of Business" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="master_of_business">Master of Business</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg">
                                                    <input id="administration" class="ametys-checkbox-badge__control" name="step1RadioGroup" type="radio" value="Administration" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="administration">Administration</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg">
                                                    <input id="master_of_science" class="ametys-checkbox-badge__control" name="step1RadioGroup" type="radio" value="Master of Science" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="master_of_science">Master of Science</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg">
                                                    <input id="mastere_specialise" class="ametys-checkbox-badge__control" name="step1RadioGroup" type="radio" value="Mastère spécialisé" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="mastere_specialise">Mastère spécialisé</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg">
                                                    <input id="autre" class="ametys-checkbox-badge__control" name="step1RadioGroup" type="radio" value="autre" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="autre">Autre</label>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="ametys-popup-content-btn-wrap">
                                            <button class="ametys-popup-content__btn" type="button"
                                                    data-hide-section="#step1"
                                                    data-show-section="#step2"
                                                    data-is-for-validating="true">Suivant
                                            </button>
                                        </div>
                                    </div>
                                    
                                    <div id="step2" style="display: none;">
                                        <h3 class="ametys-popup-content__h2 text-center">Dîtes nous en un peu plus</h3>
                                        
                                        <div class="ametys-error-container form-group mb-5">
                                            <textarea class="ametys-form-control rounded-0" rows="6" placeholder="Précisez le titre de votre formation" required="required"></textarea>
                                        </div>
                                        
                                        <div class="ametys-popup-content-btn-wrap">
                                            <button class="ametys-popup-content__btn" type="button"
                                                    data-hide-section="#step2"
                                                    data-show-section="#step1"
                                                    data-is-for-validating="false">Précédent
                                            </button>
                                            <button class="ametys-popup-content__btn" type="button"
                                                    data-hide-section="#step2"
                                                    data-show-section="#step3"
                                                    data-is-for-validating="true">Suivant
                                            </button>
                                        </div>
                                    </div>
                                    
                                    <div id="step3" style="display: none;">
                                        <h3 class="ametys-popup-content__h2 text-center">Quel est votre niveau en français ?</h3>
                                        
                                        <div class="ametys-error-container mb-5">
                                            <div class="ametys-popup-checkboxes">
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg ametys-checkbox-badge--block">
                                                    <input id="debutant" name="langGroup" class="ametys-checkbox-badge__control" type="radio" value="Débutant" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="debutant">Débutant</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg ametys-checkbox-badge--block">
                                                    <input id="courant" name="langGroup" class="ametys-checkbox-badge__control" type="radio" value="Courant" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="courant">Courant</label>
                                                </div>
                                                
                                                <div class="ametys-checkbox-badge ametys-checkbox-badge--alt ametys-checkbox-badge--lg ametys-checkbox-badge--block">
                                                    <input id="je_ne_parle_pas_cette_langue" name="langGroup" class="ametys-checkbox-badge__control" type="radio" value="Je ne parle pas cette langue" required="required"/>
                                                    <label class="ametys-checkbox-badge__label" for="je_ne_parle_pas_cette_langue">Je ne parle pas cette langue</label>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="ametys-popup-content-btn-wrap">
                                            <button class="ametys-popup-content__btn" type="button"
                                                    data-hide-section="#step3"
                                                    data-show-section="#step2"
                                                    data-is-for-validating="false">Précédent
                                            </button>
                                            <button class="ametys-popup-content__btn" type="button"
                                                    data-hide-section="#step3"
                                                    data-show-section="#step4"
                                                    data-is-for-validating="true">Suivant
                                            </button>
                                        </div>
                                    </div>
                                    
                                    <div id="step4" style="display: none;">
                                        <h3 class="ametys-popup-content__h2 text-center">Avez vous les compétences requises ?</h3>
                                        <h4 class="ametys-popup-content__h3">Sélectionnez les compétences que vous maîtrisez.</h4>
                                        
                                        <div class="ametys-error-container mb-5">
                                            <div id="step4Scrollbar" style="max-height: 315px; overflow: hidden;">
                                                <div class="form-group">
                                                    <h5 class="ametys-popup-content__h4">Champs de compétences 1</h5>
                                                    
                                                    <div class="ametys-popup-checkboxes">
                                                        <div class="ametys-checkbox-badge ametys-checkbox-badge--pilled">
                                                            <input id="collaborer_avec_le_personnel_technique_dans_des_productions" name="step4CheckboxesGroup" class="ametys-checkbox-badge__control" type="checkbox" value="Collaborer avec le personnel technique dans des productions" required="required"/>
                                                            <label class="ametys-checkbox-badge__label" for="collaborer_avec_le_personnel_technique_dans_des_productions">
                                                                <span class="ametys-checkbox-badge__label-hidden-icon fas fa-check"></span>
                                                                Collaborer avec le personnel technique dans des productions
                                                            </label>
                                                        </div>
                                                        
                                                        <div class="ametys-checkbox-badge ametys-checkbox-badge--pilled">
                                                            <input id="enseigner_les_arts_plastiques" name="step4CheckboxesGroup" class="ametys-checkbox-badge__control" type="checkbox" value="enseigner les arts plastiques" required="required"/>
                                                            <label class="ametys-checkbox-badge__label" for="enseigner_les_arts_plastiques">
                                                                <span class="ametys-checkbox-badge__label-hidden-icon fas fa-check"></span>
                                                                enseigner les arts plastiques
                                                            </label>
                                                        </div>
                                                        
                                                        <div class="ametys-checkbox-badge ametys-checkbox-badge--pilled">
                                                            <input id="processus_devaluation" name="step4CheckboxesGroup" class="ametys-checkbox-badge__control" type="checkbox" value="processus d’évaluation" required="required"/>
                                                            <label class="ametys-checkbox-badge__label" for="processus_devaluation">
                                                                <span class="ametys-checkbox-badge__label-hidden-icon fas fa-check"></span>
                                                                processus d’évaluation
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <div class="form-group mb-0">
                                                    <h5 class="ametys-popup-content__h4">Champs de compétences 2</h5>
                                                    
                                                    <div class="ametys-popup-checkboxes">
                                                        <div class="ametys-checkbox-badge ametys-checkbox-badge--pilled">
                                                            <input id="сollaborer_avec_le_personnel_technique" name="step4CheckboxesGroup" class="ametys-checkbox-badge__control" type="checkbox" value="Collaborer avec le personnel technique" required="required"/>
                                                            <label class="ametys-checkbox-badge__label" for="сollaborer_avec_le_personnel_technique">
                                                                <span class="ametys-checkbox-badge__label-hidden-icon fas fa-check"></span>
                                                                Collaborer avec le personnel technique
                                                            </label>
                                                        </div>
                                                        
                                                        <div class="ametys-checkbox-badge ametys-checkbox-badge--pilled">
                                                            <input id="enseigner_les_arts_plastiques_2" name="step4CheckboxesGroup" class="ametys-checkbox-badge__control" type="checkbox" value="enseigner les arts plastiques" required="required"/>
                                                            <label class="ametys-checkbox-badge__label" for="enseigner_les_arts_plastiques_2">
                                                                <span class="ametys-checkbox-badge__label-hidden-icon fas fa-check"></span>
                                                                enseigner les arts plastiques
                                                            </label>
                                                        </div>
                                                        
                                                        <div class="ametys-checkbox-badge ametys-checkbox-badge--pilled">
                                                            <input id="processus_devaluation_2" name="step4CheckboxesGroup" class="ametys-checkbox-badge__control" type="checkbox" value="processus d’évaluation" required="required"/>
                                                            <label class="ametys-checkbox-badge__label" for="processus_devaluation_2">
                                                                <span class="ametys-checkbox-badge__label-hidden-icon fas fa-check"></span>
                                                                processus d’évaluation
                                                            </label>
                                                        </div>
                                                        
                                                        <div class="ametys-checkbox-badge ametys-checkbox-badge--pilled">
                                                            <input id="enseigner_les_arts_plastiques_3" name="step4CheckboxesGroup" class="ametys-checkbox-badge__control" type="checkbox" value="enseigner les arts plastiques" required="required"/>
                                                            <label class="ametys-checkbox-badge__label" for="enseigner_les_arts_plastiques_3">
                                                                <span class="ametys-checkbox-badge__label-hidden-icon fas fa-check"></span>
                                                                enseigner les arts plastiques
                                                            </label>
                                                        </div>
                                                        
                                                        <div class="ametys-checkbox-badge ametys-checkbox-badge--pilled">
                                                            <input id="beaux_arts" name="step4CheckboxesGroup" class="ametys-checkbox-badge__control" type="checkbox" value="beaux arts" required="required"/>
                                                            <label class="ametys-checkbox-badge__label" for="beaux_arts">
                                                                <span class="ametys-checkbox-badge__label-hidden-icon fas fa-check"></span>
                                                                beaux arts
                                                            </label>
                                                        </div>
                                                        
                                                        <div class="ametys-checkbox-badge ametys-checkbox-badge--pilled">
                                                            <input id="сollaborer_avec_le_personnel_technique_2" name="step4CheckboxesGroup" class="ametys-checkbox-badge__control" type="checkbox" value="Collaborer avec le personnel technique" required="required"/>
                                                            <label class="ametys-checkbox-badge__label" for="сollaborer_avec_le_personnel_technique_2">
                                                                <span class="ametys-checkbox-badge__label-hidden-icon fas fa-check"></span>
                                                                Collaborer avec le personnel technique
                                                            </label>
                                                        </div>
                                                        
                                                        <div class="ametys-checkbox-badge ametys-checkbox-badge--pilled">
                                                            <input id="enseigner_les_arts_plastiques_4" name="step4CheckboxesGroup" class="ametys-checkbox-badge__control" type="checkbox" value="enseigner les arts plastiques" required="required"/>
                                                            <label class="ametys-checkbox-badge__label" for="enseigner_les_arts_plastiques_4">
                                                                <span class="ametys-checkbox-badge__label-hidden-icon fas fa-check"></span>
                                                                enseigner les arts plastiques
                                                            </label>
                                                        </div>
                                                        
                                                        <div class="ametys-checkbox-badge ametys-checkbox-badge--pilled">
                                                            <input id="processus_devaluation_3" name="step4CheckboxesGroup" class="ametys-checkbox-badge__control" type="checkbox" value="processus d’évaluation" required="required"/>
                                                            <label class="ametys-checkbox-badge__label" for="processus_devaluation_3">
                                                                <span class="ametys-checkbox-badge__label-hidden-icon fas fa-check"></span>
                                                                processus d’évaluation
                                                            </label>
                                                        </div>
                                                        
                                                        <div class="ametys-checkbox-badge ametys-checkbox-badge--pilled">
                                                            <input id="enseigner_les_arts_plastiques_5" name="step4CheckboxesGroup" class="ametys-checkbox-badge__control" type="checkbox" value="enseigner les arts plastiques" required="required"/>
                                                            <label class="ametys-checkbox-badge__label" for="enseigner_les_arts_plastiques_5">
                                                                <span class="ametys-checkbox-badge__label-hidden-icon fas fa-check"></span>
                                                                enseigner les arts plastiques
                                                            </label>
                                                        </div>
                                                        
                                                        <div class="ametys-checkbox-badge ametys-checkbox-badge--pilled">
                                                            <input id="beaux_arts_2" name="step4CheckboxesGroup" class="ametys-checkbox-badge__control" type="checkbox" value="beaux arts" required="required"/>
                                                            <label class="ametys-checkbox-badge__label" for="beaux_arts_2">
                                                                <span class="ametys-checkbox-badge__label-hidden-icon fas fa-check"></span>
                                                                beaux arts
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="ametys-popup-content-btn-wrap">
                                            <button class="ametys-popup-content__btn" type="button"
                                                    data-hide-section="#step4"
                                                    data-show-section="#step3"
                                                    data-is-for-validating="false">Précédent
                                            </button>
                                            <button class="ametys-popup-content__btn" type="submit">Terminer</button>
                                        </div>
                                    </div>
                                
                                </div>
                            
                            </form>
                        
                        </div>
                    
                    </div>
                
                </div>
            </div>
            
            <div id="checkAdmissionChancesSending" class="ametys-popup ametys-popup--primary" style="display: none; width: 500px; max-width: 95%;">
                <div class="ametys-popup-header text-center">
                    
                    <div class="g-pa-30">
                        <span class="ametys-popup-icon fas fa-sync fa-spin"></span>
                        <h2 class="ametys-popup-content__h2">Calcul en cours …</h2>
                    </div>
                
                </div>
            </div>
            
            <div id="checkAdmissionChancesSuccess" class="ametys-popup ametys-popup--success" style="display: none; width: 500px; max-width: 95%;">
                <div class="ametys-popup-header text-center">
                    
                    <div class="g-pa-20">
                        <span class="ametys-popup-icon fas fa-check"></span>
                        <h2 class="ametys-popup-content__h2">Bravo, ce programme est fait <br/> pour vous ! </h2>
                    </div>
                
                </div>
                
                <div class="ametys-popup-content text-center">
                    <p class="ametys-popup-content__p">Créez un compte pour sauvegarder vos formations favorites et postuler en quelques clics</p>
                    <p class="ametys-popup-content__p">
                        <a href="#">Créer un compte</a>
                        ou
                        <a href="#">Se connecter</a>
                    </p>
                </div>
            </div>
            
            <div id="checkAdmissionChancesError" class="ametys-popup ametys-popup--warning" style="display: none; width: 500px; max-width: 95%;">
                <div class="ametys-popup-header text-center">
                    
                    <div class="g-pa-20">
                        <span class="ametys-popup-icon fas fa-exclamation-triangle"></span>
                        <h2 class="ametys-popup-content__h2">Il vous manque certains pré requis <br/> Contactez nous
                        </h2>
                    </div>
                
                </div>
                
                <div class="ametys-popup-content text-center">
                    <p class="ametys-popup-content__p">Créez un compte pour sauvegarder vos formations favorites et postuler en quelques clics</p>
                    <p class="ametys-popup-content__p">
                        <a href="#">Créer un compte</a>
                        ou
                        <a href="#">Se connecter</a>
                    </p>
                </div>
            </div>
        </li>
    </xsl:template>
    
    <xsl:template name="main-banner-check-admission-js">
        <script>
            $j.HSCore.components.HSPopup.init('.ametys-popup-invoker', {
                touch: false,
                autoFocus: false,
                afterShow: function () {
                    $j.HSCore.components.HSValidation.init('.ametys-step-form form');
                    
                    $j.HSCore.components.HSStepForm.init('.ametys-step-form', {
                        beforeSend: function () {
                            
                            if ($j('.ametys-step-form form').valid()) {
                                
                                $j.fancybox.close($j('#checkAdmissionChances'), {
                                    animationEffect: false
                                });
                                $j.fancybox.open($j('#checkAdmissionChancesSending'), {
                                    animationEffect: false
                                });
                                
                            }
                            
                        },
                        onSuccess: function (data) {
                            
                            if ($j('.ametys-step-form form').valid()) {
                                
                                $j.fancybox.close($j('#checkAdmissionChancesSending'), {
                                    animationEffect: false
                                });
                                $j.fancybox.open($j('#checkAdmissionChancesSuccess'), {
                                    animationEffect: false
                                });
                                
                                $j('#checkAdmissionInvoker').hide();
                                $j('#checkAdmissionSuccess').show()
                                
                            }
                            
                        },
                        onError: function (data) {
                            
                            if ($j('.ametys-step-form form').valid()) {
                                
                                setTimeout(function () {
                                    
                                    $j.fancybox.close($j('#checkAdmissionChancesSending'), {
                                        animationEffect: false
                                    });
                                    $j.fancybox.open($j('#checkAdmissionChancesError'), {
                                        animationEffect: false
                                    });
                                    
                                    $j('#checkAdmissionInvoker').hide();
                                    $j('#checkAdmissionSuccess').show()
                                    
                                }, 1500);
                                
                            }
                            
                        },
                        onNextStep: function (context) {
                            
                            if (context === '#step4') {
                                
                                if ($j('#step4Scrollbar').outerHeight() >= 315) {
                                    
                                    $j.HSCore.components.HSScrollBar.init($j('#step4Scrollbar'));
                                    
                                }
                                
                            }
                            
                        }
                    });
                }
            });
        
        </script>
        
    </xsl:template>
    
</xsl:stylesheet>