<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:url="org.ametys.core.util.URIUtils"
        xmlns:filename="org.ametys.core.util.FilenameUtils"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:stringutils="org.apache.commons.lang.StringUtils"
        exclude-result-prefixes="sitemap ametys resolver odf stringutils url filename">

    <!-- +
         | Default template for the sticky widget
         | Display by default :
         | - the availables downloads 
         | - cart's items
         | - a contact form
         | - a link to subscribe
         + -->
    <xsl:template name="sticky-right-widget">
        <div class="ametys-widget ametys-widget--md ametys-widget--sticky-right g-z-index-1012">
            
            <xsl:variable name="widgetId" select="concat('widget-', generate-id())"/>
            <div id="widget-{generate-id()}">
                
                <div id="scrollbar-{generate-id()}">
                    
                    <ul class="ametys-widget-list">
                        <!-- Downloads -->
                        <xsl:call-template name="sticky-right-widget-download">
                            <xsl:with-param name="widgetId" select="$widgetId"/>
                        </xsl:call-template>
                        
                        <!-- Add to cart -->
                        <xsl:call-template name="sticky-right-widget-wishlist">
                            <xsl:with-param name="widgetId" select="$widgetId"/>
                        </xsl:call-template>
                        
                        <!-- Contact form -->
                        <xsl:call-template name="sticky-right-widget-contact-form">
                            <xsl:with-param name="widgetId" select="$widgetId"/>
                        </xsl:call-template>
                        
                        <!-- Apply link -->
                        <xsl:call-template name="sticky-right-widget-apply">
                            <xsl:with-param name="widgetId" select="$widgetId"/>
                        </xsl:call-template>
                    </ul>
                    
                    <div id="widgetMobileContent">
                        <div id="widgetMobileContentInner"></div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="ametys-widget-overlay"></div>
        
        <xsl:call-template name="sticky-right-widget-js"/>
    </xsl:template>
    
    <!-- +
         | Item of skicky widget for downloads
         | By default display the download link for program to PDF, then the attachments
         + -->
    <xsl:template name="sticky-right-widget-download">
        <!-- Id of sticky parent widget -->
        <xsl:param name="widgetId"/>
        <!-- Id of this widget's item -->
        <xsl:param name="widgetItemId" select="concat($widgetId, '-download')"/>
        <!-- Item's title -->
        <xsl:param name="title"><i18n:text i18n:key="STICKY_WIDGET_DOWNLOAD_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <!-- enable/disable the PDF download of the program -->
        <xsl:param name="pdfDownload" select="true()"/>
        <!-- Text for the PDF -->
        <xsl:param name="pdfText"><i18n:text i18n:key="STICKY_WIDGET_DOWNLOAD_PDF" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <!-- enable/disable the educational booklet PDF download of the program -->
        <xsl:param name="educationalBookletDownload" select="true()"/>
         <!-- Text for the full PDF -->
        <xsl:param name="educationalBookletText"><i18n:text i18n:key="STICKY_WIDGET_DOWNLOAD_EDUCATIONAL_BOOKLET" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <!-- Url of PDF  -->
        <xsl:param name="pdfUrl" select="concat($uri-prefix, '/plugins/odf-web/', $site, '/_content/', /view/content/@name, '/', filename:filterName(/view/content/@title), '.pdf')"/>
        <!-- Attachments -->
        <xsl:param name="attachments" select="metadata/attachments"/>
        
        <xsl:variable name="educationalBooklet" select="odf:getEducationalBooklet(/view/content/@id)"/>
        
        <xsl:if test="$pdfDownload or $attachments/entry/attachment or ($educationalBookletDownload and $educationalBooklet)">
            <li class="ametys-widget-list__item">
                <a class="ametys-widget-list-header collapsed" href="#" aria-expanded="false"
                   data-toggle="collapse"
                   data-target="#collapse_{$widgetItemId}">
                    <span class="ametys-widget-list-header__icon">
                        <span class="ametys-icon-download"></span>
                    </span>
                    <span class="ametys-widget-list-header__text"><xsl:copy-of select="$title"/></span>
                </a>
                
                <div id="collapse_{$widgetItemId}" class="collapse"
                     data-parent="#{$widgetId}">
                    <div class="ametys-widget-list-body">
                        <ul class="ametys-widget-list-el">
                        
                            <!-- PDF -->
                            <xsl:if test="$pdfDownload">
                                <xsl:call-template name="sticky-right-widget-download-item">
                                    <xsl:with-param name="downloadUrl" select="url:encodePath($pdfUrl)"/>
                                    <xsl:with-param name="downloadText" select="$pdfText"/>
                                    <xsl:with-param name="fileName" select="concat(/view/content/@name, '.pdf')"/>
                                </xsl:call-template>
                            </xsl:if>
                            
                            <!-- Education booklet -->
                            <xsl:if test="$educationalBookletDownload and $educationalBooklet">
                                <xsl:call-template name="sticky-right-widget-download-item">
                                    <xsl:with-param name="downloadUrl" select="resolver:resolve($educationalBooklet/@type, $educationalBooklet/@path, 'true')"/>
                                    <xsl:with-param name="downloadText" select="$educationalBookletText"/>
                                    <xsl:with-param name="fileName" select="$educationalBooklet/@filename"/>
                                </xsl:call-template>
                            </xsl:if>
                            
                            <!-- Other attachments -->
                            <xsl:for-each select="$attachments/entry[attachment]">
                                <xsl:call-template name="sticky-right-widget-download-item">
                                    <xsl:with-param name="downloadUrl" select="resolver:resolve(attachment/@type, attachment/@path, 'true')"/>
                                    <xsl:with-param name="downloadText" select="attachment-text"/>
                                    <xsl:with-param name="fileName" select="attachment/@filename"/>
                                </xsl:call-template>
                            </xsl:for-each>
                        </ul>
                    </div>
                </div>
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="sticky-right-widget-download-item">
        <xsl:param name="downloadUrl"/>
        <xsl:param name="downloadText"/>
        <xsl:param name="fileName"/>
        
        <li class="ametys-widget-list-el__item">
            <a class="ametys-widget-list-el__link" href="{$downloadUrl}">
                <span class="ametys-widget-list-el__item-icon">
                    <xsl:call-template name="sticky-right-widget-download-item-icon">
                        <xsl:with-param name="fileName" select="$fileName"/>
                    </xsl:call-template>
                </span>
                <xsl:choose>
                    <xsl:when test="normalize-space($downloadText) != '' or $downloadText"> <xsl:copy-of select="$downloadText"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="$fileName"/></xsl:otherwise>
                </xsl:choose>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="sticky-right-widget-download-item-icon">
        <xsl:param name="fileName"/>
        
        <xsl:choose>
            <xsl:when test="stringutils:endsWith($fileName, '.pdf')"><span class="ametys-icon-pdf"></span></xsl:when>
            <xsl:otherwise><span class="ametys-icon-book"></span></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- +
         | Item of skicky widget for add or remove the current content to the cart
         | Display the number of cart's items and a short abstract of the cart's items.
         + -->
    <xsl:template name="sticky-right-widget-wishlist">
        <xsl:param name="widgetId"/>
        <xsl:param name="widgetItemId" select="concat($widgetId, '-wishlist')"/>
        <xsl:param name="title"><i18n:text i18n:key="STICKY_WIDGET_CART_ADD" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <xsl:param name="addTextKey" select="concat('skin.', $skin, ':STICKY_WIDGET_CART_ADD')"/>
        <xsl:param name="removeTextKey" select="concat('skin.', $skin, ':STICKY_WIDGET_CART_DELETE')"/>
        
        <li class="ametys-widget-list__item">
            <a id="{$widgetItemId}" class="ametys-widget-list-header ametys-widget-list-header--without-chevron" href="#"
               data-tf-is-in-wishlist="out"
               data-tf-default-icon="ametys-icon-heart-alt-2"
               data-tf-active-icon="ametys-icon-heart"
               data-tf-default-text="{$addTextKey}"
               data-tf-active-text="{$removeTextKey}"
               data-tf-active-icon-color="text-primary"
               i18n:attr="data-tf-default-text data-tf-active-text">
                <span class="ametys-widget-list-header__icon">
                    <span class="ametys-icon-heart-alt-2"
                          data-tf-icon="true"></span>
                </span>
                <span class="ametys-widget-list-header__text" data-tf-text="true"><xsl:copy-of select="$title"/></span>
            </a>
            
            <div id="collapse_{$widgetItemId}" class="collapse auto-collapse">
                <div class="ametys-widget-list-body">
                    <div class="text-center g-pt-15 g-px-30">
                        <span class="ametys-header-profile-menu__item-icon">
                            <span id="countWishlist" class="ametys-header-profile-menu__item-badge countWishlist"></span>
                            <span class="ametys-icon-heart"></span>
                        </span>
                        
                        <div class="form-group mb-0">
                            <h2 id="wishlistSummary" class="ametys-widget__subtitle mb-0">
                                Vous avez <span id="countWishlistProgram" class="countWishlist"></span> formations et <span id="countWishlistCourse" class="countWishlist"></span> cours sauvegardés
                            </h2>
                        </div>
                    </div>
                </div>
            </div>
            <script>
            
            <xsl:variable name="itemId"><xsl:call-template name="compute-cartitem-id"/></xsl:variable>
                $j(document).ready(function() {
                
                    function _initStickyWishlist(answer)
                    {
                        $j.HSCore.components.HSToggleFavorite.init('#<xsl:value-of select="$widgetItemId"/>', {
                            isInWishList: answer,
                            itemId: "<xsl:value-of select="$itemId"/>",
                            itemTitle: "<xsl:value-of select="escaper:escapeJavaScript(@title)"/>",
                            callback: ODFCart.emptyCallback
                        });
                    }
                
                    function _updateStickyWishlistPreview()
                    {
                        ODFCart.getItems('<xsl:value-of select="ametys:lang()"/>', 'cart', function(items){
                        
                            if (items.length > 0)
                            {
                                var programCount = 0;
                                var courseCount = 0;
                                
                                $j(items).each(function(index, item) {
                                    if (item.contentTypeId == 'org.ametys.plugins.odf.Content.program' || item.contentTypeId == 'org.ametys.plugins.odf.Content.subProgram')
                                    {
                                        programCount++;
                                    }
                                    else if (item.contentTypeId == 'org.ametys.plugins.odf.Content.course')
                                    {
                                        courseCount++;
                                    }
                                });
                                
                                $j('#countWishlist').text(items.length);
                                
                                var msg = "";
                                
                                if (programCount > 1 &amp;&amp; courseCount > 1)
                                {
                                    msg = "<i18n:text i18n:key="STICKY_WIDGET_WISHLIST_SUMMARY_X_PROGRAMS_Y_COURSES" i18n:catalogue="skin.{$skin}"/>";
                                }
                                else if (programCount == 1 &amp;&amp; courseCount > 1)
                                {
                                    msg = "<i18n:text i18n:key="STICKY_WIDGET_WISHLIST_SUMMARY_1_PROGRAMS_Y_COURSES" i18n:catalogue="skin.{$skin}"/>";
                                }
                                else if (programCount > 1 &amp;&amp; courseCount == 1)
                                {
                                    msg = "<i18n:text i18n:key="STICKY_WIDGET_WISHLIST_SUMMARY_X_PROGRAMS_1_COURSES" i18n:catalogue="skin.{$skin}"/>";
                                }
                                else if (programCount == 1 &amp;&amp; courseCount == 1)
                                {
                                    msg = "<i18n:text i18n:key="STICKY_WIDGET_WISHLIST_SUMMARY_1_PROGRAMS_1_COURSES" i18n:catalogue="skin.{$skin}"/>";
                                }
                                else if (programCount == 1 &amp;&amp; courseCount == 0)
                                {
                                    msg = "<i18n:text i18n:key="STICKY_WIDGET_WISHLIST_SUMMARY_1_PROGRAMS_0_COURSES" i18n:catalogue="skin.{$skin}"/>";
                                }
                                else if (programCount > 1 &amp;&amp; courseCount == 0)
                                {
                                    msg = "<i18n:text i18n:key="STICKY_WIDGET_WISHLIST_SUMMARY_X_PROGRAMS_0_COURSES" i18n:catalogue="skin.{$skin}"/>";
                                }
                                else if (courseCount == 1 &amp;&amp; programCount == 0)
                                {
                                    msg = "<i18n:text i18n:key="STICKY_WIDGET_WISHLIST_SUMMARY_0_PROGRAMS_1_COURSES" i18n:catalogue="skin.{$skin}"/>";
                                }
                                else if (courseCount > 1 &amp;&amp; programCount == 0)
                                {
                                    msg = "<i18n:text i18n:key="STICKY_WIDGET_WISHLIST_SUMMARY_0_PROGRAMS_Y_COURSES" i18n:catalogue="skin.{$skin}"/>";
                                }
                                
                                msg = msg.replace(/{{programCount}}/ig, programCount).replace(/{{courseCount}}/ig, courseCount);
                                
                                $j('#wishlistSummary').text(msg);
                                
                                // $('#collapse_<xsl:value-of select="$widgetItemId"/>').show();
                            }
                            else
                            {
                                $('#collapse_<xsl:value-of select="$widgetItemId"/>').hide();
                            }
                        });
                    }
                    
                    ODFCart.hasItem('<xsl:value-of select="$itemId"/>', _initStickyWishlist);
                    ODFCart.registerListener(_updateStickyWishlistPreview);
                    _updateStickyWishlistPreview();
                });
            </script>
        </li>
    </xsl:template>
    
    <!-- +
         | Item of skicky widget for a contact form.
         | Configure the form url as you want. 
         | For example, it can be the url of a tagged page which contains the same contact form
         + -->
    <xsl:template name="sticky-right-widget-contact-form">
        <xsl:param name="widgetId"/>
        <xsl:param name="widgetItemId" select="concat($widgetId, '-contact')"/>
        <xsl:param name="formActionUrl"/>
        <xsl:param name="title"><i18n:text i18n:key="STICKY_WIDGET_CONTACT_FORM_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <!-- Form's input's names -->
        <xsl:param name="nameInputName">name</xsl:param>
        <xsl:param name="emailInputName">email</xsl:param>
        <xsl:param name="messageInputName">message</xsl:param>
        <!-- Form's fieds labels -->
        <xsl:param name="nameInputKey" select="concat('skin.', $skin, ':STICKY_WIDGET_CONTACT_FORM_FIELD_NAME')"/>
        <xsl:param name="emailInputKey" select="concat('skin.', $skin, ':STICKY_WIDGET_CONTACT_FORM_FIELD_EMAIL')"/>
        <xsl:param name="messageInputKey" select="concat('skin.', $skin, ':STICKY_WIDGET_CONTACT_FORM_FIELD_MESSAGE')"/>
        <xsl:param name="submitBtnText"><i18n:text i18n:key="STICKY_WIDGET_CONTACT_FORM_SUBMIT_BTN_TEXT" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <!-- Custom text -->
        <xsl:param name="beforeSubmitText"><i18n:text i18n:key="STICKY_WIDGET_CONTACT_FORM_BEFORE_SUBMIT_TEXT" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <xsl:param name="bottomText"><i18n:text i18n:key="STICKY_WIDGET_CONTACT_FORM_BOTTOM_TEXT" i18n:catalogue="skin.{$skin}"/></xsl:param>
        
        <li class="ametys-widget-list__item">
            <a class="ametys-widget-list-header collapsed" href="#" aria-expanded="false"
               data-toggle="collapse"
               data-target="#collapse_{$widgetItemId}">
                <span class="ametys-widget-list-header__icon">
                    <span class="ametys-icon-envelope"></span>
                </span>
                <span class="ametys-widget-list-header__text"><xsl:copy-of select="$title"/></span>
            </a>
            
            <div id="collapse_{$widgetItemId}" class="collapse"
                 data-parent="#{$widgetId}">
                <div class="ametys-widget-list-body">
                    <div class="ametys-widget-form">
                        <form action="{$formActionUrl}" method="POST">
                            <div class="form-group">
                                <input class="form-control form-control-md" type="text" name="{$nameInputName}" placeholder="{$nameInputKey}" i18n:attr="placeholder"/>
                            </div>
                            
                            <div class="form-group">
                                <input class="form-control form-control-md" type="email" name="{$emailInputName}" placeholder="{$emailInputKey}" i18n:attr="placeholder" />
                            </div>
                            
                            <div class="form-group">
                                <textarea class="form-control form-control-md" rows="5" name="{$messageInputName}" placeholder="{$messageInputKey}" i18n:attr="placeholder"></textarea>
                            </div>
                            
                            <xsl:if test="$beforeSubmitText">
                                <p class="lead text-center"><xsl:copy-of select="$beforeSubmitText"/></p>
                            </xsl:if>
                            
                            <div class="form-group">
                                <button class="btn btn-alt btn-alt-md btn-primary btn-block" type="submit"><xsl:copy-of select="$submitBtnText"/></button>
                            </div>
                            
                            <xsl:if test="$bottomText">
                                <p class="lead text-center">
                                    <xsl:copy-of select="$bottomText"/>
                                </p>
                            </xsl:if>
                        </form>
                    </div>
                </div>
            </div>
        </li>
    </xsl:template>
    
    <!-- +
         | Item of skicky widget to subscribe to the program.
         | Configure the url to apply.
         + -->
    <xsl:template name="sticky-right-widget-apply">
        <xsl:param name="widgetId"/>
        <xsl:param name="widgetItemId" select="concat($widgetId, '-apply')"/>
        <xsl:param name="title"><i18n:text i18n:key="STICKY_WIDGET_APPLY_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <xsl:param name="applyUrl">#</xsl:param>
        
        <li class="ametys-widget-list__item border-bottom-0">
            <a class="ametys-widget-list-header" href="{$applyUrl}">
                <span class="ametys-widget-list-header__icon">
                    <span class="ametys-icon-pencil-alt"></span>
                </span>
                <span class="ametys-widget-list-header__text"><xsl:copy-of select="$title"/></span>
            </a>
        </li>
        <li class="ametys-widget-list__item ametys-widget-list__item--mobile-invoker">
            <a id="widgetMobileInvoker" class="ametys-widget-list-header" href="javascript:;">
                <span class="ametys-widget-list-header__icon">
                    <span class="ametys-icon-angle-down"></span>
                </span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="sticky-right-widget-js">
        <xsl:param name="widgetId" select="concat('widget-', generate-id())"/>
        
        <script>
            $j.HSCore.components.HSScrollBar.init($('#scrollbar-<xsl:value-of select="generate-id()"/>'));
            
            if (window.innerWidth &lt; 768) {
                
                var opened = false;
                
                $j('#<xsl:value-of select="$widgetId"/> .collapse').on('show.bs.collapse', function () {
                    
                    $j('.ametys-widget-overlay').fadeIn(400);
                    $j('#blurContainer').addClass('ametys-blur');
                    
                    $j('#widgetMobileInvoker').addClass('active');
                    
                    opened = true;
                    
                });
                
                $j('#<xsl:value-of select="$widgetId"/> .collapse').on('hidden.bs.collapse', function () {
                    
                    if (!$j('#<xsl:value-of select="$widgetId"/> [aria-expanded="true"]').length) {
                        
                        $j('.ametys-widget-overlay').fadeOut(400);
                        $j('#blurContainer').removeClass('ametys-blur');
                        
                        $j('#widgetMobileInvoker').removeClass('active');
                        
                        opened = false;
                        
                    }
                    
                });
                
                $j('#widgetMobileInvoker').on('click', function () {
                    
                    $j(this).toggleClass('active');
                    
                    if (!opened) {
                        // Show first widget
                        $j('#collapse_<xsl:value-of select="$widgetId"/>_1').collapse('show');
                        opened = true
                        
                    } else {
                        
                        $j('#<xsl:value-of select="$widgetId"/> .collapse').collapse('hide');
                        
                        opened = false
                        
                    }
                    
                });
                
                $j('.ametys-widget-overlay').on('click', function () {
                    $j(this).fadeOut(400);
                    $j('#blurContainer').removeClass('ametys-blur');
                    
                    $j('#<xsl:value-of select="$widgetId"/> .collapse').collapse('hide');
                    
                    opened = false
                });
                
            }
        </script>
    </xsl:template>
    
</xsl:stylesheet>