<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="sitemap resolver ametys">
    
    <xsl:import href="wa://tracking" />
    
	<!-- + | HEAD + -->
	<xsl:template name="head">
		<head>
            
            <xsl:call-template name="head-meta-top"/>        
            <title><xsl:call-template name="get-title" /></title>
            
            <xsl:call-template name="meta" />
            <xsl:call-template name="og-meta" />
                
			<xsl:call-template name="common-css"/>
            <xsl:call-template name="additionnal-css" />
            
            <xsl:call-template name="common-script"/>
            <xsl:call-template name="additionnal-script" />
            
            <xsl:call-template name="web-tracking"/>
            
            <xsl:call-template name="head-other"/>
		</head>
	</xsl:template>
    
    <xsl:template name="head-meta-top">
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no, maximum-scale=1, user-scalable=0"/>
    </xsl:template>
    
    <xsl:template name="get-title">
        <xsl:choose>
            <xsl:when test="/cms/page"><xsl:value-of select="/cms/page/@long-title" /><xsl:text> - </xsl:text></xsl:when>
            <xsl:when test="/cms/html/head/title"><xsl:value-of select="/cms/html/head/title" /><xsl:text> - </xsl:text></xsl:when>
        </xsl:choose>
        <i18n:text i18n:key="SKIN_TITLE" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <!-- + 
         | META
         + -->
    <xsl:template name="meta">
        <meta content="Ametys CMS Open source (http://www.ametys.org)" name="generator"/>
        
        <meta name="author" content="Ametys V4" />
        <meta name="copyright" content="Ametys V4" />
        <meta name="language" content="{$lang}" />
        <meta name="revisit-after" content="15 days" />
        
        <xsl:if test="/cms/page/pageContents/zone[@name = 'default']/zoneItem/html/head/meta[@name = 'DC.subject']">
            <meta name="subject" content="{/cms/page/pageContents/zone/zoneItem/html/head/meta[@name = 'DC.subject']/@content}"/>
        </xsl:if>
        
        <xsl:if test="/cms/page/pageContents/zone[@name = 'default']/zoneItem/html/head/meta[@name = 'DC.description']">
            <meta name="description" content="{/cms/page/pageContents/zone/zoneItem/html/head/meta[@name = 'DC.description']/@content}"/>
        </xsl:if>
        
        <!-- Copy Dublin Core metadata. -->
        <xsl:copy-of select="/cms/page/pageContents/zone[@name = 'default']/zoneItem/html/head/meta[starts-with(@name, 'DC.')]"/>
    </xsl:template>
    
    <!-- + 
         | OPEN GRAPH META
         + -->
    <xsl:template name="og-meta">
        <xsl:comment>
            <xsl:for-each select="/cms/page/pageContents/zone[@name = 'default']/zoneItem[information/type = 'CONTENT'][1]/html/head">
                    <meta property="og:title" content="{meta[@name = 'DC.title']/@content}" />
                    <xsl:if test="meta[@name = 'DC.description']">
                        <meta property="og:description" content="{meta[@name = 'DC.description']/@content}" />
                    </xsl:if>
                    <xsl:if test="meta[@name = 'DC.type']">
                        <meta property="og:type" content="{meta[@name = 'DC.type']/@content}" />
                    </xsl:if>
            </xsl:for-each>
        </xsl:comment>
    </xsl:template>

	<xsl:template name="common-css">
        <!-- Note This is where you can other meta, script or link ; and also a title tag -->
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/fonts/roboto/stylesheet.css')}"/>
        <link rel="stylesheet" href="{ametys:pluginResourceURL('fontawesome6-free', 'css/all.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/fonts/material-design-icons/stylesheet.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/fonts/icon-hs/style.css')}"/>
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/fonts/ametys-icons/stylesheet.css')}"/>
        
        <!-- Custom styles -->
        <xsl:call-template name="custom-css"/>
        
        <!-- For dropdown lists (should be loaded before main.css) -->
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/chosen/chosen.css')}"/>

        <!-- Main Styles -->
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/scss/main.css')}"/>
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/scss/print.css')}"/>
        <!-- End Main Styles -->
        
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/hs-megamenu/src/hs.megamenu.css')}"/>
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/animate.css')}"/>
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/malihu-scrollbar/jquery.mCustomScrollbar.css')}"/>
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/slick-carousel/slick/slick.css')}"/>
        
        <xsl:call-template name="head-css-fancybox"/>
	</xsl:template>
    
    <xsl:template name="head-css-jquery">
        <!-- jQuery theme -->
        <link type="text/css" href="{ametys:pluginResourceURL('jquery-ui', 'css/ui-lightness/jquery-ui.css')}" rel="stylesheet" />
        <link media="screen, print" rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/jquery-ui/jquery-ui.theme.css')}" type="text/css"/>
    </xsl:template>
    
    <!-- + 
         | CUSTOM CSS / ADDITIONAL FONTS
         + -->
    <xsl:template name="custom-css">
        <!-- Insert your custom css here (ex: additional fonts )-->
    </xsl:template>
	
    <xsl:template name="common-script">
        <!-- Note Default files -->
		<!-- Note jquery is used by many default Ametys rendering AND by the backoffice: it can not be removed, but you may use a compatible newer version: the default version is 2.2.4 -->
		<!-- Note jquery ui is used by many default Ametys rendering: it can be removed if none of thoses are used. The default version is 1.11.4 -->
		<!-- Note pirobox extended is a jquery plugin used to zoom in on one picture and for galleries: replacing it will require to achieve those two purposes and need to be justified. -->
		<!-- Note jquery cookie is used at least to register the user consent about the cookie banner. Replacing it need to be justified. -->
		<!-- Note media element is a video/audio played used by default by Ametys. Replacing it need to be justified. -->
		
		<script src="{ametys:skinURL('templates/common/plugins/jquery-migrate/jquery-migrate.js')}"></script>
		<script>
            $j.migrateMute = true;
        </script>
        <xsl:call-template name="head-js-fancybox"/>
        
        <script type="text/javascript">
            contextPath = "<xsl:value-of select="ametys:siteUriPrefix()"/>"; 
        </script>
		
		<script src="{ametys:skinURL('templates/common/plugins/popper.js/dist/umd/popper.js')}"></script>
		<script src="{ametys:skinURL('main/bootstrap/dist/js/bootstrap.js')}"></script>
        <script src="{ametys:skinURL('templates/common/plugins/hs-megamenu/src/hs.megamenu.js')}"></script>
		<script src="{ametys:skinURL('templates/common/plugins/malihu-scrollbar/jquery.mCustomScrollbar.js')}"></script>
		<script src="{ametys:skinURL('templates/common/plugins/slick-carousel/slick/slick.js')}"></script>
		
		<script src="{ametys:skinURL('templates/common/js/hs.core.js')}"></script>
        <script src="{ametys:skinURL('templates/common/js/helpers/hs.hamburgers.js')}"></script>
		<script src="{ametys:skinURL('templates/common/js/components/hs.dropdown.js')}"></script>
        <script src="{ametys:skinURL('templates/common/js/components/hs.select.js')}"></script>
		<script src="{ametys:skinURL('templates/common/js/components/hs.scrollbar.js')}"></script>
        
        <script src="{ametys:skinURL('templates/common/js/components/hs.validation.js')}"></script>
        <script src="{ametys:skinURL('templates/common/js/components/hs.step-form.js')}"></script>
        <script src="{ametys:skinURL('templates/common/js/components/hs.popup.js')}"></script>
        <script src="{ametys:skinURL('templates/common/js/components/hs.carousel.js')}"></script>
        
        <script src="{ametys:skinURL('templates/common/js/components/hs.scroll-nav-alt.js')}"></script>
        <script src="{ametys:skinURL('templates/common/js/components/hs.limited-content.js')}"></script>
        <script src="{ametys:skinURL('templates/common/js/components/hs.toggle-favorite.js')}"></script>
        <script src="{ametys:skinURL('templates/common/js/components/hs.scroll-to.js')}"></script>
		
		<script src="{ametys:skinURL('templates/common/js/toggle-menu.js')}"></script>
		<script src="{ametys:skinURL('templates/common/js/main.js')}"></script>
		
        <!-- ODF cart -->
        <script type="text/javascript" src="{ametys:pluginResourceURL('odf-web', 'js/cart/Cart.js')}"></script>
    </xsl:template>
    
    <xsl:template name="favico">
        <xsl:choose>
            <xsl:when test="ametys:skinResources('img/favicon.ico')">
                <link rel="icon" type="image/x-icon" href="{ametys:skinURL('img/favicon.ico')}" />
                <link rel="shortcut icon" type="image/x-icon" href="{ametys:skinURL('img/favicon.ico')}" />
            </xsl:when>
            <xsl:otherwise>
                <link rel="icon" type="image/x-icon" href="{$uri-prefix}/favicon.ico" />
                <link rel="shortcut icon" type="image/x-icon" href="{$uri-prefix}/favicon.ico" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
	
    <xsl:template name="additionnal-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/education/scss/main.css')}"/>
        <link rel="stylesheet" href="{ametys:skinURL('zones/education/scss/print.css')}"/>
    </xsl:template>
    
    <xsl:template name="additionnal-script"/>
    
    <!-- Pirobox replace by fancybox -->
    <xsl:template name="head-js-pirobox"/>
    <xsl:template name="head-css-pirobox"/>
    
    <xsl:template name="head-css-fancybox">
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/fancybox/jquery.fancybox.css')}"/>
    </xsl:template>
    
    <xsl:template name="head-js-fancybox">
        <script src="{ametys:skinURL('templates/common/plugins/fancybox/jquery.fancybox.js')}"></script>
        <script type="text/javascript">
          $(function () {
            // initialization of popups
            $.HSCore.components.HSPopup.init('.js-fancybox', {
              transitionEffect: false
            });
          });
        </script>
    </xsl:template>
    
    <!-- Other instructions for head -->
    <xsl:template name="head-other"/>
</xsl:stylesheet>
