<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="sitemap resolver ametys">

    <xsl:template name="breadcrumb">
        <ul class="ametys-breadcrumbs">
            <xsl:if test="$sitemap/page[@sitemap:name = 'index']">
                <li class="ametys-breadcrumbs__item">
                    <a class="ametys-breadcrumbs__link" href="{$site-uri-prefix}/{$lang}/index.html">
                        <xsl:value-of select="$sitemap/page[@sitemap:name = 'index']/@sitemap:title"/>
                    </a>
                </li>
            </xsl:if>
            <xsl:for-each select="$sitemap//page[not(@sitemap:path = 'index') and @sitemap:in-path = 'true']">
                <li class="ametys-breadcrumbs__item">
                    <xsl:choose>
                        <xsl:when test="not(@sitemap:current)">
                            <a class="ametys-breadcrumbs__link" href="{resolver:resolve('page', @sitemap:id)}">
                                <xsl:value-of select="@sitemap:title" />
                            </a>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="@sitemap:title" />
                        </xsl:otherwise>
                    </xsl:choose>
                </li>
            </xsl:for-each>
        </ul>
    </xsl:template>
</xsl:stylesheet>