<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys resolver">

	<xsl:import href="skin://stylesheets/main.xsl" />

    <xsl:template name="main-content">
        <div class="ametys-main-content profile">
			<div class="bg-light-alt">
				<nav class="container">
					<ul class="ametys-tabs-controls nav mb-0" role="tablist">
						<xsl:call-template name="tab-01-title"/>
						
						<xsl:call-template name="tab-02-title"/>
					</ul>
				</nav>
			</div>
			
            <div class="container">
            	<div class="container">
					<div class="tab-content">
						<xsl:call-template name="tab-01-content"/>
						
						<xsl:call-template name="tab-02-content"/>
                	</div>
                </div>
                
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="main-banner">
        <xsl:variable name="bgImg"><xsl:call-template name="main-banner-background-url"/></xsl:variable>
        <div class="ametys-main-banner" style="background-image: url({ametys:escapeURLforCSS($bgImg)}); min-height: 220px;">
                
            <div class="ametys-main-banner-inner">
                
                <div class="container">
            
                    <xsl:call-template name="breadcrumb"/>
                    <xsl:call-template name="main-banner-title"/>
                    
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="main-banner-title">
        <h1 class="ametys-main-banner__title"><xsl:value-of select="/cms/page/@long-title"></xsl:value-of></h1>
    </xsl:template>
    
    <xsl:template name="main-banner-background-url">
        <xsl:value-of select="ametys:skinURL('templates/common/img/banners/banner-2.jpg')"/>
    </xsl:template>
    
    <xsl:template name="tab-01-title">
    	<li class="ametys-tabs-controls__item">
			<a class="ametys-tabs-controls__link active" href="#tab01-{$uniqueId}" role="tab" aria-controls="tab1" aria-selected="true"
			   data-toggle="tab">
			   	<xsl:choose>
			   		<xsl:when test="/cms/page/pageContents/zone[@name='default']/zoneItem[1]/html/head/title != ''">
			   			<xsl:value-of select="/cms/page/pageContents/zone[@name='default']/zoneItem[1]/html/head/title"/>
			   		</xsl:when>
			   		<xsl:when test="/cms/page/pageContents/zone[@name='default']/zoneItem[1]">
			   			<i18n:text i18n:key="SKIN_BO_ZONING_PAGE_WITH_TABS_DEFAULT_TAB1" i18n:catalogue="skin.{$skin}"/>
			   		</xsl:when>
			   		<xsl:otherwise>
			   			<i18n:text i18n:key="SKIN_BO_ZONING_PAGE_WITH_TABS_NEW_TAB" i18n:catalogue="skin.{$skin}"/>
			   		</xsl:otherwise>
			   	</xsl:choose>
			</a>
		</li>
    </xsl:template>
    
    <xsl:template name="tab-01-content">
    	<div id="tab01-{$uniqueId}" class="tab-pane fade show active" role="tabpanel">
							
            <xsl:if test="$rendering-context = 'back' and /cms/page/pageContents/zone[@name='default']/zoneItem[1]/html/head/title = ''">
                <div class="g-color-red g-font-weight-900 g-my-10">
                    <i18n:text i18n:key="SKIN_BO_ZONING_PAGE_WITH_TABS_DEFAULT_TAB_HELP" i18n:catalogue="skin.{$skin}" />
                </div>
            </xsl:if>	
   		
        	<zone name="default" level="1"/>
        </div>
    </xsl:template>
    
    <xsl:template name="tab-02-title">
		<xsl:if test="/cms/page/pageContents/zone[@name='tab02']/zoneItem[1] or ($rendering-context = 'back' and /cms/page/pageContents/zone[@name='default']/zoneItem[1])">
			<li class="ametys-tabs-controls__item">
				<a class="ametys-tabs-controls__link" href="#tab02-{$uniqueId}" role="tab" aria-controls="tab2" aria-selected="false"
				   data-toggle="tab">
				   	<xsl:choose>
				   		<xsl:when test="/cms/page/pageContents/zone[@name='tab02']/zoneItem[1]/html/head/title != ''">
				   			<xsl:value-of select="/cms/page/pageContents/zone[@name='tab02']/zoneItem[1]/html/head/title"/>
				   		</xsl:when>
				   		<xsl:when test="/cms/page/pageContents/zone[@name='tab02']/zoneItem[1]">
				   			<i18n:text i18n:key="SKIN_BO_ZONING_PAGE_WITH_TABS_DEFAULT_TAB2" i18n:catalogue="skin.{$skin}"/>
				   		</xsl:when>
				   		<xsl:otherwise>
				   			<i18n:text i18n:key="SKIN_BO_ZONING_PAGE_WITH_TABS_NEW_TAB" i18n:catalogue="skin.{$skin}"/>
				   		</xsl:otherwise>
				   	</xsl:choose>
				</a>
			</li>
		</xsl:if>
	</xsl:template>
    
    <xsl:template name="tab-02-content">
    	<xsl:if test="/cms/page/pageContents/zone[@name='tab02']/zoneItem[1] or $rendering-context = 'back'">	
			<div id="tab02-{$uniqueId}" class="tab-pane fade" role="tabpanel">
				
                <xsl:if test="$rendering-context = 'back' and /cms/page/pageContents/zone[@name='default']/zoneItem[1]/html/head/title = ''">
                    <div class="g-color-red g-font-weight-900 g-my-10">
                        <i18n:text i18n:key="SKIN_BO_ZONING_PAGE_WITH_TABS_DEFAULT_TAB_HELP" i18n:catalogue="skin.{$skin}" />
                    </div>
                </xsl:if>   
            
				<zone name="tab02" level="1"/>
			</div>
		</xsl:if>
    </xsl:template>
    
</xsl:stylesheet>