<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                exclude-result-prefixes="resolver ametys">

    <xsl:import href="skin://welcome/index.xsl"/>
    
    <xsl:template name="welcome-head-title">
        <title>Aide</title>
    </xsl:template>
    
    <xsl:template name="ametys-community">
        <h2>Communauté</h2>
        <p>Ametys est un logiciel OpenSource, n'hésitez pas à suivre l'avancement du projet et à faire part de vos remarques sur :</p>
        <ul>
            <li><a target="_blank" href="http://www.ametys.org/forum">Le forum Ametys</a></li>
            <li><a target="_blank" href="http://docs.ametys.org/">Documentations Ametys</a></li>
            <li><a target="_blank" href="https://issues.ametys.org/browse/ODF">L'outil de suivi d'anomalie ou de demandes d'amélioration (en anglais)</a></li>
        </ul>
        <p>Retrouvez toutes ces informations ainsi que d'autres sur <a target="_blank" href="http://www.ametys.org">www.ametys.org</a>.</p>
    </xsl:template>
    
    <xsl:template name="print">
        <div class="print">
            <a href="javascript:window.print()" title="Imprimer"><i class="fas fa-print"/></a>
        </div>
    </xsl:template>
    
    <xsl:template name="main-presentation">
         <h1>Bienvenue sur Ametys ODF</h1>
         <p>
            Vous êtes dans l'espace de contribution de <strong>Ametys ODF</strong>.
         </p>
        
         <p>
            Il existe dans Ametys 3 connecteurs d'import et synchronisation au choix pour l'offre de formation :
            <ul>
                <li><strong>Apogée</strong> : import et synchronisation des formations et de leur structure avec la base Apogée de votre établissement</li>
                <li><strong>CDM-fr/ROF</strong> : import et synchronisation des formations et de leur structure avec une base de fichiers XML au format CDM-fr</li>
                <li><strong>Pégase</strong> : import et synchronisation des formations et de leur structure avec l'application Pégase de votre établissement</li>
            </ul>
         </p>
         
         <p>
            Il existe également 2 connecteurs d'export pour l'offre de formation :
            <ul>
                <li><strong>Pégase</strong> : export de la structure et des données supportées par Pégase dans l'instance Pégase de votre établissement</li>
                <li><strong>OSE</strong> : export de la structure de l'offre de formation et des données de pilotage vers OSE</li>
            </ul>
         </p>
    </xsl:template>
    
    <xsl:template name="get-started">
        <h1>Commencer</h1>
        <p>
            Utilisez l'outil
            <b>
                <i>Plan du site</i>
            </b>
            à gauche pour commencer à créer des pages ou les modifier.
            <br />
            Double-cliquez sur une page pour l'ouvrir.
        </p>
        
        <h1>Besoin d'aide sur une fonction ?</h1>
        <p>Renseignez les mots clés correspondant à la fonction sur laquelle vous souhaitez de l'aide dans la barre de recherche "Recherche une fonctionnalité" du ruban.<br/>
        Utilisez l'aide en ligne en appuyant sur la <strong>touche F1</strong> au survol d'un bouton ou d'un outil, ou en cliquant sur le lien <strong>En savoir plus</strong> de l'info-bulle.</p>
    </xsl:template>
    
    
    <xsl:template name="skin-presentation">
        <h1>Les gabarits</h1>
        <h2>Accueil</h2>
        <img src="{$uri-prefix}/skins/{$skin}/templates/index/resources/thumbnail.png" alt="Page d'accueil" class="floatleft" />
        <p>
            Le gabarit <i>accueil</i> est réservé à la page d'accueil, nommée "index". <br/>
            Ce gabarit d'accueil est composé de 2 zones :
            <ul>
                <li>une zone d'entête destinée à recevoir le service "Recherche" avec la vue "Bandeau de recherche"</li>
                <li>une zone principale: elle peut contenir du texte éditorial, une vidéo de présentation, le schéma des formations, ..</li>
            </ul>
            
            Les autres éléments graphiques qui composent la page d'accueil sont :
            <ul>
                <li>un carrousel des domaines de formations</li>
                <li>un encart de liens utiles ou favoris (à personnaliser)</li>
                <li>un carrousel des composantes</li>
            </ul>
        </p>
        <br style="clear:both"/>
            <h2>Page</h2>
            <img src="{$uri-prefix}/skins/{$skin}/templates/page/resources/thumbnail.png" alt="Page" class="floatleft" />
            <p>Le gabarit <i>page</i> est utilisé pour la majorité des pages du sites.
                <br/> 
                Il comprend une seule zone principale.<br/>
                Les autres éléments graphiques qui composent ce gabarit sont :
            <ul>
                <li>Bandeau: Le bandeau est constitué d'une image fixe. Il n'est
                    pas possible de la modifier</li>
                <li>Navigation: Le bandeau des rubriques principales se
                    constitue automatiquement, avec les pages
                    étiquetées en tant que "Rubrique principale".</li>
                <li>Pied de page: Les liens du pied de pied sont constituées des pages étiquetées "Catalogue", "Accès directs" et "Autres liens".
                </li>
            </ul>
            </p>
            <div class="clear-L"></div>
    </xsl:template>
    
</xsl:stylesheet>                        
