<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                exclude-result-prefixes="ametys">
    
    <xsl:import href="plugin:odf-web://pages/services/cart/cart.xsl"/>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/cart/scss/main.css')}"/>    
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/cart/scss/print.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <!-- Default script for cart -->
        <xsl:call-template name="default-cart-head-js"/>
        
        <script type="text/javascript">
            <!-- Overriden functions -->
            function _onCartNotEmpty()
            {
                var programWrap = $j('.cart-items-programs');
                var courseWrap = $j('.cart-items-courses');
                
                // Update subscription checkbox
                programWrap.find('input[data-subscriber="true"]').attr('checked', 'checked');
                courseWrap.find('.ametys-checkbox').hide();
                
                if (__pCount &gt; 0)
                    programWrap.show();
                else
                    $j('.no-program').show();
                    
                if (__cCount &gt; 0)
                    courseWrap.show();
               else
                    $j('.no-course').show();
                    
                $j('.cart-actions').show();
            }
            
            // Overriden
            function _updateTotals()
            {
                if (__cCount &gt; 0)
                {
                    var totalsWrap = $j('.ametys-total-info');
                    totalsWrap.find('.ametys-total-info__item-ects').find('.ametys-total-info__item-right-section').html(__totalEcts + "<i18n:text i18n:key="PLUGINS_ODFWEB_CART_TOTAL_ECTS_UNIT" i18n:catalogue="plugin.odf-web"/>");
                    totalsWrap.find('.ametys-total-info__item-hours').find('.ametys-total-info__item-right-section').html(__totalHours + "<i18n:text i18n:key="PLUGINS_ODFWEB_CART_TOTAL_HOURS_UNIT" i18n:catalogue="plugin.odf-web"/>");
                    totalsWrap.show();
                }
            }
            
            ODFCart.registerListener(function() {
                ODFCart.getItems('<xsl:value-of select="ametys:lang()"/>', 'cart', _updateCartItems);
            });
        </script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="ametys-cart-checkout">
            <xsl:call-template name="common-service-body-nonempty-content-title-content">
                <xsl:with-param name="title" select="$header/text()"/>
                <xsl:with-param name="default-title"><i18n:text i18n:key="SKIN_SERVICE_ODF_CART_DEFAULT_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            </xsl:call-template>
            
	        <noscript><p><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_NO_SCRIPT"/></p></noscript>
            
            <xsl:call-template name="cart-item-template"/>
        
	        <xsl:call-template name="cart-empty"/>
	        
	        <xsl:call-template name="cart-top"/>
	        
	        <xsl:call-template name="cart-items"/>
            
	        <xsl:call-template name="cart-bottom"/>
	        
	        <xsl:call-template name="cart-share-dialog"/>
        </div>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title-rendering">
        <xsl:param name="title"/>
   
        <h2 class="ametys-cart-checkout__title"><xsl:copy-of select="$title"/></h2>
    </xsl:template>
    
    <xsl:template name="cart-empty"/>
    
    <xsl:template name="cart-top"/>
    
    <xsl:template name="cart-item-template">
        <script id="cart-item-template" type="text/template">
            
            <li id="cart-item-{{{{name}}}}" class="ametys-cart-list__item alert alert-dismissible fade show" data-type="{{{{itemType}}}}">
                <div class="ametys-cart-list__item-body">
                    <h4 class="ametys-cart-list__item-title">
                        <span class="ametys-cart-list__item-title-icon ametys-icon-graduation-cap-alt"></span>
                        <div>
                        <a href="{{{{pagePath}}}}">
                            {{title}}
                        </a>
                        <span data-has-parent="{{{{hasParentProgram}}}}" data-parent-title="{{{{parentProgramTitle}}}}" class="ametys-cart-list__item-parent">{{parentProgramTitle}}</span>
                        </div>
                    </h4>
                    {{view}}
                    
                    <div class="ametys-checkbox ametys-checkbox--light">
                        <input data-subscriber="{{{{subscriber}}}}" id="subscribe-{{{{name}}}}" class="ametys-checkbox__control" type="checkbox" onclick="ODFCart.subscribe('{{{{id}}}}', this.checked);"/>
                        <label class="ametys-checkbox__label" for="subscribe-{{{{name}}}}"><i18n:text i18n:key="SKIN_SERVICE_ODF_CART_ITEM_SUBSCRIBE" i18n:catalogue="skin.{$skin}"/></label>
                    </div>
                </div>
                
                <a class="ametys-cart-list__item-remove" href="#" onclick="ODFCart.removeItem('{{{{id}}}}', ODFCart.emptyCallback)" data-dismiss="alert">
                    <span class="fas fa-times"></span>
                </a>
            </li>
        </script>
    </xsl:template>
    
    <xsl:template name="cart-items">
        <ul class="ametys-tabs-controls nav text-center" role="tablist">
            <li class="ametys-tabs-controls__item">
                <a class="ametys-tabs-controls__link active" href="#cart-programs-{$uniqueId}" role="tab" aria-controls="cart-programs-{$uniqueId}"
                    aria-selected="true" data-toggle="tab"><i18n:text i18n:key="SKIN_SERVICE_ODF_CART_TAB_PROGRAMS" i18n:catalogue="skin.{$skin}"/></a>
            </li>
            <li class="ametys-tabs-controls__item">
                <a class="ametys-tabs-controls__link" href="#cart-courses-{$uniqueId}" role="tab" aria-controls="cart-courses-{$uniqueId}"
                    aria-selected="false" data-toggle="tab"><i18n:text i18n:key="SKIN_SERVICE_ODF_CART_TAB_COURSES" i18n:catalogue="skin.{$skin}"/></a>
            </li>
        </ul>
    
        <div class="tab-content">
            <div class="tab-pane fade show active" id="cart-programs-{$uniqueId}" role="tabpanel">
                <xsl:call-template name="cart-no-programs"/>
                <ul class="ametys-cart-list cart-items-programs">
                </ul>
            </div>
            <div class="tab-pane fade" id="cart-courses-{$uniqueId}" role="tabpanel">
                <xsl:call-template name="cart-no-courses"/>
                <ul class="ametys-cart-list cart-items-courses">
                </ul>
                
                <!-- Total hours and ects -->
                <xsl:call-template name="cart-totals"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="cart-no-programs">
        <p class="empty-cart no-program text-center" style="display: none;"><i18n:text i18n:key="SKIN_SERVICE_ODF_CART_NO_PROGRAM" i18n:catalogue="skin.{$skin}"/></p>
    </xsl:template>
    
    <xsl:template name="cart-no-courses">
        <p class="empty-cart no-course text-center" style="display: none;"><i18n:text i18n:key="SKIN_SERVICE_ODF_CART_NO_COURSE" i18n:catalogue="skin.{$skin}"/></p>
    </xsl:template>
    
    <xsl:template name="cart-actions">
        <ul class="ametys-actions-list text-right cart-actions" style="display:none">
            <xsl:call-template name="cart-action-clear"/>
            <xsl:call-template name="cart-action-share"/>
            <xsl:call-template name="cart-action-download"/>
        </ul>     
    </xsl:template>
    
    <xsl:template name="cart-action-clear">
        <li class="ametys-actions-list__item">
            <a class="ametys-actions-list__link" href="javascript:void()" onclick="ODFCart.removeAll()">
                <span class="ametys-actions-list__item-icon fas fa-trash"></span>
                <span class="ametys-actions-list__item-text"><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_REMOVE_ALL" i18n:catalogue="plugin.odf-web"/></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="cart-action-share">
        <li class="ametys-actions-list__item">
            <a class="ametys-actions-list__link" href="javascript:void()" onclick="ODFCart.share('{ametys:site()}', 'odfcart-share-dialog')">
                <span class="ametys-actions-list__item-icon fas fa-share"></span>
                <span class="ametys-actions-list__item-text"><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_SHARE" i18n:catalogue="plugin.odf-web"/></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="cart-action-download">
        <li class="ametys-actions-list__item">
            <a class="ametys-actions-list__link" href="javascript:void()" onclick="ODFCart.download('{ametys:site()}')">
                <span class="ametys-actions-list__item-icon fas fa-cloud-download-alt"></span>
                <span class="ametys-actions-list__item-text"><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_DOWNLOAD" i18n:catalogue="plugin.odf-web"/></span>
            </a>
        </li>   
    </xsl:template>
    
    <xsl:template name="cart-totals">
        <ul class="ametys-total-info" style="display: none">
            <xsl:call-template name="cart-total-ects"/>
            <xsl:call-template name="cart-total-hours"/>
        </ul>
    </xsl:template>
    
    <xsl:template name="cart-total-ects">
        <li class="ametys-total-info__item ametys-total-info__item-ects">
            <span class="ametys-total-info__item-left-section"><i18n:text i18n:key="PLUGINS_ODFWEB_CART_TOTAL_ECTS" i18n:catalogue="plugin.odf-web"/></span>
            <span class="ametys-total-info__item-right-section"></span>
        </li>
    </xsl:template>
    
    <xsl:template name="cart-total-hours">
        <li class="ametys-total-info__item ametys-total-info__item-hours">
            <span class="ametys-total-info__item-left-section"><i18n:text i18n:key="PLUGINS_ODFWEB_CART_TOTAL_HOURS" i18n:catalogue="plugin.odf-web"/></span>
            <span class="ametys-total-info__item-right-section"></span>
        </li>
    </xsl:template>
    
    <xsl:template name="cart-share-dialog">
        <div id="odfcart-share-dialog" style="display: none" title="plugin.odf-web:PLUGINS_ODFWEB_SERVICE_CART_SHARE_DIALOG_TITLE" i18n:attr="title">
            <form>
                <p><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_SHARE_DIALOG_HINT" i18n:catalogue="plugin.odf-web"/></p>
                <div class="field form-group g-mb-20">
                    <input name="email" class="form-control form-control-md rounded-0" type="email" placeholder="plugin.odf-web:PLUGINS_ODFWEB_SERVICE_CART_SHARE_FIELD_EMAIL" i18n:attr="placeholder"/>
                    <small class="form-text text-muted g-font-size-12 g-mt-5 g-px-2"><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_SHARE_FIELD_EMAIL_HINT" i18n:catalogue="plugin.odf-web"/></small>
                </div>
                <div class="field form-group g-mb-20">
                    <textarea name="message" class="form-control form-control-md rounded-0" rows="3" placeholder="plugin.odf-web:PLUGINS_ODFWEB_SERVICE_CART_SHARE_FIELD_MESSAGE" i18n:attr="placeholder"></textarea>
                </div>
            </form>
        </div>
    </xsl:template>
    
</xsl:stylesheet>
