<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
                xmlns:captcha="org.ametys.core.captcha.CaptchaHelper"
                extension-element-prefixes="math ametys resolver escaper captcha">
    
    <xsl:import href="plugin:web://pages/services/user-signup/signup_3.5.xsl"/>
    
    <xsl:variable name="skin" select="ametys:skin()"/>
    
    <xsl:variable name="common-service-css-class-name">ametys-authorization-checkout</xsl:variable>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/create-account/scss/main.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title-rendering">
        <xsl:param name="title"/>
   
        <h1 class="ametys-authorization__title"><xsl:copy-of select="$title"/></h1>
   </xsl:template>
    
    <xsl:template name="account-form">
        <xsl:call-template name="bo-warnings"/>
        
        <xsl:call-template name="global-errors-message"/>
        
        <xsl:call-template name="errors-message"/>
        
        <xsl:choose>
            <xsl:when test="not(/user-signup/warnings/warning)">
                <xsl:call-template name="account-form-hint-message"/>
                
                <form method="post" id="signup-{$uniqueId}">
                    <xsl:if test="$current-page-id != ''">
                        <xsl:attribute name="action">
                            <xsl:value-of select="resolver:resolve('page', $current-page-id)"/>
                        </xsl:attribute>
                    </xsl:if>
                    <xsl:call-template name="form-attributes"/>
                    <xsl:choose>
                        <xsl:when test="$step = 'password'">
                            <xsl:call-template name="continue-signup-fields"/>
                        </xsl:when>
                        <xsl:when test="$step = 'new-token'">
                            <xsl:call-template name="new-token-form-fields"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template name="temp-signup-fields"/>
                        </xsl:otherwise>
                    </xsl:choose>
                    
                    <!-- Template common for submit button -->
                    <xsl:call-template name="common-utils-input-submit">
                        <xsl:with-param name="class-name">btn btn-primary btn-lg btn-block btn-shadow rounded-0</xsl:with-param>
                        <xsl:with-param name="i18nkey"><xsl:value-of select="concat('skin.', $skin, ':SKIN_USER_SIGNUP_VIEW_SUBMIT')"/></xsl:with-param>
                    </xsl:call-template>
                </form>    
            </xsl:when>
            <xsl:when test="$rendering-context != 'back'">
                <p class="g-color-red"><i18n:text i18n:catalogue="plugin.web" i18n:key="PLUGINS_WEB_SERVICE_USER_SIGNUP_AVAILABLE_SERVICE"/></p>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="account-form-hint-message"/>
    
    <xsl:template name="errors-message">
        <xsl:if test="/user-signup/errors/field/error">
            <div class="g-color-red">
                <p>
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_WEB_USER_SIGNUP_FORM_ERROR_TITLE" i18n:catalogue="plugin.web"/>
                        <i18n:param><xsl:value-of select="count(/user-signup/errors/field/error)"/></i18n:param>
                    </i18n:translate>
                </p>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="global-errors-message">
        <xsl:variable name="error-general" select="/user-signup/errors/global/error[@type = 'general-error']"/>
        <xsl:variable name="error-user-email-already-exists" select="/user-signup/errors/global/error[@type = 'user-email-already-exists']"/>
        <xsl:variable name="error-temp-email-already-exists" select="/user-signup/errors/global/error[@type = 'temp-email-already-exists']"/>
        <xsl:variable name="error-token-unknown" select="/user-signup/errors/global/error[@type = 'error-token-unknown']"/>
        <xsl:variable name="error-token-expired" select="/user-signup/errors/global/error[@type = 'error-token-expired']"/>
        <xsl:variable name="error-temp-email-unknown" select="/user-signup/errors/global/error[@type = 'temp-email-unknown']"/> 
        
        <xsl:if test="/user-signup/errors/global">
            <div class="g-color-red">
                <ul class="list-unstyled">
                    <xsl:if test="$error-general">
                        <li class="media">
                            <i class="fas fa-window-close mr-3"></i>
                            <div class="media-body">
                                <i18n:text i18n:key="PLUGINS_WEB_USER_SIGNUP_ERROR_GENERAL" i18n:catalogue="plugin.web"/>
                            </div>
                        </li>
                    </xsl:if>
                    <xsl:if test="$error-user-email-already-exists">
                        <li class="media">
                            <i class="fas fa-window-close mr-3"></i>
                            <div class="media-body">
                                <i18n:text i18n:key="PLUGINS_WEB_USER_SIGNUP_ERROR_USER_EMAIL_ALREADY_EXISTS" i18n:catalogue="plugin.web"/>
                                <a href="{resolver:resolve('page', /user-signup/@password-change-page-id)}?mode=lostpassword">
                                    <i18n:text i18n:key="PLUGINS_WEB_USER_SIGNUP_ERROR_USER_EMAIL_ALREADY_EXISTS_LINK" i18n:catalogue="plugin.web"/>
                                </a>
                            </div>
                        </li>
                    </xsl:if>
                    <xsl:if test="$error-temp-email-already-exists">
                        <li class="media">
                            <i class="fas fa-window-close mr-3"></i>
                            <div class="media-body">
                                <i18n:text i18n:key="PLUGINS_WEB_USER_SIGNUP_ERROR_TEMP_EMAIL_ALREADY_EXISTS" i18n:catalogue="plugin.web"/>
                                <a href="{resolver:resolve('page', $current-page-id)}?mode=new-token&amp;email={/user-signup/@email}">
                                    <i18n:text i18n:key="PLUGINS_WEB_USER_SIGNUP_ERROR_TEMP_EMAIL_ALREADY_EXISTS_LINK" i18n:catalogue="plugin.web"/>
                                </a>
                            </div>
                        </li>
                    </xsl:if>
                    <xsl:if test="$error-token-unknown">
                        <li class="media">
                            <i class="fas fa-window-close mr-3"></i>
                            <div class="media-body"><i18n:text i18n:key="PLUGINS_WEB_USER_SIGNUP_ERROR_TOKEN_UNKNOWN" i18n:catalogue="plugin.web"/></div>
                        </li>
                    </xsl:if>
                    <xsl:if test="$error-token-expired">
                        <li class="media">
                            <i class="fas fa-window-close mr-3"></i>
                            <div class="media-body">
                                <i18n:text i18n:key="PLUGINS_WEB_USER_SIGNUP_ERROR_TOKEN_EXPIRED" i18n:catalogue="plugin.web"/>
                                <a href="{resolver:resolve('page', $current-page-id)}?mode=new-token&amp;email={/user-signup/@email}">
                                    <i18n:text i18n:key="PLUGINS_WEB_USER_SIGNUP_ERROR_TOKEN_EXPIRED_LINK" i18n:catalogue="plugin.web"/>
                                </a>
                            </div>
                        </li>
                    </xsl:if>
                    <xsl:if test="$error-temp-email-unknown">
                        <li class="media">
                            <i class="fas fa-window-close mr-3"></i>
                            <div class="media-body">
                                <i18n:text i18n:key="PLUGINS_WEB_USER_SIGNUP_ERROR_TEMP_EMAIL_UNKNOWN" i18n:catalogue="plugin.web"/>
                            </div>
                        </li>
                    </xsl:if>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="error-field">
        <xsl:param name="error" />
        
        <div class="g-color-red">
            <xsl:for-each select="$error">
                <xsl:value-of select="."/>
                <xsl:if test="position() != last()"><br/></xsl:if>
            </xsl:for-each>
        </div>
    </xsl:template>
    
    <xsl:template name="firstname-field">
        <xsl:param name="value"/>
        
        <div class="form-group">
            <div class="sr-only">
                <label for="firstname-{$uniqueId}">
                    <i18n:text i18n:key="PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_FIRSTNAME" i18n:catalogue="plugin.web"/>
                    
                    <span class="mandatory-marker"><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span>
                </label>
            </div>
            <div>
                <xsl:attribute name="class">
                    <xsl:text>ametys-form-control-with-icon-wrap</xsl:text>
                    <xsl:if test="/user-signup/errors/field[@name = 'firstname']/error"><xsl:text> invalid</xsl:text></xsl:if>
                </xsl:attribute>
                <i class="field-icon fas fa-user"></i>
                <input type="text" id="firstname-{$uniqueId}" name="firstname" value="{$value}" class="ametys-form-control-with-icon" placeholder="plugin.web:PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_FIRSTNAME" i18n:attr="placeholder"/>
            </div>
            <xsl:if test="/user-signup/errors/field[@name = 'firstname']/error">
                <xsl:call-template name="error-field">
                    <xsl:with-param name="error" select="/user-signup/errors/field[@name = 'firstname']/error"/>
                </xsl:call-template>
            </xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template name="lastname-field">
        <xsl:param name="value"/>
        
        <div class="form-group">
            <xsl:if test="/user-signup/errors/field[@name = 'lastname']/error">
                <xsl:call-template name="error-field" >
                    <xsl:with-param name="error" select="/user-signup/errors/field[@name = 'lastname']/error" />
                </xsl:call-template>
            </xsl:if>
            
            <div class="sr-only">
                <label for="lastname-{$uniqueId}">
                    <i18n:text i18n:key="PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_LASTNAME" i18n:catalogue="plugin.web"/>
                    
                    <span class="mandatory-marker"><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span>
                </label>
            </div>
            
            <div>
                <xsl:attribute name="class">
                    <xsl:text>ametys-form-control-with-icon-wrap</xsl:text>
                    <xsl:if test="/user-signup/errors/field[@name = 'lastname']/error"> invalid</xsl:if>
                </xsl:attribute>
                <i class="field-icon fas fa-user"></i>
                <input type="text" id="lastname-{$uniqueId}" name="lastname" value="{$value}" class="ametys-form-control-with-icon" placeholder="plugin.web:PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_LASTNAME" i18n:attr="placeholder"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="email-field">
        <xsl:param name="value"/>
        
        <div class="form-group">
            <xsl:if test="/user-signup/errors/field[@name = 'email']/error">
                <xsl:call-template name="error-field" >
                    <xsl:with-param name="error" select="/user-signup/errors/field[@name = 'email']/error" />
                </xsl:call-template>
            </xsl:if>
            
            <div class="sr-only">
                <label for="email-{$uniqueId}">
                    <i18n:text i18n:key="PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_EMAIL" i18n:catalogue="plugin.web"/>
                    
                    <span class="mandatory-marker"><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span>
                </label>
            </div>
        
            <div>
                <xsl:attribute name="class">
                    <xsl:text>ametys-form-control-with-icon-wrap</xsl:text>
                    <xsl:if test="/user-signup/errors/field[@name = 'email']/error"> invalid</xsl:if>
                </xsl:attribute>
                <span class="field-icon fas fa-envelope"></span>
                <input type="text" id="email-{$uniqueId}" name="email" value="{$value}" class="ametys-form-control-with-icon" placeholder="plugin.web:PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_EMAIL" i18n:attr="placeholder"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="password-field">
        <xsl:param name="id"/>
        <xsl:param name="name"/>
        <xsl:param name="value"/>
        <xsl:param name="i18nKey"/>
        <xsl:param name="confirm"/>
        <xsl:param name="errors"/>
        
        <div class="form-group">
            <xsl:if test="$confirm != true() and /user-signup/errors/field[@name = 'password']/error">
                <xsl:call-template name="error-field" >
                    <xsl:with-param name="error" select="/user-signup/errors/field[@name = $name]/error" />
                </xsl:call-template>
            </xsl:if>
            <div class="sr-only">
                <label for="{$id}">
                    <i18n:text i18n:key="{$i18nKey}" i18n:catalogue="plugin.web"/>
                    <span class="mandatory-marker"><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span>
                </label>
            </div>
            <div>
                <xsl:attribute name="class">
                    <xsl:text>ametys-form-control-with-icon-wrap</xsl:text>
                    <xsl:if test="$errors/field[@name = 'password']/error"> invalid</xsl:if>
                </xsl:attribute>
                
                <xsl:choose>
                    <xsl:when test="$confirm = true()">
                        <span class="field-icon fas fa-check"></span>
                    </xsl:when>
                    <xsl:otherwise>
                        <span class="field-icon fas fa-lock"></span>
                    </xsl:otherwise>
                </xsl:choose>
                <input type="password" id="{$id}" name="{$name}" autocomplete="new-password" class="ametys-form-control-with-icon" placeholder="plugin.web:{$i18nKey}" i18n:attr="placeholder">
                    <xsl:if test="$value != ''"><xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute></xsl:if>
                </input>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="captcha-field">
        <div class="form-group">
            <xsl:if test="/user-signup/errors/field[@name = 'captcha']/error">
                <xsl:call-template name="error-field" >
                    <xsl:with-param name="error" select="/user-signup/errors/field[@name = 'captcha']/error" />
                </xsl:call-template>
            </xsl:if>
            
            <xsl:if test="captcha:requiresUserInteraction()">
                <div class="sr-only">
                    <label for="signup-{$uniqueId}-captcha">
                        <i18n:text i18n:key="PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_CAPTCHA" i18n:catalogue="plugin.web"/>
                        <span class="mandatory-marker"><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span>
                    </label>
                </div>
            </xsl:if>
            
            <div>
                <xsl:if test="$captchaType = 'jcaptcha'"><xsl:attribute name="class">ametys-captcha-control-with-icon-wrap</xsl:attribute></xsl:if>
	            <xsl:call-template name="captcha">
	                <xsl:with-param name="key-name">captcha-key</xsl:with-param>
	                <xsl:with-param name="key-id">signup-<xsl:value-of select="$uniqueId"/>-captcha-key</xsl:with-param>
	                <xsl:with-param name="placeholder-i18n" select="true()"/>
	                <xsl:with-param name="placeholder">PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_CAPTCHA</xsl:with-param>
	                <xsl:with-param name="placeholder-catalogue">plugin.web</xsl:with-param>
	                
	                
	                <xsl:with-param name="value-name">captcha</xsl:with-param>
	                <xsl:with-param name="value-id">signup-<xsl:value-of select="$uniqueId"/>-captcha</xsl:with-param>
	                <xsl:with-param name="value-class">ametys-form-control-with-icon</xsl:with-param>
	                
	                <xsl:with-param name="image-alt"/>
	                <xsl:with-param name="image-alt-i18n" select="false()"/>
	                <xsl:with-param name="image-class"></xsl:with-param>
	                
	                <xsl:with-param name="js-funcname-torefresh" select="concat('refresh_captcha_', $uniqueId)"/>
	            </xsl:call-template> 
            </div>
       </div>
    </xsl:template>
    
    <xsl:template name="tos-field">
        <xsl:param name="tos-mode"/>
        <xsl:param name="tos-page-id"/>
        <xsl:param name="tos-link-label"/>
        
        <div class="form-group d-flex align-items-center mb-5">
            <xsl:if test="/user-signup/errors/field[@name = 'tos']/error">
                <xsl:call-template name="error-field" >
                    <xsl:with-param name="error" select="/user-signup/errors/field[@name = 'tos']/error" />
                </xsl:call-template>
            </xsl:if>
            
            <div>
                <xsl:attribute name="class">
                    <xsl:text>ametys-checkbox ametys-checkbox--light ametys-checkbox--lg mb-0</xsl:text>
                    <xsl:if test="/user-signup/errors/field[@name = 'tos']/error"> invalid</xsl:if>
                </xsl:attribute>
                
                <input type="checkbox" name="tos" id="tos-{$uniqueId}" value="true" class="ametys-checkbox__control"/>
                <label for="tos-{$uniqueId}" class="ametys-checkbox__label">
                    <xsl:choose>
                        <xsl:when test="$tos-mode = 'CONTENT'">
                            <i18n:text i18n:key="PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_ACCEPT_TOS_CONTENT" i18n:catalogue="plugin.web"/>
                        </xsl:when>
                        <xsl:when test="$tos-link-label != ''">
                            <a href="{resolver:resolve('page', $tos-page-id)}" target="_blank">
                                <xsl:value-of select="$tos-link-label"/>
                            </a>
                        </xsl:when>
                        <xsl:otherwise>
                            <i18n:text i18n:key="PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_ACCEPT_TOS" i18n:catalogue="plugin.web"/>
                            <xsl:text> </xsl:text>
                            <a href="{resolver:resolve('page', $tos-page-id)}" target="_blank">
                                <i18n:text i18n:key="PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_ACCEPT_TOS_LINK" i18n:catalogue="plugin.web"/>
                            </a>
                        </xsl:otherwise>
                    </xsl:choose>
                </label>
                
            </div>
        </div>
    </xsl:template>
    
</xsl:stylesheet>