<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:cms="http://ametys.org/cms/3.0"
        exclude-result-prefixes="sitemap ametys resolver odf cms">
    
    <xsl:template match="fieldset[@name = 'key-info']" mode="display">
       <xsl:variable name="self" select="."/>
       
       <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <section class="g-mb-55">
												
				<h2 class="ametys-section-title"><xsl:value-of select="label"/></h2>
				
				<div class="ametys-richtext">
					<table class="data" style="width: 100%;">
						<tbody>
    						<tr></tr>
                            <xsl:apply-templates select="metadata" mode="key-info" />
                        </tbody>
                    </table>
                </div>
            </section>
       </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@type = 'content']" mode="key-info">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        <xsl:param name="definition" select="."/>
        
        <xsl:if test="$value and $value/@id">
            <xsl:apply-templates select="." mode="key-info-row">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata" mode="key-info">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        <xsl:param name="definition" select="."/>
        
        <xsl:if test="$value and $value != ''">
            <xsl:apply-templates select="." mode="key-info-row">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata" mode="key-info-row">
        <xsl:param name="value"/>
        <xsl:param name="definition" select="."/>
        
        <tr>
            <td style="width: 34px;">
                <xsl:apply-templates select="." mode="key-info-icon"/>
            </td>
            <th>
                <p><xsl:value-of select="label"/></p>
            </th>
            <td style="width: 215px;">
                <xsl:apply-templates select="$definition" mode="key-info-value">
                    <xsl:with-param name="value" select="$value"/>
                </xsl:apply-templates>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template match="metadata" mode="key-info-value">
        <xsl:param name="value"/>
        <xsl:param name="definition" select="."/>
        
        <p>
            <xsl:for-each select="$value">
                <xsl:if test="position() != 1"><br/></xsl:if>
                <xsl:apply-templates select="$definition" mode="value">
                    <xsl:with-param name="value" select="."/>
                </xsl:apply-templates>
            </xsl:for-each>
        </p>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'erasmusCode']|metadata[@name = 'romeCode']|metadata[@name = 'fapCode']|metadata[@name = 'nsfCode']|metadata[@name = 'siseCode']|metadata[@name = 'dgesipCode']" mode="key-info-icon">
        <span class="ametys-icon-code"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'place']|metadata[@name = 'campus']|metadata[@name = 'geocode']" mode="key-info-icon">
        <span class="ametys-icon-pin"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'duration']|metadata[@name = 'teachingStart']|metadata[@name = 'teachingEnd']" mode="key-info-icon">
        <span class="ametys-icon-clock-alt"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'speciality']" mode="key-info-icon">
        <span class="fas fa-star"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'programField']|metadata[@name = 'availableCertification']|metadata[@name = 'formofteachingOrg']" mode="key-info-icon">
        <span class="ametys-icon-compas"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'programField']|metadata[@name = 'availableCertification']|metadata[@name = 'formofteachingOrg']" mode="key-info-icon">
        <span class="ametys-icon-protection"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'degree']|metadata[@name = 'mention']|metadata[@name = 'availableCertification']" mode="key-info-icon">
        <span class="ametys-icon-graduation-cap"></span>
    </xsl:template>
    
    <!-- Default icon for a key information -->
    <xsl:template match="metadata" mode="key-info-icon">
        <span class="ametys-icon-book"></span>
    </xsl:template>

</xsl:stylesheet>