<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:cms="http://ametys.org/cms/3.0"
                            xmlns:func="http://exslt.org/functions"
                            xmlns:fo="http://www.w3.org/1999/XSL/Format"
                            xmlns:docbook="http://docbook.org/ns/docbook" 
                            xmlns:dyn="http://exslt.org/dynamic"
                            xmlns:exslt="http://exslt.org/common"
                            xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
                            exclude-result-prefixes="ametys resolver cms dyn func odf">
    
    <xsl:import href="skin://stylesheets/content/default-content.xsl"/>
    
    <!-- // Fieldset -->
    <xsl:template match="fieldset[@role='tab']" mode="display">
        <xsl:variable name="self" select="."/>
        
        <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <fo:block xsl:use-attribute-sets="fieldset-title">
                <fo:block xsl:use-attribute-sets="fieldset-title-body">
                    <xsl:value-of select="label"/>
                </fo:block>
            </fo:block>
            
            <xsl:apply-templates select="fieldset|metadata" mode="display"/> 
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="fieldset[@role='fieldset']" mode="display">
        <xsl:apply-templates select="fieldset|metadata" mode="display"/>
    </xsl:template>
    
    <xsl:attribute-set name="fieldset-title"/>
    <xsl:attribute-set name="fieldset-title-body"/>
    
    <!-- // End fieldset -->
    
    <xsl:template match="metadata[@name='presentation' and @type='rich-text']" mode="display" priority="100">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="cms:isNotRichTextEmpty($value)">
            <fo:block>
                <fo:block xsl:use-attribute-sets="section-body">
                     <xsl:apply-templates select="$value/docbook:article">
                        <xsl:with-param name="level" select="2"/>
                    </xsl:apply-templates>
                </fo:block>
            </fo:block>
        </xsl:if>
    </xsl:template>
    
    <!-- // RichText -->
    <xsl:template match="metadata[@type='rich-text']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="cms:isNotRichTextEmpty($value)">
            <fo:block>
                <fo:block xsl:use-attribute-sets="section-title">
                    <xsl:value-of select="label"/>
                </fo:block>
                <fo:block xsl:use-attribute-sets="section-body">
                     <xsl:variable name="definition" select="."/>                      
                     <xsl:apply-templates select="$definition" mode="value">
                        <xsl:with-param name="value" select="$value"/>
                     </xsl:apply-templates>
                </fo:block>
            </fo:block>
        </xsl:if>
    </xsl:template>
    <xsl:attribute-set name="section-title"/>
    <xsl:attribute-set name="section-body"/>
    
    <xsl:template match="metadata[@type='rich-text']" mode="value">
        <xsl:param name="value"/>
        <xsl:param name="level" select="1"/>
        
        <xsl:apply-templates select="$value/docbook:article">
            <xsl:with-param name="level" select="$level"/>
        </xsl:apply-templates>
    </xsl:template>
    <!-- // End RichText -->
    
    <!-- // Content -->
    <xsl:template match="metadata[@type='content']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="contentId" select="$value/@id" />
        <xsl:if test="$contentId != ''">
            <xsl:value-of select="$value/@title"/>
        </xsl:if>
    </xsl:template>
    <!-- // End Content -->
    
    <!-- // Repeater -->
    <xsl:template match="metadata[@type = 'repeater']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
         
        <xsl:if test="$value/@entryCount != '0'">
            <fo:block xsl:use-attribute-sets="repeater">
                <fo:block xsl:use-attribute-sets="repeater-label"><xsl:value-of select="label"/></fo:block>
                <fo:block xsl:use-attribute-sets="repeater-body">
                    <xsl:variable name="definition" select="."/>
                    
                    <xsl:for-each select="$value">
                        <xsl:if test="position() != 1"><br/></xsl:if>
                        <xsl:apply-templates select="$definition" mode="value">
                            <xsl:with-param name="value" select="."/>
                        </xsl:apply-templates>
                    </xsl:for-each>
                </fo:block>
            </fo:block>
        </xsl:if>
    </xsl:template>
    <xsl:template match="metadata[@type='repeater']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="repeaterDef" select="."/>
                    
        <xsl:for-each select="$value/entry">
            <fo:block xsl:use-attribute-sets="repeater-entry">
                <xsl:for-each select="*">
                    <xsl:variable name="name" select="local-name()"/>
                    <xsl:apply-templates select="$repeaterDef/metadata[@name = $name]" mode="display">
                        <xsl:with-param name="value" select="."/>
                    </xsl:apply-templates>
                </xsl:for-each>
            </fo:block>
        </xsl:for-each>
    </xsl:template>
    <xsl:attribute-set name="repeater"/>
    <xsl:attribute-set name="repeater-label"/>
    <xsl:attribute-set name="repeater-body"/>
    <xsl:attribute-set name="repeater-entry"/>
    
    <!-- // End Repeater -->
    
    <xsl:template match="metadata[@type='geocode']" mode="display"/>
    
    <!-- // Default rendering -->
    <xsl:template match="metadata" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <fo:block>
                <xsl:call-template name="para-style"/>
                
                <fo:inline font-weight="bold"><xsl:value-of select="label"/> : </fo:inline>
                
                <xsl:variable name="definition" select="."/>
                <xsl:for-each select="$value">
                    <xsl:if test="position() != 1">, </xsl:if>
                    <xsl:apply-templates select="$definition" mode="value">
                        <xsl:with-param name="value" select="."/>
                    </xsl:apply-templates>
                </xsl:for-each>
            </fo:block>
        </xsl:if>
    </xsl:template>
    <!-- // End Default rendering -->
    
    <!-- // Benefits -->
    <xsl:template match="fieldset[@name = 'benefits']" mode="display">
       <xsl:variable name="self" select="."/>
       
       <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <!-- Filter on nom-empty benefits -->
            <xsl:variable name="nonEmptyBenefits">
                <xsl:for-each select="metadata">
                    <xsl:variable name="name" select="@name"/>
                    <xsl:variable name="value" select="/view/content/metadata/*[local-name() = $name]"/>
                    <xsl:if test="$value">
                        <xsl:copy-of select="."/>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            
            <xsl:variable name="values" select="/view/content/metadata"/>
            
            <!-- Display of the first 5 benefits (or less) in a table  -->
            <fo:block xsl:use-attribute-sets="benefits-block">
                <fo:table>
                    <fo:table-column/>
                    <fo:table-column/>
                    <fo:table-column/>
                    <fo:table-column/>
                    <fo:table-column/>
                    <fo:table-body>
                        <fo:table-row>
                            <xsl:for-each select="exslt:node-set($nonEmptyBenefits)/metadata[position() &lt;= 5]">
                                <xsl:variable name="name" select="@name"/>
                                <xsl:variable name="value" select="$values/*[local-name() = $name]"/>
                                <xsl:apply-templates select="." mode="benefits">
                                    <xsl:with-param name="value" select="$value"/>
                                </xsl:apply-templates>
                            </xsl:for-each>
                        </fo:table-row>
                    </fo:table-body>
                </fo:table>
            </fo:block>
            
            <!-- Display of the next 5 benefits (or less) in a second table (Be careful: a maximum of 10 benefits are supported) -->
            <xsl:if test="count(exslt:node-set($nonEmptyBenefits)/metadata) > 5">
                <fo:block xsl:use-attribute-sets="benefits-block">
                    <fo:table>
                        <fo:table-column/>
                        <fo:table-column/>
                        <fo:table-column/>
                        <fo:table-column/>
                        <fo:table-column/>
                        <fo:table-body>
                            <fo:table-row>
                                <xsl:for-each select="exslt:node-set($nonEmptyBenefits)/metadata[position() > 5 and position() &lt;= 10]">
                                    <xsl:variable name="name" select="@name"/>
                                    <xsl:variable name="value" select="$values/*[local-name() = $name]"/>
                                    <xsl:apply-templates select="." mode="benefits">
                                        <xsl:with-param name="value" select="$value"/>
                                    </xsl:apply-templates>
                                </xsl:for-each>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                </fo:block>
            </xsl:if>   
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata" mode="benefits">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <xsl:variable name="definition" select="."/>
            
            <fo:table-cell>
                <fo:block>
                    <fo:table>
                        <fo:table-column column-width="10mm" />
                        <fo:table-column />
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell vertical-align="top">
                                    <xsl:apply-templates select="$definition" mode="benefits-icon" />
                                </fo:table-cell>
                                <fo:table-cell>
                                    <fo:block xsl:use-attribute-sets="benefits-header">
                                        <xsl:value-of select="label" />
                                    </fo:block>
                                    <fo:block xsl:use-attribute-sets="benefits-value">
                                        <xsl:for-each select="$value">
                                            <xsl:if test="position() != 1">, </xsl:if>
                                            <xsl:apply-templates select="$definition" mode="value">
                                                <xsl:with-param name="value" select="." />
                                            </xsl:apply-templates>
                                        </xsl:for-each>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                </fo:block>
            </fo:table-cell>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'nbHours']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:value-of select='format-number($value, "#,##")' />h
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'ects' and @type = 'content']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:value-of select="$value/@title"/> <i18n:text i18n:key="PROGRAM_ECTS_UNITS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'ects' and @type = 'double']" mode="value">
        <xsl:param name="value"/>

        <xsl:variable name="currentEcts" select="odf:getCurrentEcts($value)"/>
        <xsl:variable name="ects"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="$currentEcts"/></xsl:call-template></xsl:variable>
        <xsl:value-of select="$ects"/> <i18n:text i18n:key="PROGRAM_ECTS_UNITS" i18n:catalogue="skin.{$skin}"/>
        
        <xsl:if test="odf:areECTSEqual() = false()">
            <fo:footnote>
              <fo:inline baseline-shift="super" font-size="80%"> (1)</fo:inline> 
              <fo:footnote-body>
                 <fo:block font-size="80%" font-style="italic">                         
                       (1) <i18n:text i18n:key="PROGRAM_ECTS_MULTIPLE_FOOT_NOTE" i18n:catalogue="skin.{$skin}"/>
                 </fo:block>
              </fo:footnote-body>
           </fo:footnote> 
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'educationLevel']" mode="benefits-icon">
        <fo:block xsl:use-attribute-sets="benefits-icon" font-family="FontAwesome" font-weight="bold" font-size="18px">
            &#xf140;
        </fo:block>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'duration']" mode="benefits-icon">
        <fo:block xsl:use-attribute-sets="benefits-icon" font-family="FontAwesome" font-weight="normal" font-size="18px">
            &#xf017;
        </fo:block>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'ects']" mode="benefits-icon">
        <fo:block xsl:use-attribute-sets="benefits-icon" font-family="FontAwesome" font-weight="bold" font-size="18px">
            &#xf5a2;
        </fo:block>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'orgUnit']" mode="benefits-icon">
        <fo:block xsl:use-attribute-sets="benefits-icon" font-family="FontAwesome" font-weight="bold" font-size="18px">
            &#xf66f;
        </fo:block>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'educationLanguage']" mode="benefits-icon">
        <fo:block xsl:use-attribute-sets="benefits-icon" font-family="FontAwesome" font-weight="bold" font-size="18px">
            &#xf57d;
        </fo:block>
    </xsl:template>
    
    <xsl:template match="metadata" mode="benefits-icon">
        <fo:block xsl:use-attribute-sets="benefits-icon" font-family="FontAwesome" font-weight="bold" font-size="20px">
            &#xf017;
        </fo:block>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'orgUnit']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:value-of select="$value/@title"/>
    </xsl:template>
    
    <xsl:attribute-set name="benefits-block"/>
    <xsl:attribute-set name="benefits-icon"/>
    <xsl:attribute-set name="benefits-header"/>
    <xsl:attribute-set name="benefits-value"/>
    <!-- // End Benefits -->
</xsl:stylesheet>